/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DataCollectionPanel.java
 *
 * Created on August 27, 2003, 5:04 PM
 */

package com.sun.enterprise.tools.upgrade.gui;

/**
 *
 * @author  prakash
 */
import javax.swing.JFileChooser;
import com.sun.enterprise.tools.upgrade.gui.util.*;
import java.util.logging.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.tools.upgrade.common.*;
import com.sun.enterprise.tools.upgrade.logging.*;

public class DataCollectionPanel extends javax.swing.JPanel {

    private FlowLabel flowContentLabel;
    private javax.swing.JLabel sourceDirLabel;
    private javax.swing.JTextField sourceDirTextField;
    private javax.swing.JButton sourceDirectoryBrowseButton;
    private javax.swing.JButton destDirBrowseButton;
    private javax.swing.JLabel destDirLabel;
    private javax.swing.JTextField destDirTextField;
    private javax.swing.JPanel containerPanel;
    private javax.swing.JCheckBox upgradeCertificates;
    private javax.swing.JPasswordField adminPWTextField;
    private javax.swing.JTextField adminUserTextField;
    private javax.swing.JPasswordField masterPWTextField;
    
    private CommonInfoModel commonInfoModel;

    private JFileChooser fileChooser = null;
    private java.util.Vector dialogListeners = new java.util.Vector();
    
    private StringManager stringManager = StringManager.getManager("com.sun.enterprise.tools.upgrade.gui");
    private Logger logger = com.sun.enterprise.tools.upgrade.common.CommonInfoModel.getDefaultLogger();
    
    /** Creates new form DataCollectionPanel */
    public DataCollectionPanel(CommonInfoModel coInfoModel) {
        this.commonInfoModel = coInfoModel;
        initialize();  
    } 
    private void initialize(){
	initComponents();
        this.setLayout(new java.awt.BorderLayout());
        HeaderPanel headerPanel = new HeaderPanel(stringManager.getString("upgrade.gui.detailspanel.headerPanel"));
        headerPanel.setInsets(new java.awt.Insets(12, 10, 5, 10));
        add(headerPanel, "North");
        add(containerPanel, "Center");
        sourceDirectoryBrowseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sourceActionPerformed(evt);
            }
        });
        destDirBrowseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                destActionPerformed(evt);
            }
        });
        getfileChooser().setFileSelectionMode(javax.swing.JFileChooser.DIRECTORIES_ONLY);
        java.awt.event.KeyAdapter keyAdapter = new java.awt.event.KeyAdapter(){
            public void keyReleased(java.awt.event.KeyEvent ke){
                processDialogEvent();
            }
        };
        sourceDirTextField.addKeyListener(keyAdapter);       
        destDirTextField.addKeyListener(keyAdapter);  
        String sourceDir=commonInfoModel.getSourceInstallDir();
        String targetDir=commonInfoModel.getTargetDomainRoot();
        if(sourceDir != null && !(sourceDir.equals("")))
            sourceDirTextField.setText(sourceDir);
        if(targetDir != null && !(targetDir.equals("")))
            destDirTextField.setText(targetDir);
        
        String adminUserName = commonInfoModel.getAdminUserName();
        String adminPassword = commonInfoModel.getAdminPassword();
        adminUserTextField.addKeyListener(keyAdapter);       
        adminPWTextField.addKeyListener(keyAdapter);  
        
        if(adminUserName != null && !(adminUserName.equals("")))
            adminUserTextField.setText(adminUserName);
        if(adminPassword != null && !(adminPassword.equals("")))
            adminPWTextField.setText(adminPassword);
        
        if(!this.commonInfoModel.getTargetVersionAndEdition().equals(UpgradeConstants.VERSION_AS90_PE)){
            String masterPassword = commonInfoModel.getMasterPassword();
            masterPWTextField.addKeyListener(keyAdapter);  
            if(masterPassword != null && !(masterPassword.equals("")))
                masterPWTextField.setText(masterPassword);
        }
        
    }   
    /** This method is called from within the constructor to
     * initialize the form.
     * always regenerated by the Form Editor.
     */
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        flowContentLabel = new FlowLabel();
        sourceDirLabel = new javax.swing.JLabel();
        sourceDirTextField = new javax.swing.JTextField();
        sourceDirectoryBrowseButton = new javax.swing.JButton();
        destDirLabel = new javax.swing.JLabel();
        destDirTextField = new javax.swing.JTextField();
        destDirBrowseButton = new javax.swing.JButton();        
	containerPanel = new javax.swing.JPanel();

        containerPanel.setLayout(new java.awt.GridBagLayout());

        flowContentLabel.setText(stringManager.getString("upgrade.gui.detailspanel.flowContentLable"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0; gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2; gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 5, 0);
        gridBagConstraints.weightx = 1.0;
        containerPanel.add(flowContentLabel, gridBagConstraints);
        
        sourceDirLabel.setText(stringManager.getString("upgrade.gui.detailspanel.sourceDirLabel"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0; gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1; gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 3, 10);
        gridBagConstraints.weightx = 1.0;
        containerPanel.add(sourceDirLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1; gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 5);
        gridBagConstraints.weightx = 1.0;
        containerPanel.add(sourceDirTextField, gridBagConstraints);

        sourceDirectoryBrowseButton.setText(stringManager.getString("upgrade.gui.detailspanel.browseButtonText"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1; gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 10, 10);
        containerPanel.add(sourceDirectoryBrowseButton, gridBagConstraints);

        destDirLabel.setText(stringManager.getString("upgrade.gui.detailspanel.targetDirLabel"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1; gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 3, 10);
        gridBagConstraints.weightx = 1.0;
        containerPanel.add(destDirLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1; gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 5);
        gridBagConstraints.weightx = 1.0;
        containerPanel.add(destDirTextField, gridBagConstraints);

        destDirBrowseButton.setText(stringManager.getString("upgrade.gui.detailspanel.browseButtonText"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 10, 5);
        containerPanel.add(destDirBrowseButton, gridBagConstraints);
        
        upgradeCertificates = new javax.swing.JCheckBox(stringManager.getString("upgrade.gui.detailspanel.transferCertCheckBoxText"),false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0;
        containerPanel.add(upgradeCertificates, gridBagConstraints);
        
        javax.swing.JPanel adminUserPwPanel = getAdminUserPasswordPanel();
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0; gridBagConstraints.gridy = 6; 
        gridBagConstraints.gridheight = 1; gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 3, 10);
        gridBagConstraints.weightx = 1.0; gridBagConstraints.weighty = 0.0;
        containerPanel.add(adminUserPwPanel, gridBagConstraints);
        
        if(this.commonInfoModel.getTargetVersionAndEdition().equals(UpgradeConstants.VERSION_AS90_PE)){
            javax.swing.JPanel dummyPanel = new javax.swing.JPanel();
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 0; gridBagConstraints.gridy = 7; 
            gridBagConstraints.gridheight = 1; gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints.insets = new java.awt.Insets(0, 10, 3, 10);
            gridBagConstraints.weightx = 1.0; gridBagConstraints.weighty = 1.0;
            containerPanel.add(dummyPanel, gridBagConstraints);     
        }
    }
    private javax.swing.JPanel getAdminUserPasswordPanel(){
        javax.swing.JPanel panel = new javax.swing.JPanel();
        java.awt.GridBagConstraints gridBagConstraints;
        javax.swing.JLabel admiUserLabel = new javax.swing.JLabel();
        javax.swing.JLabel admiPWLabel = new javax.swing.JLabel();
        adminUserTextField = new javax.swing.JTextField();
        adminPWTextField = new javax.swing.JPasswordField();
        
        panel.setLayout(new java.awt.GridBagLayout());
        
        admiUserLabel.setText(stringManager.getString("upgrade.gui.detailspanel.adminUserLabel"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0; gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1; gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 3, 20);
        gridBagConstraints.weightx = 1.0;
        panel.add(admiUserLabel, gridBagConstraints);
        
        admiPWLabel.setText(stringManager.getString("upgrade.gui.detailspanel.adminPWLabel"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1; gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1; gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 20, 3, 10);
        gridBagConstraints.weightx = 1.0;
        panel.add(admiPWLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1; gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 5, 20);
        gridBagConstraints.weightx = 1.0;
        panel.add(adminUserTextField, gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1; gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 5, 10);
        gridBagConstraints.weightx = 1.0;
        panel.add(adminPWTextField, gridBagConstraints);        
        
        if(!this.commonInfoModel.getTargetVersionAndEdition().equals(UpgradeConstants.VERSION_AS90_PE)){
            javax.swing.JLabel masterPWLabel = new javax.swing.JLabel();
            masterPWTextField = new javax.swing.JPasswordField();
            masterPWLabel.setText(stringManager.getString("upgrade.gui.detailspanel.masterPWLabel"));
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 0; gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2; gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.insets = new java.awt.Insets(10, 10, 3, 5);
            gridBagConstraints.weightx = 1.0;
            panel.add(masterPWLabel, gridBagConstraints);
        
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1; gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.insets = new java.awt.Insets(0, 10, 10, 5);
            gridBagConstraints.weightx = 1.0;
            panel.add(masterPWTextField, gridBagConstraints);     
            
            javax.swing.JPanel dummyPanel = new javax.swing.JPanel();
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1; gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.insets = new java.awt.Insets(0, 20, 10, 5);
            gridBagConstraints.weightx = 1.0;
            panel.add(dummyPanel, gridBagConstraints);     
        }
        
        return panel;
    }
    
    private void sourceActionPerformed(java.awt.event.ActionEvent evt){
        getfileChooser().setCurrentDirectory(new java.io.File(sourceDirTextField.getText()));
        int returnedValue = getfileChooser().showOpenDialog(this);
        if(returnedValue == javax.swing.JFileChooser.APPROVE_OPTION){
            sourceDirTextField.setText(String.valueOf(getfileChooser().getSelectedFile()));
            this.processDialogEvent();
        }
    }
    private void destActionPerformed(java.awt.event.ActionEvent evt){
        getfileChooser().setCurrentDirectory(new java.io.File(destDirTextField.getText()));
        int returnedValue = getfileChooser().showOpenDialog(this);
        if(returnedValue == javax.swing.JFileChooser.APPROVE_OPTION){
            destDirTextField.setText(String.valueOf(getfileChooser().getSelectedFile()));
            this.processDialogEvent();
        }
    }
    private javax.swing.JFileChooser getfileChooser() {
        if (fileChooser == null) {
            fileChooser = new javax.swing.JFileChooser();
            fileChooser.setName("fileChooser");
            fileChooser.setBounds(668, 49, 500, 300);
            fileChooser.setDialogTitle(stringManager.getString("upgrade.gui.detailspanel.fileChooseTitle"));
            
        }
        return fileChooser;
    }
    public String getSourceDirectoryPath(){
        return this.sourceDirTextField.getText();
    }
    public String getDestinationDirectoryPath(){
        return this.destDirTextField.getText();
    }
    public String getAdminUserName(){
        return this.adminUserTextField.getText();
    }
    public String getAdminPassword(){
        return this.adminPWTextField.getText();
    }
    public String getMasterPassword(){
        return this.masterPWTextField.getText();
    }
    public void addDialogListener(DialogListener listener){
        this.dialogListeners.addElement(listener);
    }
    public boolean isUpgradeCertificatesSelected(){
        return this.upgradeCertificates.isSelected();
    }
    public void removeDialogListener(DialogListener listener){
        this.dialogListeners.removeElement(listener);
    }
    private void processDialogEvent(){
        DialogEvent de = new DialogEvent(this, DialogEvent.CHANGE_ACTION);
        for(int i=0 ; i<this.dialogListeners.size(); i++){
            ((DialogListener)dialogListeners.elementAt(i)).dialogProcessed(de);
        }
    }
    
}
