/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DefaultWebXMLTransfer.java
 *
 * Created on September 8, 2003, 10:56 AM
 */

package com.sun.enterprise.tools.upgrade.miscconfig;

/**
 *
 * @author  prakash
 */
import javax.xml.parsers.DocumentBuilder; 
import javax.xml.parsers.DocumentBuilderFactory;  
import javax.xml.parsers.FactoryConfigurationError;  
import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;  
import org.xml.sax.SAXParseException;  

import java.io.File;
import java.io.IOException;

import org.w3c.dom.Document;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

// For transformation.  Not really needed to retain.
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;

import javax.xml.transform.dom.DOMSource;  
import javax.xml.transform.stream.StreamResult; 

import java.io.*;
import java.util.logging.*;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.tools.upgrade.logging.*;

public class DefaultWebXMLTransfer {
    private StringManager stringManager = StringManager.getManager("com.sun.enterprise.tools.upgrade.miscconfig");
    private Logger logger = com.sun.enterprise.tools.upgrade.common.CommonInfoModel.getDefaultLogger();
    /** Creates a new instance of DefaultWebXMLTransfer */
    public DefaultWebXMLTransfer() {
    }
    public void transform(String sourceFileName, String targetFileName){
        logger.log(Level.INFO, stringManager.getString("upgrade.configTransfers.defaultWebXML.startMessage"));
        File sourceFile = new File(sourceFileName);
        File targetFile = new File(targetFileName);
        boolean renamed = targetFile.renameTo(new File(targetFileName+".bak"));
        if(!renamed){
            // This is possible if user is running the upgrade again and .bak is already created.
            renamed = targetFile.delete();
        }
        if(renamed){
            targetFile = new File(targetFileName);
            try{
                targetFile.createNewFile();
                this.transferFileContents(sourceFile, targetFile);
                this.modifyContent(targetFile); 
            }catch(Exception ex){
                // Lot Error
                logger.log(Level.SEVERE, stringManager.getString("upgrade.configTransfers.defaultWebXML.startFailureMessage",ex));
            }                       
        }else{
            // Log error message
            logger.log(Level.SEVERE, stringManager.getString("upgrade.configTransfers.defaultWebXML.renameFailureMessage"));
        }        
        
    }
    private void transferFileContents(File source, File target) throws Exception{
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(source)));
        PrintWriter writer = new PrintWriter(new FileOutputStream(target));
        String readLine = null;
        while((readLine = reader.readLine()) != null){
            writer.println(readLine);
        }
        writer.flush();
        writer.close();
        reader.close();
    }
    private void modifyContent(File xmlFile){
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        //factory.setValidating(true);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((org.xml.sax.helpers.DefaultHandler)Class.forName
                ("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document document = builder.parse( xmlFile );
            Element docEle = document.getDocumentElement();
            // Need to obtain the servlet element named jsp
            NodeList servlets = docEle.getElementsByTagName("servlet");
            for(int lh =0; lh < servlets.getLength(); lh++){
                Element servlet = ((Element)servlets.item(lh));
                NodeList ssNames = servlet.getElementsByTagName("servlet-name");
                // There should be only one servlet-name
                if(this.getTextNodeData((Element)ssNames.item(0)).equals("jsp")){
                    NodeList ssClNames = servlet.getElementsByTagName("servlet-class");
                    this.setTextNodeData((Element)ssClNames.item(0), "org.apache.jasper.servlet.JspServlet");
                    break;
                }
            }
            this.addServletMapping(docEle);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new FileOutputStream(xmlFile));
            transformer.transform(source, result);
            
        }catch (Exception ex){
            // Log error
            logger.log(Level.SEVERE, stringManager.getString("upgrade.configTransfers.defaultWebXML.startFailureMessage",ex.getMessage()), ex);
        }
    }
    private String getTextNodeData(Element element){
        NodeList children = element.getChildNodes();
        for(int index=0; index < children.getLength(); index++){
            if(children.item(index).getNodeType() == Node.TEXT_NODE){
                return children.item(index).getNodeValue();
            }
        }
        return "";
    }    
    private void setTextNodeData(Element element, String text){
        NodeList children = element.getChildNodes();
        for(int index=0; index < children.getLength(); index++){
            if(children.item(index).getNodeType() == Node.TEXT_NODE){
                children.item(index).setNodeValue(text);
            }
        }        
    }    
    private void addServletMapping(Element documentElement){
        Element sMap = documentElement.getOwnerDocument().createElement("servlet-mapping");
        documentElement.appendChild(sMap);
        Element sName = documentElement.getOwnerDocument().createElement("servlet-name");
        Node sNameTextNode = documentElement.getOwnerDocument().createTextNode("jsp");
        sName.appendChild(sNameTextNode);
        sMap.appendChild(sName);
        
        Element urlPat = documentElement.getOwnerDocument().createElement("url-pattern");
        Node urlTextNode = documentElement.getOwnerDocument().createTextNode("*.jspx");
        urlPat.appendChild(urlTextNode);
        sMap.appendChild(urlPat);   
    }
}
