/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PolicyParser.java
 *
 * Created on May 27, 2004, 7:36 AM
 */

package com.sun.enterprise.tools.upgrade.miscconfig;

import java.io.*;
import java.util.Enumeration;

/**
 *
 * @author  Hans Hrasna
 */

public class PolicyParser extends sun.security.provider.PolicyParser {
    
    /** Creates a new instance of PolicyParser */
    public PolicyParser() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
    }
    
    public void write(java.io.Writer policy) {
        PrintWriter out = new PrintWriter(new BufferedWriter(policy));
        
        Enumeration ee = grantElements();
        
        out.println("/* Generated by asupgrade on "+
        (new java.util.Date()) + "         */");
        out.println("/* Copyright 2004 Sun Microsystems, Inc. All rights reserved.     */");
        out.println("/* SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. */");
        out.println();
        
        // write the (unexpanded) keystore entry as the first entry of the
        // policy file
        if (getKeyStoreUrl() != null) {
            writeKeyStoreEntry(out);
        }
        
        // write "grant" entries
        while (ee.hasMoreElements()) {
            GrantEntry ge = (GrantEntry) ee.nextElement();
            ge.write(out);
            out.println();
        }
        out.flush();
        out.close();
    }
    
    /**
     * writes the (unexpanded) keystore entry
     */
    private void writeKeyStoreEntry(PrintWriter out) {
        out.print("keystore \"");
        out.print(getKeyStoreUrl());
        out.print('"');
        String keyStoreType = getKeyStoreType();
        if (keyStoreType != null && keyStoreType.length() > 0)
            out.print(", \"" + keyStoreType + "\"");
        out.println(";");
        out.println();
    }
}
