/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * IIOPListener.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;

import com.sun.enterprise.tools.upgrade.common.*;
import com.sun.enterprise.tools.upgrade.cluster.*;

public class GenericResource extends GenericElement {
    
    private boolean appendingResourceRefToCluster = false;
    private java.util.List insertStructureForResourceRefInCluster = null;
    /** Creates a new instance of Element */
    public GenericResource() {
    }
    /**
     * element - one of the child of resources
     * parentSource - resources element of source
     * parentResult - resources element of result
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        String resourceTagName = element.getTagName();
        if(resourceTagName.equals("jms-resource"))
        {
            // There is this JMSResource class that handles it.
            this.skipGenericElementTransform(element, parentSource, parentResult);
            return;
        }
        //Added for CR 6363168 
        if(resourceTagName.equals("jdbc-connection-pool")) {
            if(element.getAttribute("name").equals("__TimerPool") || 
                    element.getAttribute("name").equals("PointBasePool"))
                return;
        }
        //Added for CR 6363168
        if(resourceTagName.equals("jdbc-resource")) {
            if(element.getAttribute("pool-name").equals("PointBasePool"))
                return;
        }
        super.transform(element, parentSource, parentResult);
        this.updateResourceRef(element, parentResult);        
    }  
    protected void updateResourceRef(Element element, Element parentResult){
        // If the source version is AS8.x then the following is not necessary.
        // Otherwise, AS7.x didnt have server element so, need to add resource-ref to the server element and cluster elements
        if(!commonInfoModel.getSourceVersion().equals(com.sun.enterprise.tools.upgrade.common.UpgradeConstants.VERSION_7X))
            return;
        org.w3c.dom.Attr jndiAttr = element.getAttributeNode("jndi-name");
        if(jndiAttr != null){
            // parentResult is resources, its parent should be domain.  From there get servers and server element.
            NodeList servers = ((Element)parentResult.getParentNode()).getElementsByTagName("servers");
            NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
            // PE there can be only one server.
            if(commonInfoModel.getTargetEdition().equals(com.sun.enterprise.tools.upgrade.common.UpgradeConstants.EDITION_PE)){
                Element serverElement = ((Element)serverList.item(0));
                this.addOrUpdateResourceRef(serverElement, element, parentResult);
            }else{
                if(commonInfoModel.getCurrentCluster() == null){
                    // This must be the scenario for stand alone instances or PE/SE upgrade
                    String serverName = commonInfoModel.getCurrentSourceInstance();
                    if((serverName == null) || ("".equals(serverName.trim()))){
                        // This is the case for AS 8.x PE source
                        serverName = "server";
                    }
                    if(serverName != null){
                        for(int lh =0; lh < serverList.getLength(); lh++){
                            if(serverName.equals(((Element)serverList.item(lh)).getAttribute("name"))){
                                this.addOrUpdateResourceRef((Element)serverList.item(lh), element, parentResult);
                                break;
                            }
                        }
                    }
                }else{
                    String clusterName = commonInfoModel.getCurrentCluster();
                    this.updateResourceRefsForCluster(clusterName, serverList,element,parentResult);
                }
            }           
        }
    }
    private void updateResourceRefsForCluster(String clusterName, NodeList serverRefList, Element element, Element parentResult){
        for(java.util.Iterator dItr = ClustersInfoManager.getClusterInfoManager().getClusterInfoList().iterator(); dItr.hasNext();){
            ClusterInfo cInfo = (ClusterInfo)dItr.next();
            if(cInfo.getClusterName().equals(clusterName)){
                for(java.util.Iterator clItr = cInfo.getClusteredInstanceList().iterator(); clItr.hasNext();){
                    ClusteredInstance clInstance = (ClusteredInstance)clItr.next();
                    String clInstanceName = clInstance.getInstanceName();
                    for(int lh =0; lh < serverRefList.getLength(); lh++){
                        if(clInstanceName.equals(((Element)serverRefList.item(lh)).getAttribute("name"))){
                            this.addOrUpdateResourceRef((Element)serverRefList.item(lh), element, parentResult);
                            break;
                        }
                    }
                }                
            }            
        }
        NodeList clusters = ((Element)parentResult.getParentNode()).getElementsByTagName("clusters");
        if((clusters != null) && (clusters.getLength() > 0)){
            NodeList clustersList = ((Element)clusters.item(0)).getElementsByTagName("cluster");
            for(int lh =0; lh < clustersList.getLength(); lh++){
                if(clusterName.equals(((Element)clustersList.item(lh)).getAttribute("name"))){
                    this.appendingResourceRefToCluster = true;
                    this.addOrUpdateResourceRef((Element)clustersList.item(lh), element, parentResult);
                    this.appendingResourceRefToCluster = false;
                    break;
                }
            }
        }
    }
    private void addOrUpdateResourceRef(Element parentForRef, Element element, Element parentResult){
        // Get resource refs.
        NodeList resourceRefs = parentForRef.getElementsByTagName("resource-ref");
        Element resourceRef = null;
        for(int lh =0; lh < resourceRefs.getLength(); lh++){
            // Compare one key attribute
            if((element.getAttribute("jndi-name")).equals(((Element)resourceRefs.item(lh)).getAttribute("ref"))){
                resourceRef = (Element)resourceRefs.item(lh);
                org.w3c.dom.Attr enAttr = element.getAttributeNode("enabled");
                if(enAttr != null){
                    resourceRef.setAttribute("enabled", element.getAttribute("enabled"));
                }
                break;
            }
        }
        if(resourceRef == null){
            resourceRef = parentResult.getOwnerDocument().createElement("resource-ref");
            resourceRef.setAttribute("ref", element.getAttribute("jndi-name"));
            org.w3c.dom.Attr enAttr = element.getAttributeNode("enabled");
            if(enAttr != null){
                resourceRef.setAttribute("enabled", element.getAttribute("enabled"));
            }
            this.appendElementToParent(parentForRef,resourceRef);
        }
    }
    private void skipGenericElementTransform(Element element, Element parentSource, Element parentResult){
        NodeList childNodes = element.getChildNodes();
        for(int index=0; index < childNodes.getLength(); index++){
            Node aNode = childNodes.item(index);
            try{
                if(aNode.getNodeType() == Node.ELEMENT_NODE){
                    BaseElement baseElement = ElementToObjectMapper.getMapper().getElementObject(aNode.getNodeName());
                    baseElement.transform((Element)aNode, element, parentResult);
                }
            }catch(Exception ex){
                ex.printStackTrace();
            }
        } 
    }    
    protected java.util.List getInsertElementStructure(Element element, Element parentEle){
        java.util.List insertStrucure = ElementToObjectMapper.getMapper().getInsertElementStructure(element.getTagName());
        if(element.getTagName().equals("resource-ref") && this.appendingResourceRefToCluster){
            if(this.insertStructureForResourceRefInCluster == null){
                this.insertStructureForResourceRefInCluster = new java.util.ArrayList();
                this.insertStructureForResourceRefInCluster.add("application-ref");
                this.insertStructureForResourceRefInCluster.add("system-property");
                this.insertStructureForResourceRefInCluster.add("property");
            }
            return this.insertStructureForResourceRefInCluster;            
        }
        return insertStrucure;
    }
}
