/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Element.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;

public class JMSService extends BaseElement {
    
    /** Creates a new instance of Element */
    public JMSService() {
    }
    /**
     * element - jms-service
     * parentSource - parent server of element
     * parentResult - domain
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        // There must be only one or zero jms-service.  
        // the destination has jms-host* as child elements which inherits most of the attributes from source jms-sesrvice
        NodeList resultJMSServices = parentResult.getElementsByTagName("jms-service");
        Element resultJMSService = null;
        if(resultJMSServices.getLength() == 0){
            NodeList config = parentResult.getElementsByTagName("config");
            resultJMSService = parentResult.getOwnerDocument().createElement("jms-service");
            this.transferAttributes(element, resultJMSService, null);
            this.appendElementToParent((Element)config.item(0),resultJMSService);  
        }else {
            resultJMSService = (Element)resultJMSServices.item(0);            
            this.transferAttributes(element, resultJMSService, null);
        } 
        super.transform(element,  parentSource, resultJMSService);      
    }
    // Over ride the method.
    protected void transferAttributes(Element source, Element result, java.util.List nonTransferList){
        if(commonInfoModel.getSourceVersion().equals(com.sun.enterprise.tools.upgrade.common.UpgradeConstants.VERSION_7X)){
            // Transfer init-timeout-in-seconds from source to result.
            int sourceSec = Integer.parseInt(source.getAttribute("init-timeout-in-seconds"));
            if(sourceSec < 60) sourceSec = 60;
            // init-timeout-in-seconds is 60 by default in domain.xml
            result.setAttribute("init-timeout-in-seconds", String.valueOf(sourceSec));
            // start-args is an implied attribute, should it be really transferred?
            result.setAttribute("start-args", source.getAttribute("start-args"));
            // Now other attributes from source should be transferred to jms-host element in the result. There can be zero or more jms-hosts
            NodeList resultJMSHosts = result.getElementsByTagName("jms-host");
            Element resultJMSHost = null;
            if(resultJMSHosts.getLength() == 0){
                resultJMSHost = result.getOwnerDocument().createElement("jms-host");
                resultJMSHost.setAttribute("name", "default_JMS_host");
                result.appendChild(resultJMSHost);
            }else { 
                for(int index=0; index < resultJMSHosts.getLength(); index++){
                    if(((Element)resultJMSHosts.item(index)).getAttribute("name").equals("default_JMS_host")){
                        resultJMSHost = (Element)resultJMSHosts.item(index);
                    }
                }            
            }
            resultJMSHost.setAttribute("port",source.getAttribute("port"));
            // Are you sure you want to transfer these?????
            resultJMSHost.setAttribute("admin-user-name",source.getAttribute("admin-user-name"));
            resultJMSHost.setAttribute("admin-password",source.getAttribute("admin-password"));
        }else{
            super.transferAttributes(source, result, nonTransferList);
        }
    }    
}
