/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * JVMOptions.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;
import com.sun.enterprise.tools.upgrade.common.UpgradeConstants;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;


public class JVMOptions extends BaseElement {
    
    /** Creates a new instance of Element */
    public JVMOptions() {
    }
    /**
     * element - jvm-options
     * parentSource - parent of jvm-options
     * parentResult - parent of jbm-options result
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        // There are no children for jvm-options, neither attributes.
        // jvm-options has only #CDATA.  Just need to transfer it, if not exists.
        NodeList jvmOptions = parentResult.getElementsByTagName("jvm-options");
        Element jvmOption = null;
        String srcTxtDt = this.getTextNodeData(element);
        String[] sourceTextData = this.parseTextData(srcTxtDt);
        if(sourceTextData == null){
            // jvm-options must be of type -X...
            // will not transfer anything...
	    //start CR 6398609
	    logger.log(java.util.logging.Level.WARNING, stringManager.getString("upgrade.transform.jvmoptions.notTransferred", srcTxtDt));
	    //end CR 6398609
            return;
        }
        //Added for CR 6363638
        if(srcTxtDt.trim().equals("-Djdbc.drivers=com.pointbase.jdbc.jdbcUniversalDriver")) {
            //JDBC Drivers should not be transformed as the universal driver is derby for 9.0
            return;
        }
        if(!this.canTransfer(sourceTextData[0], sourceTextData[1])){
	    //start CR 6398609
	    logger.log(java.util.logging.Level.WARNING, stringManager.getString("upgrade.transform.jvmoptions.notTransferred", sourceTextData[0]));
	    //end CR 6398609
            return;
        }
        for(int lh =0; lh < jvmOptions.getLength(); lh++){
            // Compare text data
            String tgTxtDt = this.getTextNodeData((Element)jvmOptions.item(lh));
            if(srcTxtDt.equals(tgTxtDt)){
                jvmOption = (Element)jvmOptions.item(lh);
                // If both are same there is nothing to be done, just break.
                break;
            }
            String[] targetTextData = this.parseTextData(tgTxtDt);
            if(sourceTextData != null && targetTextData != null){
                if(sourceTextData[0].equals(targetTextData[0])){
                    // If they both are same then Should I transfer any thing?  Dont think so
                    // If this option is already defined in AS 81 then probably a specific one for 81 would have been defined.
                    jvmOption = (Element)jvmOptions.item(lh);
                    break;
                }
            }
        }
        if(jvmOption == null){
            // If there isnt element -jvm-option in the result, add one. ....?
            //System.out.println("JVMOptions::transform ok... jvmOption in target could not be found =");
            if(this.canTransfer(sourceTextData[0], sourceTextData[1])){
                //System.out.println("JVMOptions::transform ok... Wow can transfer ....hurray.....");
                // If the value of jvm-option contains source install directory path, then dont want to transfer it.
                if(sourceTextData[1].indexOf(this.commonInfoModel.getSourceInstallDir()) == -1){
                    //System.out.println("JVMOptions::transform ok... source data does not contain fine go");
                    jvmOption = parentResult.getOwnerDocument().createElement("jvm-options");
                    Node textNode = jvmOption.getOwnerDocument().createTextNode(srcTxtDt);
                    jvmOption.appendChild(textNode);
                    parentResult.appendChild(jvmOption);
                }
            } //start CR 6398609
	    else { 
	        logger.log(java.util.logging.Level.WARNING, stringManager.getString("upgrade.transform.jvmoptions.notTransferred", sourceTextData[0]));
	    }
	    //end CR 6398609
	        
        }
    }
    private String[] parseTextData(String fullStr){
        String[] parsedStrings = null;
        java.util.StringTokenizer stk = new java.util.StringTokenizer(fullStr,"=");
        if((stk.hasMoreTokens()) && (stk.countTokens() == 2)){
            // There should be only two tokens typically.
            parsedStrings = new String[2];
            parsedStrings[0] = stk.nextToken();
            parsedStrings[1] = stk.nextToken();
        } 
        return parsedStrings;
    }
    private String getTextNodeData(Element element){
        NodeList children = element.getChildNodes();
        for(int index=0; index < children.getLength(); index++){
            if(children.item(index).getNodeType() == Node.TEXT_NODE){
                return children.item(index).getNodeValue();
            }
        }
        return "";
    }
    private boolean canTransfer(String optionName, String optionValue){
        // This method should have a list of items that is not good to transfer to 81... Need to determine the list.
        if((optionName.indexOf("Dorg.xml.sax.parser") != -1) ||
                (optionName.indexOf("Dorg.xml.sax.driver") != -1) ||
                (optionName.indexOf("Dcom.sun.jdo.api.persistence.model.multipleClassLoaders") != -1) ||
                (optionName.indexOf("Djava.util.logging.manager") != -1) ||
                (optionName.indexOf("Dcom.sun.aas.imqLib") != -1) ||
                (optionName.indexOf("Dcom.sun.aas.imqBin") != -1) ||
                (optionName.indexOf("Dcom.sun.aas.webServicesLib") != -1) ||
                (optionName.indexOf("Dcom.sun.aas.configRoot") != -1)){
            return false;
        }
        //System.out.println("JVMOptions::canTransfer installa dir before transformation ="+this.commonInfoModel.getSourceInstallDir());
        String repOpValue = this.commonInfoModel.getSourceInstallDir().replace('\\','/');
        //System.out.println("JVMOptions::canTransfer installa dir after transformation ="+repOpValue);
        //System.out.println("JVMOptions::canTransfer option value ="+optionValue);
        if((optionValue.indexOf(repOpValue) != -1) || (optionValue.indexOf(this.commonInfoModel.getSourceInstallDir()) != -1)){
            //System.out.println("JVMOptions::canTransfer yes index is not -1 so cannot transfer");
            return false;
        }
        // Don't transfer javax.net.ssl.keyStore or javax.net.ssl.trustStore from PE
        if(commonInfoModel.getTargetEdition().equals(UpgradeConstants.EDITION_EE) && optionName.indexOf("javax.net.ssl") != -1) {
            return false;
        }
        return true;
    }
    
}
