/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AuthDB.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;

public class ORB extends BaseElement {
    
    /** Creates a new instance of Element */
    public ORB() {
    }
    /**
     * element - orb
     * parentSource - parent iiop-service of element
     * parentResult - parent iiop-service of result
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        NodeList resultORBs = parentResult.getElementsByTagName("orb");
        // There should be one and only one orb.
        Element resultORB = (Element)resultORBs.item(0);
        // No need to add attrbitues which are missing.
        this.transferAttributes(element, resultORB, null);     
        // Transfer thread-pool related attributes to thread-pool element.
        // Identify right thread-pool 
        if(commonInfoModel.getSourceVersion().equals(com.sun.enterprise.tools.upgrade.common.UpgradeConstants.VERSION_7X)){
            String threadPoolAttr = resultORB.getAttribute("use-thread-pool-ids");
            NodeList tPs = parentResult.getOwnerDocument().getElementsByTagName("thread-pool");
            for(int lh =0; lh < tPs.getLength(); lh++){
                Element tpElement = ((Element)tPs.item(lh));
                if(threadPoolAttr.equals(tpElement.getAttribute("thread-pool-id"))){
                    tpElement.setAttribute("max-thread-pool-size", element.getAttribute("max-thread-pool-size"));
                    tpElement.setAttribute("idle-thread-timeout-in-seconds", element.getAttribute("idle-thread-timeout-in-seconds"));
                    break;
                }
            }
        }
        super.transform(element, parentSource, resultORB);
    }  
    
}
