/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * GenericContainer.java
 *
 * Created on August 4, 2003, 2:04 PM
 */

package com.sun.enterprise.tools.upgrade.transform.elements;

/**
 *
 * @author  prakash
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import com.sun.enterprise.tools.upgrade.cluster.ClustersInfoManager;

public class PersistenceStore extends BaseElement {
    
    /** Creates a new instance of Element */
    public PersistenceStore() {
    }
    /**
     * element - iiop-server-instance
     * parentSource - IIOPCluster
     * parentResult - result parent of any-element peer
     */
    public void transform(Element element, Element parentSource, Element parentResult){
        //String targetDomainName = parentResult.getOwnerDocument().getDocumentElement().getAttribute("name");
        // This element has a set of properties.  Just need to gather them and save them in ClusterInfoManager
        //ClusterInfoManager.getClusterInfoManager().getIIOPCluster(targetDomainName).addIIOPServerInstance(instanceName);
        NodeList resultElements = element.getElementsByTagName("property");
        for(int lh =0; lh < resultElements.getLength(); lh++){
            Element itElement = ((Element)resultElements.item(lh));
            ClustersInfoManager.getClusterInfoManager().addPersistenceStoreProperty(commonInfoModel.getCurrentDomain(),
                                     itElement.getAttribute("name"), itElement.getAttribute("value"));   
            // Compare one key attribute
            //ClusterInfoManager.getClusterInfoManager().getIIOPCluster(targetDomainName).addIIOPEndPoint(
            //itElement.getAttribute("id"),itElement.getAttribute("host"),itElement.getAttribute("port"));
        }
        
    }
}
