/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.connector.ias;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.common.dd.connector.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.tools.verifier.tests.connector.*;
import java.util.Hashtable;


public class ASConnectorPrincipal extends ConnectorTest implements ConnectorCheck {
 public Result check(ConnectorDescriptor descriptor)
 {
     Result result = getInitializedResult();
     ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);   
	 boolean oneFailed = false;
	 boolean oneWarning = false;
     SunConnector sc = descriptor.getSunDescriptor();
     if(sc == null)
     {
	      result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable1",
		    "NOTAPPLICABLE [ASCONNECTOR]: sun-ra.xml descriptor object could not be obtained"));
     }
     else{
     RoleMap rm = sc.getRoleMap();
	 if(rm == null){
	     result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable2","NOTAPPLICABLE [AS-CONNECTOR]: rolemap element not defined"));
		 return result;
	 }
     MapElement[] marr = rm.getMapElement();
	 int size = marr.length;
	 if(size == 0)
	 {
	     result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable3","NOTAPPLICABLE [AS-CONNECTOR rolemap]: map-elements not defined"));
		 return result;
	 }
	 Hashtable ht = new Hashtable();
	 for(int i=0; i < size ;i++)
	 {
	     String username = marr[i].getAttributeValue("backend-principal","user-name");
         Principal[] p = marr[i].getPrincipal();
		 for(int j=0; j< p.length ; j++)
		 {
		    String puser = p[j].getAttributeValue("user-name");
			String mappeduser = (String)ht.get(puser);
		    if(mappeduser == null)
		        ht.put(puser,username); 
			else
			{
			    if(!(mappeduser.equals(username)))
				{
				    oneWarning = true;
				    result.warning(smh.getLocalString(getClass().getName()+".warning","WARNING [AS-CONNECTOR rolemap map-element]: principal with username {0} is mapped to multiple backend principals {1} , {2}",new Object[] { puser,mappeduser,username}));
				}
			}
		 }

	 }
     if(oneWarning)
	     result.setStatus(Result.WARNING);
	 else
	 {
	     result.setStatus(Result.PASSED);
	     result.passed(smh.getLocalString(getClass().getName()+".passed","PASSED [AS-CONNECTOR rolemap map-element]: All principals are uniquely mapped to backend-principals"));
	 }
     }
     return result;	 
 }
 }
