/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.web.ias;


import com.sun.enterprise.tools.verifier.tests.web.elements.*;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

import com.sun.enterprise.tools.common.dd.EjbRef;
import com.sun.enterprise.tools.common.dd.webapp.*;

//<addition author="irfan@sun.com" [bug/rfe]-id="4711198" >
/* Changed the result messages to reflect consistency between the result messages generated 
 * for the EJB test cases for SunONE specific deployment descriptors*/
//</addition>

public class ASWebEjbRef extends WebTest implements WebCheck {



    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
	WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        EjbRef[] ejbRefs = descriptor.getIasWebApp().getEjbRef();

	boolean oneFailed = false;
        boolean oneWarning = false;//4699339
        String jndiName;
        String refName;

    	if (ejbRefs.length > 0) {
            boolean isValidResRefName;
	    for (int rep=0; rep<ejbRefs.length; rep++ ) {
                //System.out.println(">>>>>>>>>>>>>rep is " + rep);
                isValidResRefName=false;

		jndiName = ejbRefs[rep].getJndiName();
                refName = ejbRefs[rep].getEjbRefName();

                if (validEjbRefName(refName,descriptor)) {
                    isValidResRefName=true;
                    result.passed(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "PASSED [AS-WEB ejb-ref] ejb-ref-name [ {0} ] properly defined in the war file.",
					   new Object[] {refName}));
                } else {
                    if (!oneFailed)
                        oneFailed = true;
                    result.failed(smh.getLocalString
                                        (getClass().getName() + ".failed",
                                        "FAILED [AS-WEB ejb-ref] ejb-ref-name [ {0} ] is not valid, either empty or not defined in web.xml.",
                                        new Object[] {refName}));
                }

                if (isValidResRefName && validJndiName(jndiName, refName,descriptor)){
                    //                 foundIt  = true;
		    if(!jndiName.startsWith("ejb/")){ //4699339
                    
                    oneWarning=true;
                    result.warning(smh.getLocalString
                                        (getClass().getName() + ".warning",
                                        "WARNING [AS-WEB ejb-ref] jndi-name [ {0} ] is not starting with \"ejb/\".",
                                        new Object[] {jndiName}));    
                    }else{
                    
                    
                    result.passed(smh.getLocalString
					  (getClass().getName() + ".passed1",
					   "PASSED [AS-WEB ejb-ref] jndi-name [ {0} ] properly defined in the war file.",
					   new Object[] {jndiName}));
                    }
                
                } else {
                    if (!oneFailed)
                        oneFailed = true;
                    result.failed(smh.getLocalString
                                        (getClass().getName() + ".failed1",
                                        "FAILED [AS-WEB ejb-ref] jndi-name [ {0} ] is not valid, either empty or null.",
                                        new Object[] {jndiName}));
                }




	    }
	} else {
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "NOT APPLICABLE [AS-WEB sun-web-app] ejb-ref element(s) not defined in the web archive [ {0} ].",
				  new Object[] {descriptor.getName()}));
	    return result;
	}

	if (oneFailed)
	    {
		result.setStatus(Result.FAILED);
	    } 
        else if (oneWarning)//4699339
            {
                result.setStatus(Result.WARNING);   
            }
        else {
                result.passed
		    (smh.getLocalString
                    (getClass().getName() + ".passed2",
                    "PASSED [AS-WEB sun-web-app] ejb-ref element(s) defined are valid within the web archive [ {0} ].",
                    new Object[] {descriptor.getName()} ));
	    }
        
        
	return result;
    }


    boolean validEjbRefName(String name,WebBundleDescriptor descriptor){
        boolean valid =true;
        if(name !=null && name.length()!=0) {
            try{
              descriptor.getEjbReferenceByName(name);
            }
            catch(IllegalArgumentException e){
            valid=false;
            }
        }  else{
         valid=false;

        }
        return valid;
    }

    boolean validJndiName(String refJndiName, String refName,WebBundleDescriptor descriptor){
        boolean valid =true;

        if(refJndiName !=null && refJndiName.length()!=0 /*&& refJndiName.startsWith("ejb/")*/) {//4699339

         }
        else{
        valid=false;
        }

        return valid;
    }


}


