/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.web.ias;

import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.tests.web.*;

import com.sun.enterprise.tools.common.dd.ResourceEnvRef;
import com.sun.enterprise.tools.common.dd.webapp.*;



public class IASResourceEnvRef extends WebTest implements WebCheck {

    public Result check(WebBundleDescriptor descriptor) {

        String resName;
        String resType;
	Result result = getInitializedResult();
	WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        String jndiName;
        boolean oneFailed = false;
        boolean notApp = false;
        boolean chkOk=true;
        ResourceEnvRef[] envRefs= descriptor.getIasWebApp().getResourceEnvRef();

	if (envRefs.length > 0) {

             boolean isValidResRefName;
	     for (int rep=0; rep<envRefs.length; rep++ ) {
                isValidResRefName=false;
		resName = envRefs[rep].getResourceEnvRefName();
                jndiName = envRefs[rep].getJndiName();

                if (validResEnvRefName(resName,descriptor)) {

                    isValidResRefName=true;
		    result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                    result.addGoodDetails(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "Proper resource env reference name  [ {0} ] defined in the war file.",
					   new Object[] {resName}));
                } else {
                    if (!oneFailed)
                        oneFailed = true;
		    result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                    result.addErrorDetails(smh.getLocalString
                                        (getClass().getName() + ".failed",
                                        "Error: Resource env reference name [ {0} ] is not valid, either empty or not defined in web.xml.",
                                        new Object[] {resName}));
                }

                if (isValidResRefName && validJndiName(jndiName, resName,descriptor)){
                    result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                    result.addGoodDetails(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "Proper jndi name  [ {0} ] defined in the war file.",
					   new Object[] {jndiName}));
                } else {
                    if (!oneFailed)
                        oneFailed = true;
		    result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                    result.addErrorDetails(smh.getLocalString
                                        (getClass().getName() + ".failed",
                                        "Error: Jndi name [ {0} ] is not valid, either empty or not starts with \"jms/\".",
                                        new Object[] {resName}));
                }

            }

        } else {
            //System.out.println("There are no resource env references defined within the ias-web archive");
            notApp = true;
	    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
            result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There is no resource env reference element present in  this web archive [ {0} ].",
				  new Object[] {descriptor.getName()}));
        }
        if (oneFailed) {
            result.setStatus(Result.FAILED);
        } else if(notApp) {
            result.setStatus(Result.NOT_APPLICABLE);
        }else {
            result.setStatus(Result.PASSED);
            result.addGoodDetails(smh.getLocalString
                    ("tests.componentNameConstructor",
                    "For [ {0} ]",
                    new Object[] {compName.toString()}));
            result.passed
		    (smh.getLocalString
		     (getClass().getName() + ".passed",
		      "All resource env reference elements are valid within the web archive [ {0} ].",
                      new Object[] {descriptor.getName()} ));
        }
	return result;
    }

     boolean validResEnvRefName(String name,WebBundleDescriptor descriptor){
        boolean valid =true;
        if(name !=null && name.length()!=0) {
            try{
              descriptor.getJmsDestinationReferenceByName(name);
            }
            catch(IllegalArgumentException e){
            valid=false;
            }
        }  else{
         valid=false;

        }
        return valid;
    }

    boolean validJndiName(String refJndiName, String refName,WebBundleDescriptor descriptor){
        boolean valid =true;
        JmsDestinationReferenceDescriptor resDesc;

        if(refJndiName !=null && refJndiName.length()!=0) {
          //descriptor.getResourceReferenceByName(name);
          resDesc = descriptor.getJmsDestinationReferenceByName(refName);
                        String type = resDesc.getRefType();
                        if(type.indexOf("javax.jms")>-1) //jms resource
                        {
                            if(!refJndiName.startsWith("jms/"))
                              valid=false;

                        }

                        else
                            valid=false;
         }
        else{
        valid=false;
        }

        return valid;
    }



}
