<%--
 Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 Use is subject to license terms.
--%>

<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>
<fmt:setBundle basename="LocalStrings"/>

<html>
  <head>
    <title><fmt:message key="implicit-objects.jsp.title"/></title>
  </head>
  <body>
    <h1><fmt:message key="implicit-objects.jsp.title"/></h1>
    <hr>
    <fmt:message key="implicit-objects.jsp.overview"/>
    <ul>
      <li><fmt:message key="implicit-objects.jsp.pagecontext"/></li>
      <li><fmt:message key="implicit-objects.jsp.pagescope"/></li>
      <li><fmt:message key="implicit-objects.jsp.requestscope"/></li>
      <li><fmt:message key="implicit-objects.jsp.sessionscope"/></li>
      <li><fmt:message key="implicit-objects.jsp.applicationscope"/></li>
      <li><fmt:message key="implicit-objects.jsp.param"/></li>
      <li><fmt:message key="implicit-objects.jsp.paramvalues"/></li>
      <li><fmt:message key="implicit-objects.jsp.header"/></li>
      <li><fmt:message key="implicit-objects.jsp.headervalues"/></li>
      <li><fmt:message key="implicit-objects.jsp.initparam"/></li>
      <li><fmt:message key="implicit-objects.jsp.cookie"/></li>
    </ul>

    <blockquote>
      <u><b><fmt:message key="implicit-objects.jsp.changeparameter"/></b></u>
      <form action="implicit-objects.jsp" method="GET">
	  foo = <input type="text" name="foo" value="${param["foo"]}">
          <input type="submit">
      </form>
      <br>
      <code>
        <table border="1">
          <thead>
	    <td><b><fmt:message key="implicit-objects.jsp.elexpression"/></b></td>
	    <td><b><fmt:message key="implicit-objects.jsp.result"/></b></td>
	  </thead>
	  <tr>
	    <td>\${param.foo}</td>
	    <td>${param.foo}&nbsp;</td>
	  </tr>
	  <tr>
	    <td>\${param["foo"]}</td>
	    <td>${param["foo"]}&nbsp;</td>
	  </tr>
	  <tr>
	    <td>\${header["host"]}</td>
	    <td>${header["host"]}</td>
	  </tr>
	  <tr>
	    <td>\${header["accept"]}</td>
	    <td>${header["accept"]}</td>
	  </tr>
	  <tr>
	    <td>\${header["user-agent"]}</td>
	    <td>${header["user-agent"]}</td>
	  </tr>
	</table>
      </code>
    </blockquote>
  </body>
</html>
