/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Property
extends BaseElement {
    public void transform(Element element, Element parentSource, Element parentResult) {
        if (!this.canTransferAttributes(element, parentSource, parentResult)) {
            return;
        }
        NodeList resultProperties = parentResult.getElementsByTagName("property");
        Element resultProperty = null;
        if (resultProperties != null) {
            for (int index = 0; index < resultProperties.getLength(); ++index) {
                if (!element.getAttribute("name").equals(((Element)resultProperties.item(index)).getAttribute("name"))) continue;
                resultProperty = (Element)resultProperties.item(index);
                resultProperty.getAttributeNode("value").setValue(element.getAttributeNode("value").getValue());
                this.handleSpecialCases(element, resultProperty, parentSource, parentResult);
                break;
            }
        }
        if (resultProperty == null) {
            resultProperty = parentResult.getOwnerDocument().createElement("property");
            this.transferAttributes(element, resultProperty, null);
            this.handleSpecialCases(element, resultProperty, parentSource, parentResult);
            parentResult.appendChild(resultProperty);
        }
        super.transform(element, parentSource, resultProperty);
    }

    private boolean canTransferAttributes(Element element, Element parentSource, Element parentResult) {
        return true;
    }

    private void handleSpecialCases(Element source, Element target, Element parentSource, Element targetParent) {
        if (parentSource.getTagName().equals("jms-resource") && targetParent.getTagName().equals("admin-object-resource") && source.getAttribute("name").equals("imqDestinationName")) {
            target.setAttribute("name", "Name");
        }
        if (parentSource.getTagName().equals("virtual-server")) {
            if (source.getAttribute("name").equals("docroot")) {
                target.setAttribute("value", "${com.sun.aas.instanceRoot}/docroot");
            }
            if (source.getAttribute("name").equals("accesslog")) {
                target.setAttribute("value", "${com.sun.aas.instanceRoot}/logs/access");
            }
        }
    }
}

