/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Server
extends BaseElement {
    public void transform(Element element, Element parentSource, Element parentResult) {
        if (commonInfoModel.getSourceVersion().equals("7x")) {
            if (commonInfoModel.getSourceEdition().equals("pe")) {
                String locale = element.getAttribute("locale");
                Element resDocEle = parentResult;
                resDocEle.setAttribute("locale", locale);
                if (commonInfoModel.getTargetEdition().equals("pe")) {
                    super.transform(element, parentSource, parentResult);
                } else {
                    NodeList configEles = parentResult.getElementsByTagName("config");
                    Element configEle = null;
                    String configToUpgrade = element.getAttribute("name") + "-config";
                    for (int lh = 0; lh < configEles.getLength(); ++lh) {
                        String configName = ((Element)configEles.item(lh)).getAttribute("name");
                        if (!configName.equals(configToUpgrade)) continue;
                        parentResult = configEle = (Element)configEles.item(lh);
                        break;
                    }
                    if (configEle == null) {
                        // empty if block
                    }
                    super.transform(element, parentSource, configEle);
                }
            } else {
                String configToUpgrade = null;
                configToUpgrade = commonInfoModel.getCurrentCluster() == null ? element.getAttribute("name") + "-config" : commonInfoModel.getCurrentCluster() + "-config";
                NodeList configs = parentResult.getElementsByTagName("configs");
                Element configsEle = (Element)configs.item(0);
                NodeList configEles = configsEle.getElementsByTagName("config");
                Element configEle = null;
                for (int lh = 0; lh < configEles.getLength(); ++lh) {
                    String configName = ((Element)configEles.item(lh)).getAttribute("name");
                    if (!configName.equals(configToUpgrade)) continue;
                    parentResult = configEle = (Element)configEles.item(lh);
                    break;
                }
                if (configEle == null) {
                    Exception ex = new Exception("Could not find Config Element - " + configToUpgrade + " in target domain ");
                    this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.transform.startFailureMessage", (Object)ex.getMessage()), ex);
                    return;
                }
                super.transform(element, parentSource, configEle);
            }
        } else {
            NodeList servers = parentResult.getElementsByTagName("server");
            Element server = null;
            for (int lh = 0; lh < servers.getLength(); ++lh) {
                String resultElementID = ((Element)servers.item(lh)).getAttribute("name");
                if (!element.getAttribute("name").equals(resultElementID)) continue;
                server = (Element)servers.item(lh);
                this.transferAttributes(element, server, null);
                if (!commonInfoModel.getSourceVersion().equals("80") || !element.hasAttribute("node-controller-ref")) break;
                server.setAttribute("node-agent-ref", element.getAttribute("node-controller-ref"));
                break;
            }
            if (server == null) {
                server = parentResult.getOwnerDocument().createElement("server");
                this.transferAttributes(element, server, null);
                this.appendElementToParent(parentResult, server);
            }
            super.transform(element, parentSource, server);
            return;
        }
    }
}

