/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.j2ee;

import com.sun.appserv.management.j2ee.statistics.MapStatistic;
import com.sun.appserv.management.j2ee.statistics.NumberStatistic;
import com.sun.appserv.management.j2ee.statistics.StringStatistic;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.jmx.OpenMBeanUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.j2ee.statistics.BoundaryStatistic;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.EJBStats;
import javax.management.j2ee.statistics.EntityBeanStats;
import javax.management.j2ee.statistics.JCAConnectionPoolStats;
import javax.management.j2ee.statistics.JCAConnectionStats;
import javax.management.j2ee.statistics.JCAStats;
import javax.management.j2ee.statistics.JDBCConnectionPoolStats;
import javax.management.j2ee.statistics.JDBCStats;
import javax.management.j2ee.statistics.JMSConnectionStats;
import javax.management.j2ee.statistics.JMSConsumerStats;
import javax.management.j2ee.statistics.JMSEndpointStats;
import javax.management.j2ee.statistics.JMSProducerStats;
import javax.management.j2ee.statistics.JMSSessionStats;
import javax.management.j2ee.statistics.JMSStats;
import javax.management.j2ee.statistics.JVMStats;
import javax.management.j2ee.statistics.JavaMailStats;
import javax.management.j2ee.statistics.MessageDrivenBeanStats;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.ServletStats;
import javax.management.j2ee.statistics.SessionBeanStats;
import javax.management.j2ee.statistics.StatefulSessionBeanStats;
import javax.management.j2ee.statistics.StatelessSessionBeanStats;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.TimeStatistic;
import javax.management.j2ee.statistics.URLStats;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEUtil {
    private static final String GET = "get";
    private static final Set<String> IGNORE = GSetUtil.newUnmodifiableStringSet("getClass");
    private static final Class[] STATISTIC_CLASSES = new Class[]{BoundaryStatistic.class, BoundedRangeStatistic.class, TimeStatistic.class, RangeStatistic.class, CountStatistic.class, StringStatistic.class, NumberStatistic.class, MapStatistic.class};
    private static final Class[] STATS_CLASSES = new Class[]{EJBStats.class, MessageDrivenBeanStats.class, SessionBeanStats.class, StatefulSessionBeanStats.class, StatelessSessionBeanStats.class, EntityBeanStats.class, JavaMailStats.class, JCAConnectionStats.class, JCAConnectionPoolStats.class, JDBCConnectionPoolStats.class, JCAStats.class, JDBCConnectionPoolStats.class, JDBCStats.class, JMSConnectionStats.class, JMSConsumerStats.class, JMSEndpointStats.class, JMSProducerStats.class, JMSSessionStats.class, JMSStats.class, JVMStats.class, ServletStats.class, URLStats.class};

    private J2EEUtil() {
    }

    public static Map<String, Object> statisticToMap(Statistic statistic) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (statistic instanceof MapStatistic) {
            result.putAll(((MapStatistic)statistic).asMap());
        } else {
            Method[] methods = statistic.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                String methodName = method.getName();
                if (!methodName.startsWith(GET) || IGNORE.contains(methodName) || method.getParameterTypes().length != 0 || method.getExceptionTypes().length != 0 || method.getReturnType() == Void.class) continue;
                try {
                    Object value = method.invoke((Object)statistic, (Object[])null);
                    String name = methodName.substring(GET.length(), methodName.length());
                    result.put(name, value);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static String getStatisticType(Statistic statistic) {
        String type = J2EEUtil.getType(STATISTIC_CLASSES, statistic);
        if (type == null) {
            type = statistic.getClass().getName();
        }
        return type;
    }

    private static String getType(Class[] classes, Object o) {
        String type = null;
        for (int i = 0; i < classes.length; ++i) {
            Class theClass = classes[i];
            if (!theClass.isInstance(o)) continue;
            type = theClass.getName();
            break;
        }
        return type;
    }

    private static CompositeType statisticMapToCompositeType(String statisticType, Map<String, ?> map) throws OpenDataException {
        String description = "J2EE management statistic " + statisticType;
        return OpenMBeanUtil.mapToCompositeType(statisticType, description, map, null);
    }

    public static CompositeType statisticToCompositeType(Statistic statistic) throws OpenDataException {
        String statisticType = J2EEUtil.getStatisticType(statistic);
        Map<String, Object> map = J2EEUtil.statisticToMap(statistic);
        return J2EEUtil.statisticMapToCompositeType(statisticType, map);
    }

    public static CompositeDataSupport statisticToCompositeData(Statistic statistic) throws OpenDataException {
        String statisticType = J2EEUtil.getStatisticType(statistic);
        Map<String, Object> map = J2EEUtil.statisticToMap(statistic);
        CompositeType type = J2EEUtil.statisticMapToCompositeType(statisticType, map);
        return new CompositeDataSupport(type, map);
    }

    public static String getStatsType(Stats stats) {
        String type = J2EEUtil.getType(STATS_CLASSES, stats);
        if (type == null) {
            type = stats.getClass().getName();
        }
        return type;
    }

    public static CompositeDataSupport statsToCompositeData(Stats stats) throws OpenDataException {
        String statsType = J2EEUtil.getStatsType(stats);
        Statistic[] statistics = stats.getStatistics();
        String[] names = new String[statistics.length];
        Object[] datas = new CompositeData[names.length];
        String[] itemDescriptions = new String[names.length];
        CompositeType[] itemTypes = new CompositeType[names.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = statistics[i].getName();
            datas[i] = J2EEUtil.statisticToCompositeData(statistics[i]);
            itemTypes[i] = datas[i].getCompositeType();
            itemDescriptions[i] = statistics[i].getName();
        }
        CompositeType type = new CompositeType(statsType, "CompositeData for " + statsType, names, itemDescriptions, itemTypes);
        return new CompositeDataSupport(type, names, datas);
    }

    public static Map<String, Statistic> statsToMap(Stats stats) {
        Statistic[] statistics = stats.getStatistics();
        return J2EEUtil.statisticsToMap(statistics);
    }

    public static Map<String, Statistic> statisticsToMap(Statistic[] statistics) {
        HashMap<String, Statistic> m = new HashMap<String, Statistic>();
        for (int i = 0; i < statistics.length; ++i) {
            String name = statistics[i].getName();
            m.put(name, statistics[i]);
        }
        return m;
    }

    public static Method[] getStatisticGetterMethodsUsingNames(Stats stats) throws NoSuchMethodException {
        String[] statisticNames = stats.getStatisticNames();
        Class<?> statsClass = stats.getClass();
        Method[] methods = new Method[statisticNames.length];
        HashSet<String> missing = new HashSet<String>();
        for (int i = 0; i < statisticNames.length; ++i) {
            String methodName = GET + statisticNames[i];
            try {
                methods[i] = statsClass.getMethod(methodName, null);
                continue;
            }
            catch (NoSuchMethodException e) {
                missing.add(methodName);
            }
        }
        if (missing.size() != 0) {
            throw new NoSuchMethodException("Missing methods: in object of class " + stats.getClass().getName() + ": " + CollectionUtil.toString(missing, ", "));
        }
        return methods;
    }

    public static Method[] getStatisticGetterMethodsUsingIntrospection(Stats stats) {
        Method[] candidates = stats.getClass().getMethods();
        ArrayList<Method> results = new ArrayList<Method>();
        for (int methodIdx = 0; methodIdx < candidates.length; ++methodIdx) {
            Method method = candidates[methodIdx];
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            if (!JMXUtil.isGetter(method) || !Statistic.class.isAssignableFrom(returnType) || method.getParameterTypes().length != 0) continue;
            results.add(method);
        }
        return results.toArray(new Method[results.size()]);
    }
}

