/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.AbstractTableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.MethodStartTO;
import com.sun.enterprise.admin.monitor.callflow.TableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.TransferObject;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MethodStartAccessObjectImpl
extends AbstractTableAccessObject {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static MethodStartAccessObjectImpl _singletonMS;

    private MethodStartAccessObjectImpl() {
        String serverName = super.getServerInstanceName();
        this.tableName = "METHOD_START_TBL" + serverName.toUpperCase();
    }

    public boolean createTable(Connection connection) {
        this.con = connection;
        return super.createTable(" create table METHOD_START_TBL ( REQUEST_ID VARCHAR(255)  NOT NULL  , TIME_STAMP BIGINT  NOT NULL  , COMPONENT_TYPE VARCHAR(30)  , COMPONENT_NAME VARCHAR(255)  , APP_NAME VARCHAR(255)  , METHOD_NAME VARCHAR(255)  , MODULE_NAME VARCHAR(255)  , THREAD_ID VARCHAR(255)  , TRANSACTION_ID VARCHAR(255)  , SECURITY_ID VARCHAR(255)  ,  primary key  ( REQUEST_ID , TIME_STAMP))", "METHOD_START_TBL");
    }

    public boolean dropTable(Connection connection) {
        this.con = connection;
        return super.createStatmentAndExecuteUpdate("drop table METHOD_START_TBL", "METHOD_START_TBL");
    }

    public static TableAccessObject getInstance() {
        if (_singletonMS == null) {
            _singletonMS = new MethodStartAccessObjectImpl();
        }
        return _singletonMS;
    }

    public boolean insert(PreparedStatement pstmt, TransferObject[] transferObject) {
        if (pstmt == null) {
            return false;
        }
        boolean result = false;
        try {
            for (int i = 0; i < transferObject.length; ++i) {
                MethodStartTO methodStartTO = (MethodStartTO)transferObject[i];
                pstmt.setString(1, methodStartTO.getRequestId());
                pstmt.setLong(2, methodStartTO.getTimeStamp());
                if (methodStartTO.getComponentType() != null) {
                    pstmt.setString(3, methodStartTO.getComponentType().toString());
                } else {
                    pstmt.setString(3, null);
                }
                pstmt.setString(4, methodStartTO.getComponentName());
                pstmt.setString(5, methodStartTO.getAppName());
                pstmt.setString(6, methodStartTO.getMethodName());
                pstmt.setString(7, methodStartTO.getModuleName());
                pstmt.setString(8, methodStartTO.getThreadId());
                pstmt.setString(9, methodStartTO.getTransactionId());
                pstmt.setString(10, methodStartTO.getSecurityId());
                pstmt.addBatch();
            }
            int[] updated = pstmt.executeBatch();
            result = updated.length == transferObject.length;
        }
        catch (BatchUpdateException bue) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", bue);
            result = false;
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", se);
            result = false;
        }
        return result;
    }

    public String getInsertSQL() {
        String newsql = super.updateSqlWithTableName(" INSERT INTO METHOD_START_TBL VALUES  (  ?, ?, ?,  ?, ?, ?,  ?, ?, ? ,? ) ", "METHOD_START_TBL");
        return newsql;
    }

    public String getDeleteSQL() {
        String newsql = super.updateSqlWithTableName(" DELETE  FROM METHOD_START_TBL WHERE REQUEST_ID =  ? ", "METHOD_START_TBL");
        return newsql;
    }
}

