/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.registry.spi.reconfig;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.spi.ValueListMap;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.ChangeHandler;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.ConnectionPoolChangeHandler;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.EjbContainerChangeHandler;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.EmptyChangeHandler;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.HttpServiceChangeHandler;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.JVMChangeHandler;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.OrbChangeHandler;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.ThreadPoolChangeHandler;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.TransactionServiceChangeHandler;
import com.sun.enterprise.admin.monitor.registry.spi.reconfig.WebContainerChangeHandler;

public final class DynamicReconfigurator
implements ChangeHandler {
    private final ValueListMap listeners;
    private ChangeHandler successor;

    public DynamicReconfigurator(ValueListMap listeners) {
        this.listeners = listeners;
        this.chain();
    }

    public void addListener(MonitoredObjectType type, MonitoringLevelListener listener) {
        if (this.listeners != null) {
            this.listeners.put(type, listener);
        }
    }

    public void removeListener(MonitoringLevelListener listener) {
        this.listeners.remove(listener);
    }

    public void handleChange(MonitoredObjectType type, MonitoringLevel from, MonitoringLevel to) {
        this.successor.handleChange(type, from, to);
    }

    private void chain() {
        EmptyChangeHandler c = new EmptyChangeHandler();
        JVMChangeHandler j = new JVMChangeHandler(c, this.listeners);
        WebContainerChangeHandler w = new WebContainerChangeHandler(j, this.listeners);
        EjbContainerChangeHandler e = new EjbContainerChangeHandler(w, this.listeners);
        TransactionServiceChangeHandler ts = new TransactionServiceChangeHandler(e, this.listeners);
        HttpServiceChangeHandler hs = new HttpServiceChangeHandler(ts, this.listeners);
        OrbChangeHandler orb = new OrbChangeHandler(hs, this.listeners);
        ThreadPoolChangeHandler tp = new ThreadPoolChangeHandler(orb, this.listeners);
        ConnectionPoolChangeHandler cp = new ConnectionPoolChangeHandler(tp, this.listeners);
        this.successor = cp;
    }
}

