/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;

public class GenericStatsImpl
implements Stats {
    private final Class statsInterface;
    private final Object statsProvider;
    private final Map getters;

    public GenericStatsImpl(String statsInterfaceName, Object statsProvider) throws ClassNotFoundException {
        this(statsInterfaceName, GenericStatsImpl.class.getClassLoader(), statsProvider);
    }

    public GenericStatsImpl(String statsInterfaceName, ClassLoader loader, Object statsProvider) throws ClassNotFoundException {
        this(Class.forName(statsInterfaceName, true, loader), statsProvider);
    }

    public GenericStatsImpl(Class statsInterface, Object statsProvider) {
        if (!this.implementsInterface(statsInterface, statsProvider) || !this.extendsStatsInterface(statsInterface)) {
            throw new IllegalArgumentException("Contract violation: invalid interface-implementation pair");
        }
        this.statsProvider = statsProvider;
        this.statsInterface = statsInterface;
        this.getters = new HashMap();
        this.populateGetterMap();
    }

    public Statistic getStatistic(String statisticName) {
        Method getter = (Method)this.getters.get(statisticName);
        assert (getter != null) : "Getter not initialized properly: " + statisticName;
        Object result = null;
        try {
            result = getter.invoke(this.statsProvider, new Object[0]);
        }
        catch (Exception e) {
            IllegalStateException oe = new IllegalStateException();
            oe.initCause(e);
            throw oe;
        }
        return (Statistic)result;
    }

    public String[] getStatisticNames() {
        String[] names = new String[this.getters.size()];
        return this.getters.keySet().toArray(names);
    }

    public Statistic[] getStatistics() {
        return this.getStatisticsOneByOne();
    }

    private Statistic[] getStatisticsOneByOne() {
        Iterator iter = this.getters.keySet().iterator();
        Statistic[] stats = new Statistic[this.getters.keySet().size()];
        int i = 0;
        while (iter.hasNext()) {
            String sn = (String)iter.next();
            stats[i++] = this.getStatistic(sn);
        }
        assert (stats.length == i);
        return stats;
    }

    private boolean implementsInterface(Class c, Object o) {
        boolean impls = false;
        Class<?>[] interfaces = o.getClass().getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals(c)) continue;
            impls = true;
            break;
        }
        return impls;
    }

    private boolean extendsStatsInterface(Class i) {
        Class<Stats> statsInterface = Stats.class;
        return statsInterface.isAssignableFrom(i);
    }

    private void populateGetterMap() {
        int i;
        Method[] m = this.statsInterface.getMethods();
        Method[] apis = this.filterStatsMethods(m);
        Method[] methods = this.getGetters(apis);
        String[] names = this.methods2Statistics(methods);
        assert (names.length == methods.length) : "Statistic names array is not having same length as that of array of getters";
        for (i = 0; i < names.length; ++i) {
            this.getters.put(names[i], methods[i]);
        }
        assert (this.getters.size() == i) : "Getters map is incorrect, names.length = " + names.length + " methods.length = " + methods.length;
    }

    private Method[] getGetters(Method[] all) {
        ArrayList<Method> l = new ArrayList<Method>();
        for (int i = 0; i < all.length; ++i) {
            Method am = all[i];
            if (!this.isValidGetter(am)) continue;
            l.add(am);
        }
        Method[] m = new Method[l.size()];
        return l.toArray(m);
    }

    private boolean isValidGetter(Method m) {
        boolean startsWithGet = m.getName().startsWith("get");
        boolean hasNoParams = m.getParameterTypes().length == 0;
        boolean returnsStatistic = Statistic.class.isAssignableFrom(m.getReturnType());
        return startsWithGet && hasNoParams && returnsStatistic;
    }

    private String[] methods2Statistics(Method[] methods) {
        String[] names = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            String m = methods[i].getName();
            int s = "get".length();
            names[i] = m.substring(s);
        }
        return names;
    }

    private boolean isStatsInterfaceMethod(String name) {
        Method[] methods = Stats.class.getMethods();
        boolean isInterfaceMethod = false;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            isInterfaceMethod = true;
            break;
        }
        return isInterfaceMethod;
    }

    private Method[] filterStatsMethods(Method[] m) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (int i = 0; i < m.length; ++i) {
            if (this.isStatsInterfaceMethod(m[i].getName())) continue;
            methodList.add(m[i]);
        }
        Method[] methods = new Method[methodList.size()];
        return methodList.toArray(methods);
    }
}

