/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats.lb;

import com.sun.enterprise.admin.monitor.stats.lb.ClusterStatsInterface;
import com.sun.enterprise.admin.monitor.stats.lb.CommonBean;
import com.sun.enterprise.admin.monitor.stats.lb.InstanceStats;
import com.sun.enterprise.admin.monitor.stats.lb.LoadBalancerStats;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClusterStats
implements ClusterStatsInterface,
CommonBean {
    private String _Id;
    private List _InstanceStats = new ArrayList();

    public ClusterStats() {
        this._Id = "";
    }

    public ClusterStats(ClusterStats source) {
        this._Id = source._Id;
        Iterator it = source._InstanceStats.iterator();
        while (it.hasNext()) {
            this._InstanceStats.add(new InstanceStats((InstanceStats)it.next()));
        }
    }

    public void setId(String value) {
        this._Id = value;
    }

    public String getId() {
        return this._Id;
    }

    public void setInstanceStats(InstanceStats[] value) {
        if (value == null) {
            value = new InstanceStats[]{};
        }
        this._InstanceStats.clear();
        for (int i = 0; i < value.length; ++i) {
            this._InstanceStats.add(value[i]);
        }
    }

    public void setInstanceStats(int index, InstanceStats value) {
        this._InstanceStats.set(index, value);
    }

    public InstanceStats[] getInstanceStats() {
        InstanceStats[] arr = new InstanceStats[this._InstanceStats.size()];
        return this._InstanceStats.toArray(arr);
    }

    public List fetchInstanceStatsList() {
        return this._InstanceStats;
    }

    public InstanceStats getInstanceStats(int index) {
        return (InstanceStats)this._InstanceStats.get(index);
    }

    public int sizeInstanceStats() {
        return this._InstanceStats.size();
    }

    public int addInstanceStats(InstanceStats value) {
        this._InstanceStats.add(value);
        return this._InstanceStats.size() - 1;
    }

    public int removeInstanceStats(InstanceStats value) {
        int pos = this._InstanceStats.indexOf(value);
        if (pos >= 0) {
            this._InstanceStats.remove(pos);
        }
        return pos;
    }

    public void writeNode(Writer out, String nodeName, String indent) throws IOException {
        out.write(indent);
        out.write("<");
        out.write(nodeName);
        if (this._Id != null) {
            out.write(" id");
            out.write("='");
            LoadBalancerStats.writeXML(out, this._Id, true);
            out.write("'");
        }
        out.write(">\n");
        String nextIndent = indent + "\t";
        for (InstanceStats element : this._InstanceStats) {
            if (element == null) continue;
            element.writeNode(out, "instance-stats", nextIndent);
        }
        out.write(indent);
        out.write("</" + nodeName + ">\n");
    }

    public void readNode(Node node) {
        NamedNodeMap attrs;
        Attr attr;
        if (node.hasAttributes() && (attr = (Attr)(attrs = node.getAttributes()).getNamedItem("id")) != null) {
            this._Id = attr.getValue();
        }
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node childNode = children.item(i);
            String childNodeName = childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern();
            String childNodeValue = "";
            if (childNode.getFirstChild() != null) {
                childNodeValue = childNode.getFirstChild().getNodeValue();
            }
            if (childNodeName != "instance-stats") continue;
            InstanceStats aInstanceStats = new InstanceStats();
            aInstanceStats.readNode(childNode);
            this._InstanceStats.add(aInstanceStats);
        }
    }

    public void validate() throws LoadBalancerStats.ValidateException {
        boolean restrictionFailure = false;
        if (this.getId() == null) {
            throw new LoadBalancerStats.ValidateException("getId() == null", "id", this);
        }
        for (int _index = 0; _index < this.sizeInstanceStats(); ++_index) {
            InstanceStats element = this.getInstanceStats(_index);
            if (element == null) continue;
            element.validate();
        }
    }

    public void changePropertyByName(String name, Object value) {
        if (name == null) {
            return;
        }
        if ((name = name.intern()) == "id") {
            this.setId((String)value);
        } else if (name == "instanceStats") {
            this.addInstanceStats((InstanceStats)value);
        } else if (name == "instanceStats[]") {
            this.setInstanceStats((InstanceStats[])value);
        } else {
            throw new IllegalArgumentException(name + " is not a valid property name for ClusterStats");
        }
    }

    public Object fetchPropertyByName(String name) {
        if (name == "id") {
            return this.getId();
        }
        if (name == "instanceStats[]") {
            return this.getInstanceStats();
        }
        throw new IllegalArgumentException(name + " is not a valid property name for ClusterStats");
    }

    public CommonBean[] childBeans(boolean recursive) {
        LinkedList children = new LinkedList();
        this.childBeans(recursive, children);
        CommonBean[] result = new CommonBean[children.size()];
        return children.toArray(result);
    }

    public void childBeans(boolean recursive, List beans) {
        for (InstanceStats element : this._InstanceStats) {
            if (element == null) continue;
            if (recursive) {
                element.childBeans(true, beans);
            }
            beans.add(element);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterStats)) {
            return false;
        }
        ClusterStats inst = (ClusterStats)o;
        if (!(this._Id != null ? this._Id.equals(inst._Id) : inst._Id == null)) {
            return false;
        }
        if (this.sizeInstanceStats() != inst.sizeInstanceStats()) {
            return false;
        }
        Iterator it = this._InstanceStats.iterator();
        Iterator it2 = inst._InstanceStats.iterator();
        while (it.hasNext() && it2.hasNext()) {
            InstanceStats element = (InstanceStats)it.next();
            InstanceStats element2 = (InstanceStats)it2.next();
            if (element != null ? element.equals(element2) : element2 == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._Id == null ? 0 : this._Id.hashCode());
        result = 37 * result + (this._InstanceStats == null ? 0 : ((Object)this._InstanceStats).hashCode());
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeNode(sw, "ClusterStats", "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

