/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.management.support.AMXNonConfigImplBase;
import com.sun.enterprise.management.support.BootUtil;
import com.sun.enterprise.management.support.NotificationEmitterServiceImpl;
import com.sun.enterprise.management.support.ObjectNames;
import com.sun.enterprise.management.support.TypeInfo;
import java.util.Set;
import javax.management.JMException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainRootImplBase
extends AMXNonConfigImplBase {
    private String mAppserverDomainName = null;
    private static final Set<String> NOT_SUPERFLUOUS = GSetUtil.newUnmodifiableStringSet("getDomainNotificationEmitterServiceObjectName");
    private static final long AMX_READY_SLEEP_DURATION = 100L;
    private static final Set<String> OFFLINE_INCAPABLE_J2EE_TYPES = GSetUtil.newUnmodifiableStringSet("X-WebServiceMgr");

    @Override
    public String getGroup() {
        return "utility";
    }

    @Override
    public ObjectName preRegisterHook(ObjectName selfObjectName) throws Exception {
        this.mAppserverDomainName = BootUtil.getInstance().getAppserverDomainName();
        return selfObjectName;
    }

    @Override
    public void preRegisterDone() throws Exception {
        super.preRegisterDone();
        CheckStartedThread t = new CheckStartedThread();
        t.start();
    }

    @Override
    protected final Set<String> getNotSuperfluousMethods() {
        return GSetUtil.newSet(super.getNotSuperfluousMethods(), NOT_SUPERFLUOUS);
    }

    public ObjectName getDomainNotificationEmitterServiceObjectName() {
        return this.getContaineeObjectName("X-NotificationEmitterService", "DomainNotificationEmitterService");
    }

    public String getAppserverDomainName() {
        return this.mAppserverDomainName;
    }

    @Override
    protected final void registerMisc() {
        super.registerMisc();
        this.registerNotificationEmitterService();
    }

    protected final void registerNotificationEmitterService() {
        ObjectNames objectNames = ObjectNames.getInstance(this.getJMXDomain());
        ObjectName childObjectName = objectNames.buildContaineeObjectName(this.getObjectName(), this.getFullType(), "X-NotificationEmitterService", "DomainNotificationEmitterService");
        NotificationEmitterServiceImpl domainNES = new NotificationEmitterServiceImpl();
        try {
            this.getMBeanServer().registerMBean(domainNES, childObjectName);
        }
        catch (JMException e) {
            this.logWarning("DomainRootImpl: Can't load global NotificationEmitterService");
        }
    }

    private void amxNowReady() {
        if (!this.getAMXReady()) {
            throw new IllegalStateException();
        }
        this.sendNotification("com.sun.appserv.management.DomainRoot.AMXReady");
    }

    public boolean getAMXReady() {
        return BootUtil.getInstance().getAMXReady();
    }

    public void waitAMXReady() {
        while (!this.getAMXReady()) {
            this.sleepMillis(100L);
        }
    }

    @Override
    protected boolean isOfflineCapable(TypeInfo childInfo) {
        String j2eeType = childInfo.getJ2EEType();
        return !OFFLINE_INCAPABLE_J2EE_TYPES.contains(j2eeType) && super.isOfflineCapable(childInfo);
    }

    @Override
    protected void registerSelfMgrChild(TypeInfo childInfo) throws JMException, InstantiationException, IllegalAccessException {
        super.registerSelfMgrChild(childInfo);
    }

    private final class CheckStartedThread
    extends Thread {
        private CheckStartedThread() {
        }

        public void CheckStartedThread() {
        }

        public void run() {
            DomainRootImplBase.this.waitAMXReady();
            DomainRootImplBase.this.amxNowReady();
        }
    }
}

