/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldConfigsMBean;
import com.sun.enterprise.management.support.oldconfig.OldSecurityServiceMBean;
import java.util.Map;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthRealmConfigFactory
extends ConfigFactory {
    static final String CLASSNAME_KEY = "Classname";

    public AuthRealmConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
        assert ("jaas-context".equals(StringUtil.stripPrefix("property.jaas-context", "property.")));
        assert ("file".equals(StringUtil.stripPrefix("property.file", "property.")));
    }

    private final OldSecurityServiceMBean getOldSecurityServiceMBean() {
        OldSecurityServiceMBean oldSecurityService = this.getOldConfigProxies().getOldSecurityServiceMBean(this.getConfigName());
        return oldSecurityService;
    }

    private final OldConfigsMBean getOldConfigsMBean() {
        OldConfigsMBean oldConfigs = this.getOldConfigProxies().getOldConfigsMBean();
        return oldConfigs;
    }

    private void checkDefaultProps(Map<String, String> optional) {
        String jaasContext;
        String keyFile;
        String string = keyFile = optional == null ? null : optional.get("property.file");
        if (keyFile == null) {
            throw new IllegalArgumentException("Must specify a key file using KEY_FILE_PROPERTY_KEY in options Map");
        }
        String string2 = jaasContext = optional == null ? null : optional.get("property.jaas-context");
        if (jaasContext == null) {
            throw new IllegalArgumentException("Must specify a JAAS context file using JAAS_CONTEXT_PROPERTY_KEY in options Map");
        }
    }

    public ObjectName create(String name, String className, Map<String, String> optional) {
        if (className.equals("com.sun.enterprise.security.auth.realm.file.FileRealm")) {
            this.checkDefaultProps(optional);
        }
        String[] requiredParams = new String[]{CLASSNAME_KEY, className};
        Map<String, String> params = this.initParams(name, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(name, params);
        return amxName;
    }

    @Override
    protected final void removeByName(String authLayer) {
        this.getOldSecurityServiceMBean().removeAuthRealmByName(authLayer);
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs, Properties props) {
        String target = this.getConfigName();
        ObjectName objectName = this.getOldConfigsMBean().createAuthRealm(translatedAttrs, props, target);
        return objectName;
    }
}

