/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ClusterRefConfig;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.config.LoadBalancerConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.ServerRefConfig;
import com.sun.appserv.management.monitor.LoadBalancerApplicationMonitor;
import com.sun.appserv.management.monitor.LoadBalancerClusterMonitor;
import com.sun.appserv.management.monitor.LoadBalancerContextRootMonitor;
import com.sun.appserv.management.monitor.LoadBalancerMonitor;
import com.sun.appserv.management.monitor.LoadBalancerServerMonitor;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.LBDeregistrationUtil;
import com.sun.enterprise.management.support.ObjectNames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class DeployedItemRefConfigImpl
extends AMXConfigImplBase {
    DeployedItemRefDeRegistrationHelper mHelper = null;

    public DeployedItemRefConfigImpl(Delegate delegate) {
        super(delegate);
    }

    protected void unregisterMisc() {
        try {
            this.mHelper = new DeployedItemRefDeRegistrationHelper(this.getName(), this.getMBeanServer());
        }
        catch (Exception ex) {
            this.logWarning("DeployedItemRefConfig unregisterMisc failed. DeployedItemRefDeregistrationHelper creation failed");
        }
    }

    public void postDeregister() {
        super.postDeregister();
        try {
            HashMap<String, LoadBalancerConfig> relevantLoadBalancerConfigMap = new HashMap();
            if (this.getContainer() instanceof ServerConfig) {
                relevantLoadBalancerConfigMap = this.mHelper.fetchLoadBalancerConfigs((ServerConfig)this.getContainer());
                this.mHelper.unregisterMonitors(relevantLoadBalancerConfigMap);
            } else if (this.getContainer() instanceof ClusterConfig) {
                relevantLoadBalancerConfigMap = this.mHelper.fetchLoadBalancerConfigs((ClusterConfig)this.getContainer());
                this.mHelper.unregisterMonitors(relevantLoadBalancerConfigMap);
            }
            this.mHelper = null;
        }
        catch (Exception ex) {
            this.logWarning("DeployedItemRef postDeregistration failed. Load Balancer Monitoring MBeans might be lying around if this application is being load balanced ");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeployedItemRefDeRegistrationHelper {
        static final String J2EE_TYPE = "j2eeType";
        final ObjectNames objectNames = ObjectNames.getInstance("amx");
        String appName = null;
        MBeanServer mbs = null;

        public DeployedItemRefDeRegistrationHelper(String appName, MBeanServer mbs) {
            this.mbs = mbs;
            this.appName = appName;
        }

        void unregisterMonitors(Map<String, LoadBalancerConfig> relevantLoadBalancerConfigMap) throws JMException {
            for (String loadBalancerName : relevantLoadBalancerConfigMap.keySet()) {
                LoadBalancerConfig loadBalancerConfig = relevantLoadBalancerConfigMap.get(loadBalancerName);
                LoadBalancerMonitor loadBalancerMonitor = LBDeregistrationUtil.getInstance(this.mbs).fetchLBMonitoringRoot(loadBalancerName);
                Collection<LoadBalancerApplicationMonitor> lbamList = this.fetchLoadBalancerApplicationMonitors(this.appName, loadBalancerMonitor);
                for (LoadBalancerApplicationMonitor lbam : lbamList) {
                    Map<String, LoadBalancerContextRootMonitor> lbcrmm = lbam.getLoadBalancerContextRootMonitorMap();
                    for (String ctxRootName : lbcrmm.keySet()) {
                        LoadBalancerContextRootMonitor loadBalancerContextRootMonitor = lbcrmm.get(ctxRootName);
                        ObjectName loadBalancerContextRootMonitorObjName = Util.getObjectName(loadBalancerContextRootMonitor);
                        this.mbs.unregisterMBean(loadBalancerContextRootMonitorObjName);
                    }
                    ObjectName lbamObjName = Util.getObjectName(lbam);
                    this.mbs.unregisterMBean(lbamObjName);
                }
            }
        }

        Map<String, LoadBalancerConfig> fetchLoadBalancerConfigs(ClusterConfig clusterConfig) {
            String clusterName = clusterConfig.getName();
            Map<String, LBConfig> allLBConfigMap = DeployedItemRefConfigImpl.this.getDomainRoot().getDomainConfig().getLBConfigMap();
            HashMap<String, LBConfig> relevantLBConfigMap = new HashMap<String, LBConfig>();
            block0: for (String lbConfigName : allLBConfigMap.keySet()) {
                LBConfig lbConfig = allLBConfigMap.get(lbConfigName);
                Map<String, ClusterRefConfig> clusterRefConfigMap = lbConfig.getClusterRefConfigMap();
                for (String clusterRef : clusterRefConfigMap.keySet()) {
                    if (!clusterRef.equals(clusterName)) continue;
                    relevantLBConfigMap.put(lbConfigName, lbConfig);
                    continue block0;
                }
            }
            return this.fetchLoadBalancerConfigs(relevantLBConfigMap);
        }

        Map<String, LoadBalancerConfig> fetchLoadBalancerConfigs(ServerConfig serverConfig) {
            HashMap<String, LBConfig> relevantLBConfigMap = new HashMap<String, LBConfig>();
            String serverName = serverConfig.getName();
            Map<String, LBConfig> allLBConfigMap = DeployedItemRefConfigImpl.this.getDomainRoot().getDomainConfig().getLBConfigMap();
            Map<String, ClusterConfig> allClusterConfigMap = DeployedItemRefConfigImpl.this.getDomainRoot().getDomainConfig().getClusterConfigMap();
            block0: for (String lbConfigName : allLBConfigMap.keySet()) {
                LBConfig lbConfig = allLBConfigMap.get(lbConfigName);
                HashMap<String, ClusterConfig> relevantClusterConfigMap = new HashMap<String, ClusterConfig>();
                Map<String, ClusterRefConfig> clusterRefConfigMap = lbConfig.getClusterRefConfigMap();
                for (String clusterName : clusterRefConfigMap.keySet()) {
                    relevantClusterConfigMap.put(clusterName, allClusterConfigMap.get(clusterName));
                }
                block2: for (ClusterConfig clusterConfig : relevantClusterConfigMap.values()) {
                    Map<String, ServerRefConfig> serverRefConfigMap = clusterConfig.getServerRefConfigMap();
                    for (String serverRef : serverRefConfigMap.keySet()) {
                        if (!serverRef.equals(serverName)) continue;
                        relevantLBConfigMap.put(lbConfigName, lbConfig);
                        continue block2;
                    }
                }
                Map<String, ServerRefConfig> serverRefConfigMap = lbConfig.getServerRefConfigMap();
                for (String serverRef : serverRefConfigMap.keySet()) {
                    if (!serverRef.equals(serverName)) continue;
                    relevantLBConfigMap.put(lbConfigName, lbConfig);
                    continue block0;
                }
            }
            return this.fetchLoadBalancerConfigs(relevantLBConfigMap);
        }

        private Collection<LoadBalancerApplicationMonitor> fetchLoadBalancerApplicationMonitors(String ipAppName, LoadBalancerMonitor loadBalancerMonitor) {
            ArrayList<LoadBalancerApplicationMonitor> result = new ArrayList<LoadBalancerApplicationMonitor>();
            Map<String, LoadBalancerClusterMonitor> lbcmMap = loadBalancerMonitor.getLoadBalancerClusterMonitorMap();
            for (String clusterName : lbcmMap.keySet()) {
                LoadBalancerClusterMonitor lbcm = lbcmMap.get(clusterName);
                Map<String, LoadBalancerServerMonitor> lbsmMap = lbcm.getLoadBalancerServerMonitorMap();
                for (String serverName : lbsmMap.keySet()) {
                    LoadBalancerServerMonitor lbsm = lbsmMap.get(serverName);
                    Map<String, LoadBalancerApplicationMonitor> lbamMap = lbsm.getLoadBalancerApplicationMonitorMap();
                    if (lbamMap.get(ipAppName) == null) continue;
                    result.add(lbamMap.get(ipAppName));
                }
            }
            return result;
        }

        private Map<String, LoadBalancerConfig> fetchLoadBalancerConfigs(LBConfig lbConfig) {
            HashMap<String, LBConfig> lbConfigMap = new HashMap<String, LBConfig>();
            lbConfigMap.put(lbConfig.getName(), lbConfig);
            return this.fetchLoadBalancerConfigs(lbConfigMap);
        }

        private Map<String, LoadBalancerConfig> fetchLoadBalancerConfigs(Map<String, LBConfig> lbConfigMap) {
            HashMap<String, LoadBalancerConfig> relevantLoadBalancerConfigMap = new HashMap<String, LoadBalancerConfig>();
            for (String lbConfigName : lbConfigMap.keySet()) {
                Map<String, LoadBalancerConfig> allLoadBalancerConfigMap = DeployedItemRefConfigImpl.this.getDomainRoot().getDomainConfig().getLoadBalancerConfigMap();
                for (String loadBalancerName : allLoadBalancerConfigMap.keySet()) {
                    LoadBalancerConfig loadBalancerConfig = allLoadBalancerConfigMap.get(loadBalancerName);
                    if (!loadBalancerConfig.getLbConfigName().equals(lbConfigName)) continue;
                    relevantLoadBalancerConfigMap.put(loadBalancerName, loadBalancerConfig);
                }
            }
            return relevantLoadBalancerConfigMap;
        }
    }
}

