/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRefConfigFactory
extends ConfigFactory {
    public ResourceRefConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("name", "ref");
    }

    public ObjectName create(String referencedResourceName, Map<String, String> optional) {
        String j2eeType = this.getFactoryContainer().getJ2EEType();
        String containerName = this.getFactoryContainer().getName();
        this.getOldResourcesMBean().createResourceReference(containerName, true, referencedResourceName);
        ObjectName pattern = null;
        pattern = "X-StandaloneServerConfig".equals(j2eeType) ? Util.newObjectNamePattern("com.sun.appserv", "type=resource-ref,ref=" + referencedResourceName + ",server=" + containerName) : Util.newObjectNamePattern("com.sun.appserv", "type=resource-ref,ref=" + referencedResourceName + ",cluster=" + containerName);
        Set<ObjectName> oldNames = JMXUtil.queryNames(this.getCallbacks().getMBeanServer(), pattern, null);
        ObjectName oldObjectName = GSetUtil.getSingleton(oldNames);
        ObjectName amxName = this.syncNewAMXMBeanWithOld(oldObjectName);
        return amxName;
    }

    public ObjectName create(String referencedResourceName) {
        return this.create(referencedResourceName, null);
    }

    public ObjectName create(String referencedResourceName, boolean enabled) {
        HashMap<String, String> optionalParams = new HashMap<String, String>();
        optionalParams.put("Enabled", Boolean.toString(enabled));
        return this.create(referencedResourceName, optionalParams);
    }

    @Override
    protected void internalRemove(ObjectName objectName) {
        String containerName = this.getFactoryContainer().getName();
        this.getOldResourcesMBean().deleteResourceReference(containerName, Util.getName(objectName));
    }
}

