/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.monitor.stats;

import com.sun.appserv.management.j2ee.statistics.CountStatisticImpl;
import com.sun.appserv.management.j2ee.statistics.TimeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.lb.ClusterStats;
import com.sun.enterprise.admin.monitor.stats.lb.InstanceStats;
import com.sun.enterprise.admin.monitor.stats.lb.InstanceStatsInterface;
import com.sun.enterprise.admin.monitor.stats.lb.LoadBalancerStatsInterface;
import com.sun.enterprise.management.monitor.stats.CustomStatsImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.pluggable.LBFeatureFactory;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;

public final class LoadBalancerContextRootStatsImpl
implements CustomStatsImpl {
    private String contextRoot = null;
    private String lbName = null;
    private String lbConfigName = null;
    private String clusterName = null;
    private String instanceName = null;
    private String appName = null;
    private LBFeatureFactory lbff = null;
    private long startTime = 0L;

    public Statistic[] getStatistics() {
        LoadBalancerStatsInterface lbstats = this.lbff.getLoadBalancerMonitoringStats(this.lbConfigName, this.lbName);
        InstanceStatsInterface instance = this.getInstanceStats(lbstats);
        return this.createStats(instance);
    }

    public TimeStatistic getResponseTime() {
        LoadBalancerStatsInterface lbstats = this.lbff.getLoadBalancerMonitoringStats(this.lbConfigName, this.lbName);
        InstanceStatsInterface istat = this.getInstanceStats(lbstats);
        if (istat != null) {
            long avgRespTime = Long.parseLong(istat.getApplicationStatsAverageResponseTime());
            long maxRespTime = Long.parseLong(istat.getApplicationStatsMaxResponseTime());
            long minRespTime = Long.parseLong(istat.getApplicationStatsMinResponseTime());
            long totalRequests = Long.parseLong(istat.getApplicationStatsNumTotalRequests());
            long sampleTime = System.currentTimeMillis();
            return this.createResponseTimeStat(maxRespTime, totalRequests, sampleTime, minRespTime, avgRespTime);
        }
        return null;
    }

    public CountStatistic getAverageResponseTime() {
        LoadBalancerStatsInterface lbstats = this.lbff.getLoadBalancerMonitoringStats(this.lbConfigName, this.lbName);
        InstanceStatsInterface istat = this.getInstanceStats(lbstats);
        if (istat != null) {
            long avgRespTime = Long.parseLong(istat.getApplicationStatsAverageResponseTime());
            long sampleTime = System.currentTimeMillis();
            return this.createAverageRespTimeStat(sampleTime, avgRespTime);
        }
        return null;
    }

    public CountStatistic getFailoverReqCount() {
        LoadBalancerStatsInterface lbstats = this.lbff.getLoadBalancerMonitoringStats(this.lbConfigName, this.lbName);
        InstanceStatsInterface istat = this.getInstanceStats(lbstats);
        if (istat != null) {
            long time = Long.parseLong(istat.getApplicationStatsNumFailoverRequests());
            long sampleTime = System.currentTimeMillis();
            return this.createFailoverReqCountStat(sampleTime, time);
        }
        return null;
    }

    public CountStatistic getErrorRequestCount() {
        LoadBalancerStatsInterface lbstats = this.lbff.getLoadBalancerMonitoringStats(this.lbConfigName, this.lbName);
        InstanceStatsInterface istat = this.getInstanceStats(lbstats);
        if (istat != null) {
            long time = Long.parseLong(istat.getApplicationStatsNumErrorRequests());
            long sampleTime = System.currentTimeMillis();
            return this.createErrorRequestCountStat(sampleTime, time);
        }
        return null;
    }

    public CountStatistic getActiveRequestCount() {
        LoadBalancerStatsInterface lbstats = this.lbff.getLoadBalancerMonitoringStats(this.lbConfigName, this.lbName);
        InstanceStatsInterface istat = this.getInstanceStats(lbstats);
        if (istat != null) {
            long time = Long.parseLong(istat.getApplicationStatsNumActiveRequests());
            long sampleTime = System.currentTimeMillis();
            return this.createActiveRequestCountStat(sampleTime, time);
        }
        return null;
    }

    public CountStatistic getTotalRequestCount() {
        LoadBalancerStatsInterface lbstats = this.lbff.getLoadBalancerMonitoringStats(this.lbConfigName, this.lbName);
        InstanceStatsInterface istat = this.getInstanceStats(lbstats);
        if (istat != null) {
            long time = Long.parseLong(istat.getApplicationStatsNumTotalRequests());
            long sampleTime = System.currentTimeMillis();
            return this.createTotalRequestCountStat(sampleTime, time);
        }
        return null;
    }

    public CountStatistic getIdempotentUrlAccessCount() {
        LoadBalancerStatsInterface lbstats = this.lbff.getLoadBalancerMonitoringStats(this.lbConfigName, this.lbName);
        InstanceStatsInterface istat = this.getInstanceStats(lbstats);
        if (istat != null) {
            long time = Long.parseLong(istat.getApplicationStatsNumIdempotentUrlRequests());
            long sampleTime = System.currentTimeMillis();
            return this.createIdempotentUrlAccessCountStat(sampleTime, time);
        }
        return null;
    }

    public LoadBalancerContextRootStatsImpl(String lbName, String lbConfigName, String clusterName, String instanceName, String appName, String contextRoot) {
        this.lbName = lbName;
        this.clusterName = clusterName;
        this.instanceName = instanceName;
        this.appName = appName;
        this.contextRoot = contextRoot;
        this.lbConfigName = lbConfigName;
        this.lbff = ApplicationServer.getServerContext().getPluggableFeatureFactory().getLBFeatureFactory();
        this.startTime = System.currentTimeMillis();
    }

    public LoadBalancerContextRootStatsImpl() {
    }

    private InstanceStatsInterface getInstanceStats(LoadBalancerStatsInterface lbstats) {
        ClusterStats[] cstats;
        if (lbstats == null) {
            return null;
        }
        for (ClusterStats cstat : cstats = lbstats.getClusterStats()) {
            for (InstanceStats istat : cstat.getInstanceStats()) {
                String appid;
                if (!istat.getId().equals(this.instanceName) || !(appid = istat.getApplicationStatsId()).equals(this.contextRoot)) continue;
                return istat;
            }
        }
        return null;
    }

    private Statistic[] createStats(InstanceStatsInterface istat) {
        Statistic[] emptyStats = this.createEmptyStats();
        if (istat == null) {
            return emptyStats;
        }
        long avgRespTime = Long.parseLong(istat.getApplicationStatsAverageResponseTime());
        long maxRespTime = Long.parseLong(istat.getApplicationStatsMaxResponseTime());
        long minRespTime = Long.parseLong(istat.getApplicationStatsMinResponseTime());
        long noActiveReq = Long.parseLong(istat.getApplicationStatsNumActiveRequests());
        long noErrorReq = Long.parseLong(istat.getApplicationStatsNumErrorRequests());
        long noFailoverReq = Long.parseLong(istat.getApplicationStatsNumFailoverRequests());
        long noIdempotentUrlReq = Long.parseLong(istat.getApplicationStatsNumIdempotentUrlRequests());
        long totalRequests = Long.parseLong(istat.getApplicationStatsNumTotalRequests());
        long sampleTime = System.currentTimeMillis();
        Statistic[] statArr = new Statistic[]{this.createResponseTimeStat(maxRespTime, totalRequests, sampleTime, minRespTime, avgRespTime), this.createAverageRespTimeStat(sampleTime, avgRespTime), this.createFailoverReqCountStat(sampleTime, noFailoverReq), this.createErrorRequestCountStat(sampleTime, noErrorReq), this.createActiveRequestCountStat(sampleTime, noActiveReq), this.createTotalRequestCountStat(sampleTime, totalRequests), this.createIdempotentUrlAccessCountStat(sampleTime, noIdempotentUrlReq)};
        return statArr;
    }

    private CountStatistic createAverageRespTimeStat(long sampleTime, long count) {
        return new CountStatisticImpl("AverageResponseTime", "Average Response Time", "MILLISECOND", this.startTime, sampleTime, count);
    }

    private CountStatistic createFailoverReqCountStat(long sampleTime, long count) {
        return new CountStatisticImpl("FailoverReqCount", "Failover Request Count", "NONE", this.startTime, sampleTime, count);
    }

    private CountStatistic createErrorRequestCountStat(long sampleTime, long count) {
        return new CountStatisticImpl("ErrorRequestCount", "Error Request Count", "NONE", this.startTime, sampleTime, count);
    }

    private CountStatistic createActiveRequestCountStat(long sampleTime, long count) {
        return new CountStatisticImpl("ActiveRequestCount", "Active Request Count", "NONE", this.startTime, sampleTime, count);
    }

    private CountStatistic createTotalRequestCountStat(long sampleTime, long count) {
        return new CountStatisticImpl("TotalRequestCount", "Total Request Count", "NONE", this.startTime, sampleTime, count);
    }

    private CountStatistic createIdempotentUrlAccessCountStat(long sampleTime, long count) {
        return new CountStatisticImpl("IdempotentUrlAccessCount", "Idempotent Url Access Count", "NONE", this.startTime, sampleTime, count);
    }

    private TimeStatistic createResponseTimeStat(long maxRespTime, long totalRequests, long sampleTime, long minRespTime, long avgRespTime) {
        return new TimeStatisticImpl("ResponseTime", "Response Time", "MILLISECOND", this.startTime, sampleTime, totalRequests, maxRespTime, minRespTime, totalRequests * avgRespTime);
    }

    private Statistic[] createEmptyStats() {
        Statistic[] statArr1 = new Statistic[]{this.createResponseTimeStat(-1L, -1L, -1L, -1L, -1L), this.createAverageRespTimeStat(-1L, -1L), this.createFailoverReqCountStat(-1L, -1L), this.createErrorRequestCountStat(-1L, -1L), this.createActiveRequestCountStat(-1L, -1L), this.createTotalRequestCountStat(-1L, -1L), this.createIdempotentUrlAccessCountStat(-1L, -1L)};
        return statArr1;
    }
}

