/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.management.offline.AuthRealmConfigBeanHelper;
import com.sun.enterprise.management.offline.ConfigBeanHelper;
import com.sun.enterprise.management.offline.JavaConfigConfigBeanHelper;
import com.sun.enterprise.management.offline.SecurityMapConfigBeanHelper;
import com.sun.enterprise.management.offline.StdConfigBeanHelper;
import java.util.HashMap;
import java.util.Map;

final class ConfigBeanHelperFactory {
    private final ConfigContext mConfigContext;
    private final Map<String, ConfigBeanHelper> mHelperCache;
    private static ConfigBeanHelperFactory INSTANCE = null;
    private static Map<ConfigContext, ConfigBeanHelperFactory> mFactories;

    private ConfigBeanHelperFactory(ConfigContext configContext) {
        this.mConfigContext = configContext;
        this.mHelperCache = new HashMap<String, ConfigBeanHelper>();
    }

    private void debug(Object o) {
        AMXDebug.getInstance().getOutput("ConfigBeanHelperFactory").println(o);
    }

    protected void sdebug(Object o) {
        this.debug(o);
        System.out.println("" + o);
    }

    public static synchronized ConfigBeanHelperFactory getInstance(ConfigContext configContext) {
        ConfigBeanHelperFactory instance;
        if (mFactories == null) {
            mFactories = new HashMap<ConfigContext, ConfigBeanHelperFactory>();
        }
        if ((instance = mFactories.get(configContext)) == null) {
            instance = new ConfigBeanHelperFactory(configContext);
            mFactories.put(configContext, instance);
        }
        return instance;
    }

    private ConfigBeanHelper createHelper(String xPath) throws ConfigException {
        StdConfigBeanHelper helper = null;
        String type = ConfigBeanHelper._getType(xPath);
        ConfigBean configBean = this.mConfigContext.exactLookup(xPath);
        if (configBean == null) {
            throw new IllegalArgumentException("Null configBean returned for type: " + type);
        }
        helper = "auth-realm".equals(type) ? new AuthRealmConfigBeanHelper(this.mConfigContext, configBean) : ("security-map".equals(type) ? new SecurityMapConfigBeanHelper(this.mConfigContext, configBean) : ("java-config".equals(type) ? new JavaConfigConfigBeanHelper(this.mConfigContext, configBean) : new StdConfigBeanHelper(this.mConfigContext, configBean)));
        this.debug("CREATED: " + xPath);
        return helper;
    }

    public ConfigBeanHelper getHelper(String xPath) throws ConfigException {
        if (xPath == null) {
            throw new IllegalArgumentException("null xPath");
        }
        ConfigBeanHelper helper = this.mHelperCache.get(xPath);
        if (helper == null) {
            helper = this.createHelper(xPath);
            this.mHelperCache.put(xPath, helper);
        }
        return helper;
    }

    public ConfigBeanHelper getHelper(ConfigBean configBean) {
        try {
            return this.getHelper(configBean.getXPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

