/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.enterprise.management.support.UpDownInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public final class DownloadInfo
extends UpDownInfo {
    private FileInputStream mInputStream;
    private long mReadSoFar;
    private final long mTotalSize;
    private final boolean mDeleteWhenDone;

    public DownloadInfo(Object id, File theFile, boolean deleteWhenDone) throws IOException {
        super(id, theFile);
        this.mTotalSize = theFile.length();
        if (theFile.length() == 0L) {
            throw new IllegalArgumentException(theFile.toString());
        }
        this.mReadSoFar = 0L;
        this.mDeleteWhenDone = deleteWhenDone;
        if (this.mDeleteWhenDone) {
            theFile.deleteOnExit();
        }
        this.mInputStream = new FileInputStream(theFile);
        assert (!this.isDone());
    }

    public final long getLength() {
        return this.mTotalSize;
    }

    private final long getRemaining() {
        return this.mTotalSize - this.mReadSoFar;
    }

    public boolean isDone() {
        return this.mReadSoFar == this.mTotalSize;
    }

    public synchronized byte[] read(int requestSize) throws IOException {
        if (this.isDone()) {
            throw new IllegalArgumentException("operation has been completed");
        }
        long remaining = this.getRemaining();
        byte[] bytes = null;
        if (remaining != 0L) {
            long actual = remaining < (long)requestSize ? remaining : (long)requestSize;
            bytes = new byte[(int)actual];
            int numRead = this.mInputStream.read(bytes);
            if (numRead != bytes.length) {
                throw new IOException();
            }
            this.mReadSoFar += (long)numRead;
            if (this.isDone()) {
                this.cleanup();
            }
            this.accessed();
        }
        return bytes;
    }

    public synchronized void cleanup() throws IOException {
        if (this.mInputStream != null) {
            this.mInputStream.close();
            this.mInputStream = null;
        }
        if (this.mDeleteWhenDone) {
            this.getFile().delete();
        }
    }
}

