/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.streams;

import java.io.InputStream;

public class JMXInbandStream {
    private static ThreadLocal thrLocal = new ThreadLocal();

    public static void setOutputStream(InputStream in, long len) {
        JMXInbandStreamContext ctx = JMXInbandStream.getContext();
        ctx.outgoing = in;
        if (len > 0L) {
            ctx.length = len;
        }
        thrLocal.set(ctx);
    }

    public static InputStream getOutgoingStream() {
        JMXInbandStreamContext ctx = JMXInbandStream.getContext();
        return ctx.outgoing;
    }

    public static long getOutgoingStreamLength() {
        JMXInbandStreamContext ctx = JMXInbandStream.getContext();
        return ctx.length;
    }

    public static InputStream getInputStream() {
        JMXInbandStreamContext ctx = JMXInbandStream.getContext();
        return ctx.incoming;
    }

    public static void setIncomingStream(InputStream in) {
        JMXInbandStreamContext ctx = JMXInbandStream.getContext();
        ctx.incoming = in;
        thrLocal.set(ctx);
    }

    private static JMXInbandStreamContext getContext() {
        JMXInbandStreamContext ctx = (JMXInbandStreamContext)thrLocal.get();
        if (ctx == null) {
            ctx = new JMXInbandStreamContext();
        }
        return ctx;
    }

    static class JMXInbandStreamContext {
        InputStream outgoing = null;
        InputStream incoming = null;
        long length = -1L;

        JMXInbandStreamContext() {
        }
    }
}

