/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;

public class Print {
    public static final String SYSTEM_DEBUG_MODE = "ri.debugMode";
    public static final String SYSTEM_STACK_FRAME = "ri.print.showStackFrame";
    private static Throwable stackTrace = null;
    private static boolean showStackFrameSource = false;
    private static PrintStream printStackTrace_Stream = null;
    private static File printStackTrace_LogFile = null;

    public static void setDebugMode(boolean state) {
        System.setProperty(SYSTEM_DEBUG_MODE, String.valueOf(state));
    }

    public static boolean isDebugMode() {
        return Boolean.getBoolean(SYSTEM_DEBUG_MODE);
    }

    public static void setPrintStackFrame(boolean state) {
        System.setProperty(SYSTEM_STACK_FRAME, String.valueOf(state));
    }

    public static boolean printStackFrame() {
        return Boolean.getBoolean(SYSTEM_STACK_FRAME);
    }

    public static void setShowStackFrameSource(boolean flag) {
        showStackFrameSource = flag;
    }

    public static StackTraceElement getStackFrame(int frameNum) {
        if (stackTrace == null) {
            stackTrace = new Throwable();
        }
        stackTrace.fillInStackTrace();
        return stackTrace.getStackTrace()[frameNum + 1];
    }

    public static String getStackFrameString(int frameNum) {
        return Print.getStackFrameString(frameNum + 1, showStackFrameSource);
    }

    public static String getStackFrameString(StackTraceElement stackFrame) {
        return Print.getStackFrameString(stackFrame, showStackFrameSource);
    }

    public static String getStackFrameString(int frameNum, boolean showSrc) {
        return Print.getStackFrameString(Print.getStackFrame(frameNum + 1), showSrc);
    }

    public static String getStackFrameString(StackTraceElement stackFrame, boolean showSrc) {
        StringBuffer sb = new StringBuffer();
        if (showSrc) {
            String s = stackFrame.getFileName();
            if (s != null) {
                int p = s.lastIndexOf(File.separator);
                sb.append(p >= 0 ? s.substring(p + 1) : s);
            } else {
                String c = stackFrame.getClassName();
                int p = c.lastIndexOf(".");
                sb.append("<").append(p >= 0 ? c.substring(p + 1) : c).append(">");
            }
        } else {
            String c = stackFrame.getClassName();
            int p = c.lastIndexOf(".");
            sb.append(p >= 0 ? c.substring(p + 1) : c);
        }
        sb.append(".").append(stackFrame.getMethodName());
        if (stackFrame.getLineNumber() >= 0) {
            sb.append(":").append(stackFrame.getLineNumber());
        }
        return sb.toString();
    }

    protected static void _println(PrintStream out, int frameNum, String msg) {
        String m = frameNum >= 0 ? "[" + Print.getStackFrameString(frameNum + 1) + "] " + msg : msg;
        Print.print(out, m + "\n");
    }

    public static void print(PrintStream out, String msg) {
        (out != null ? out : System.out).print(msg);
    }

    public static void dprint(PrintStream out, String msg) {
        if (Print.isDebugMode()) {
            Print.print(out, msg);
        }
    }

    public static void print(String msg) {
        Print.print(null, msg);
    }

    public static void dprint(String msg) {
        if (Print.isDebugMode()) {
            Print.print(null, msg);
        }
    }

    public static void println(PrintStream out, int frameNum, String msg) {
        int f = frameNum >= 0 ? frameNum + 1 : (Print.printStackFrame() ? Math.abs(frameNum) : -1);
        Print._println(out, f, msg);
    }

    public static void dprintln(PrintStream out, int frameNum, String msg) {
        if (Print.isDebugMode()) {
            int f = frameNum >= 0 ? frameNum + 1 : Math.abs(frameNum);
            Print._println(out, f, msg);
        }
    }

    public static void println(int frameNum, String msg) {
        int f = frameNum >= 0 ? frameNum + 1 : (Print.printStackFrame() ? Math.abs(frameNum) : -1);
        Print._println(null, f, msg);
    }

    public static void dprintln(int frameNum, String msg) {
        if (Print.isDebugMode()) {
            int f = frameNum >= 0 ? frameNum + 1 : Math.abs(frameNum);
            Print._println(null, f, msg);
        }
    }

    public static void println(PrintStream out, String msg) {
        Print._println(out, Print.printStackFrame() ? 1 : -1, msg);
    }

    public static void dprintln(PrintStream out, String msg) {
        if (Print.isDebugMode()) {
            Print._println(out, 1, msg);
        }
    }

    public static void println(String msg) {
        Print._println(null, Print.printStackFrame() ? 1 : -1, msg);
    }

    public static void dprintln(String msg) {
        if (Print.isDebugMode()) {
            Print._println(null, 1, msg);
        }
    }

    public static void setStackTraceLogFile(File logFile) {
        if (printStackTrace_Stream != null) {
            printStackTrace_Stream.close();
            printStackTrace_Stream = null;
            printStackTrace_LogFile = null;
        }
        if (logFile != null && logFile.isAbsolute()) {
            try {
                printStackTrace_Stream = new PrintStream(new FileOutputStream(logFile), true);
                printStackTrace_LogFile = logFile;
            }
            catch (IOException ioe) {
                Print.println(0, "Unable to open StackTrace log file: " + logFile);
            }
        }
    }

    private static void _printStackTrace(PrintStream out, int frame, String title, String msg, Throwable excp) {
        String _dash = "----------------------------------------";
        String dashLine = "--------------------------------------------------------------------------------\n";
        String _ttl = " " + title + " ";
        String errTitle = "--------------------------------------------------------------------------------\n".substring(0, 16) + _ttl + "--------------------------------------------------------------------------------\n".substring(16 + _ttl.length());
        if (out == null) {
            out = System.out;
        }
        Print.print(out, "\n");
        Print.print(out, "--------------------------------------------------------------------------------\n" + errTitle);
        Print.print(out, "[" + Print.getStackFrameString(frame + 1) + "]\n");
        if (msg != null && !msg.equals("")) {
            Print.print(out, msg + "\n");
        }
        if (excp != null) {
            Print.print(out, excp.toString() + "\n");
            Print.print(out, "--------------------------------------------------------------------------------\n");
            excp.printStackTrace(out);
        } else {
            Print.print(out, "--------------------------------------------------------------------------------\n");
            Print.print(out, "Stack Trace:\n");
            Throwable t = new Throwable();
            t.fillInStackTrace();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            t.printStackTrace(ps);
            StringTokenizer st = new StringTokenizer(bos.toString(), "\n");
            st.nextToken();
            for (int i = 0; i < frame + 1; ++i) {
                st.nextToken();
            }
            while (st.hasMoreTokens()) {
                Print.println(out, st.nextToken());
            }
        }
        Print.print(out, "--------------------------------------------------------------------------------\n");
        Print.print(out, "\n");
    }

    public static void printStackTrace(PrintStream out, int frame, String title, String msg, Throwable excp) {
        if (out == null) {
            out = printStackTrace_Stream;
        }
        if (out != null && out != System.out && out != System.err) {
            Print.print("\n");
            if (excp != null) {
                String m = msg != null && !msg.equals("") ? msg + " - " : "";
                Print.println(null, frame + 1, "Error: " + m + excp + "");
                StackTraceElement[] ste = excp.getStackTrace();
                if (ste.length > 0) {
                    Print.print("  ==> at " + Print.getStackFrameString(ste[0]) + "\n");
                }
            } else {
                Print.println(null, frame + 1, msg);
            }
            if (printStackTrace_LogFile != null) {
                Print.print("(Stack trace logged to '" + printStackTrace_LogFile + "')\n");
            }
            Print.print("\n");
        }
        Print._printStackTrace(out, frame + 1, title, msg, excp);
    }

    public static void dprintStackTrace(PrintStream out, int frame, String title, String msg, Throwable excp) {
        if (Print.isDebugMode()) {
            if (out == null) {
                out = printStackTrace_Stream;
            }
            if (out != null && out != System.out && out != System.err) {
                String m = excp != null ? msg + " (" + excp + ")" : msg;
                Print.println(null, frame + 1, "{log} " + m);
            }
            Print._printStackTrace(out, frame + 1, title, msg, excp);
        }
    }

    public static void printStackTrace(String title, String msg, Throwable excp) {
        Print.printStackTrace(null, 1, title, msg, excp);
    }

    public static void dprintStackTrace(String title, String msg, Throwable excp) {
        if (Print.isDebugMode()) {
            Print.dprintStackTrace(null, 1, title, msg, excp);
        }
    }

    public static void printStackTrace(String msg, Throwable excp) {
        String title = excp != null ? "Exception" : "StackTrace";
        Print.printStackTrace(null, 1, title, msg, excp);
    }

    public static void dprintStackTrace(String msg, Throwable excp) {
        if (Print.isDebugMode()) {
            String title = excp != null ? "(DEBUG) Exception" : "(DEBUG) StackTrace";
            Print.dprintStackTrace(null, 1, title, msg, excp);
        }
    }

    public static void printStackTrace(String msg) {
        Print.printStackTrace(null, 1, "StackTrace", msg, null);
    }

    public static void dprintStackTrace(String msg) {
        if (Print.isDebugMode()) {
            Print.dprintStackTrace(null, 1, "(DEBUG) StackTrace", msg, null);
        }
    }

    public static void printStackTrace(int frame, String msg) {
        Print.printStackTrace(null, frame + 1, "StackTrace", msg, null);
    }

    public static void dprintStackTrace(int frame, String msg) {
        if (Print.isDebugMode()) {
            Print.dprintStackTrace(null, frame + 1, "(DEBUG) StackTrace", msg, null);
        }
    }

    public static String printStackTraceToString() {
        Throwable t = new Throwable("printStackTraceToString");
        t.fillInStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        String stackTrace = stringWriter.toString();
        printWriter.close();
        return stackTrace;
    }
}

