/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandEnvironment;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Vector;

public class ExportCommand
extends S1ASCommand {
    private static final String ENVIRONMENT_PREFIX = "AS_ADMIN_";
    private static final String ENVIRONMENT_DELIMITER = "=";
    private static final String PASSWORD_STRING = "password";
    private CommandEnvironment commandEnvironment = CommandEnvironment.getInstance();

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        Vector operands = this.getOperands();
        if (operands.size() == 0) {
            this.printEnvValues();
            return;
        }
        for (int ii = 0; ii < operands.size(); ++ii) {
            this.updateEnvironment((String)operands.elementAt(ii));
        }
    }

    private String checkForPrefix(String name) throws CommandException {
        String envName = null;
        if (!name.regionMatches(true, 0, ENVIRONMENT_PREFIX, 0, ENVIRONMENT_PREFIX.length())) {
            throw new CommandException(this.getLocalizedString("CouldNotSetVariable", new Object[]{name}));
        }
        envName = name.substring(ENVIRONMENT_PREFIX.length());
        return envName.toLowerCase();
    }

    private void printEnvValues() {
        if (this.commandEnvironment.getNumEnvironments() == 0) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoEnvironment"));
        }
        for (String name : this.commandEnvironment.getEnvironments().keySet()) {
            String envName = ENVIRONMENT_PREFIX.concat(name.toUpperCase());
            CLILogger.getInstance().printDebugMessage(this.commandEnvironment.toString());
            this.printOneEnvValue(name, envName);
        }
    }

    private void printOneEnvValue(String name, String displayName) {
        if (name.endsWith(PASSWORD_STRING)) {
            CLILogger.getInstance().printMessage(displayName + " = ********");
        } else {
            CLILogger.getInstance().printMessage(displayName + " = " + (String)this.commandEnvironment.getEnvironmentValue(name));
        }
    }

    private void updateEnvironment(String nameStr) throws CommandException {
        int nameend = nameStr.indexOf(ENVIRONMENT_DELIMITER);
        if (nameend == nameStr.length() - 1) {
            String envName = this.checkForPrefix(nameStr.substring(0, nameend));
            if (this.commandEnvironment.removeEnvironment(envName) == null) {
                throw new CommandException(this.getLocalizedString("UnableToRemoveEnv", new Object[]{nameStr}));
            }
        } else if (nameend == -1) {
            String name = this.checkForPrefix(nameStr);
            this.printOneEnvValue(name, nameStr);
        } else {
            String envName = this.checkForPrefix(nameStr.substring(0, nameend));
            this.commandEnvironment.setEnvironment(envName, nameStr.substring(nameend + 1));
        }
    }
}

