/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.cli.commands.BaseLifeCycleCommand;
import com.sun.enterprise.cli.commands.DomainReporter;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.BitSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

public class StartDomainCommand
extends BaseLifeCycleCommand {
    private static final String SERVER_LOG_FILE_NAME = "server.log";
    private static final String LOGS_DIR = "logs";
    private static final String VERBOSE = "verbose";
    private static final String APPLICATION_SERVER_8_0 = "Application Server 8.0";
    private static final String DTD_FILE_8_0 = "sun-domain_1_0";
    private static final String DTD_FILE_8_1 = "sun-domain_1_1";
    private static final long UPGRADE_TIMEOUT = 1200000L;
    private static final String ADDONINSTALLER = "com.sun.enterprise.addon.AddonInstaller";
    private static final String INSTALLERMETHOD = "installAllAddons";
    private String domainName;
    private DomainConfig config;
    private DomainsManager mgr;
    private String adminPwdAlias;
    private BitSet flags;
    private boolean doBackupMessage = true;
    private static final boolean enableBackups = false;

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void startDomain(String DomainName) throws CommandException, CommandValidationException {
        this.domainName = DomainName;
        long start = System.currentTimeMillis();
        try {
            this.doBackupMessage = false;
            this.init();
            this.checkIfRunning();
            this.checkIfStopping();
            this.doBackupMessage = true;
            this.validateDomain();
            this.doBackupMessage = false;
            this.validateAdminPassword();
            this.validateMasterPassword();
            this.saveExtraPasswordOptions();
            this.doBackupMessage = true;
            this.installAddons();
            this.checkAndExecuteUpgrade(this.domainName);
            this.mgr.startDomain(this.config);
            if (this.flags.get(1)) {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("DomainStarted", new Object[]{this.domainName}));
            } else {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("DomainReady", new Object[]{this.domainName}));
            }
            boolean terse = this.getBooleanOption("terse");
            new DomainReporter(this.config, terse).report();
            long msec = System.currentTimeMillis() - start;
            double sec = (double)Math.round((double)msec / 100.0) / 10.0;
            CLILogger.getInstance().printDebugMessage(this.getLocalizedString("DomainStartTime", new Object[]{sec}));
        }
        catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(this.getLocalizedString("CannotStartDomain", new Object[]{this.domainName}), e);
        }
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        String domainName = null;
        try {
            domainName = this.getDomainName();
        }
        catch (Exception e) {
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            domainName = domainName == null ? this.getLocalizedString("Undefined") : domainName;
            throw new CommandException(this.getLocalizedString("CannotStartDomain", new Object[]{domainName}), e);
        }
        this.startDomain(domainName);
    }

    private void checkAndExecuteUpgrade(String domainName) throws CommandException {
        String domainDir = this.getDomainsRoot();
        CLILogger.getInstance().printDebugMessage("domainDir = " + domainDir);
        String installDir = System.getProperty("com.sun.aas.installRoot");
        CLILogger.getInstance().printDebugMessage("installDir = " + installDir);
        CLILogger.getInstance().printDebugMessage("domainName = " + domainName);
        if (this.checkIfVersion80(domainName, domainDir, installDir)) {
            try {
                String sPasswordFile = this.createPasswordFileText();
                String[] upgradeCmd = new String[]{installDir + File.separator + "bin" + File.separator + "asupgrade", "-c", "-s", domainDir + File.separator + domainName, "-t", installDir, "--passwordfile", sPasswordFile, "-noprompt"};
                ProcessExecutor pe = new ProcessExecutor(upgradeCmd, 1200000L);
                pe.execute();
                Process process = pe.getSubProcess();
                int exitValue = process.waitFor();
                if (exitValue != 0) {
                    System.out.println("Please exeucte asupgrade manually to upgrade the configuration");
                    throw new CommandException(this.getLocalizedString("UpgradeFailed"));
                }
            }
            catch (Exception e) {
                throw new CommandException(this.getLocalizedString("UpgradeFailed"), e);
            }
        }
    }

    private boolean checkIfVersion80(String domainName, String domainDir, String installDir) throws CommandException {
        PEFileLayout layout = new PEFileLayout((RepositoryConfig)this.config);
        File domainFile = layout.getDomainConfigFile();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(domainFile);
            String publicID = adminServerDoc.getDoctype().getPublicId();
            String systemID = adminServerDoc.getDoctype().getSystemId();
            CLILogger.getInstance().printDebugMessage("publicID = " + publicID);
            CLILogger.getInstance().printDebugMessage("systemID = " + systemID);
            return publicID.indexOf(APPLICATION_SERVER_8_0) != -1 && (systemID.indexOf(DTD_FILE_8_0) != -1 || systemID.indexOf(DTD_FILE_8_1) != -1);
        }
        catch (Exception e) {
            return false;
        }
    }

    private String createPasswordFileText() throws Exception {
        File fPasswordFile = File.createTempFile("passwordfile", null);
        fPasswordFile.deleteOnExit();
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fPasswordFile.toString())));
        out.println("AS_ADMIN_PASSWORD = " + (String)this.config.get((Object)"domain.password"));
        out.println("AS_ADMIN_MASTERPASSWORD = " + (String)this.config.get((Object)"domain.masterPassword"));
        out.close();
        return fPasswordFile.toString();
    }

    private String getDomainLogFile(String domainName) throws CommandException {
        String logFile = this.getDomainsRoot() + File.separator + domainName + File.separator + LOGS_DIR + File.separator + SERVER_LOG_FILE_NAME;
        return logFile;
    }

    private boolean isNotRunning(DomainsManager mgr, DomainConfig cfg) throws Exception {
        InstancesManager im = mgr.getInstancesManager((RepositoryConfig)cfg);
        int state = im.getInstanceStatus();
        return state == 3;
    }

    private boolean isStopping(DomainsManager mgr, DomainConfig cfg) throws Exception {
        InstancesManager im = mgr.getInstancesManager((RepositoryConfig)cfg);
        int state = im.getInstanceStatus();
        return state == 2;
    }

    private void checkOnBackup(DomainConfig config) {
        if (config == null) {
            return;
        }
        try {
            File domainsRoot = new File(config.getRepositoryRoot());
            File domainRoot = new File(domainsRoot, config.getDomainName());
            File configDir = new File(domainRoot, "config");
            File domainxml = new File(configDir, "domain.xml");
            File backup = new File(configDir, "domain_bu.xml");
            if (backup.exists()) {
                this.pr("NoStartAdvice", backup.getAbsolutePath(), domainxml.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void init() throws CommandException {
        this.mgr = this.getFeatureFactory().getDomainsManager();
        CLILogger.getInstance().printDetailMessage(this.getLocalizedString("StartingDomain", new Object[]{this.domainName}));
        if (!this.getBooleanOption(VERBOSE)) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("LogRedirectedTo", new Object[]{this.getDomainLogFile(this.domainName)}));
        }
        this.config = this.getDomainConfig(this.domainName);
    }

    private void installAddons() {
        try {
            Class<?> main = Class.forName(ADDONINSTALLER);
            Object obj = main.newInstance();
            Class[] types = new Class[]{String.class, String.class};
            Method method = main.getMethod(INSTALLERMETHOD, types);
            String installDir = System.getProperty("com.sun.aas.installRoot");
            String domainInstanceRoot = this.getDomainsRoot() + File.separator + this.getDomainName();
            Object[] args1 = new Object[]{installDir, domainInstanceRoot};
            method.invoke(obj, args1);
        }
        catch (Exception ex) {
            CLILogger.getInstance().printDetailMessage(ex.getLocalizedMessage());
        }
    }

    private void checkIfRunning() throws Exception {
        if (!this.isNotRunning(this.mgr, this.config)) {
            throw new CommandException(this.getLocalizedString("CannotStartDomainAlreadyRunning", new Object[]{this.domainName}));
        }
    }

    private void checkIfStopping() throws Exception {
        if (this.isStopping(this.mgr, this.config)) {
            throw new CommandException(this.getLocalizedString("CannotStartStoppingDomain", new Object[]{this.domainName}));
        }
    }

    private void validateDomain() throws DomainException {
        this.mgr.validateDomain(this.config, true);
    }

    private void validateAdminPassword() throws CommandValidationException, DomainException, CommandException {
        this.flags = this.mgr.getDomainFlags();
        if (this.flags.get(1)) {
            this.config.put((Object)"domain.user", (Object)this.getUser());
            this.config.put((Object)"domain.password", (Object)this.getPassword());
            if (this.getOption("passwordfile") != null) {
                this.adminPwdAlias = RelativePathResolver.getAlias((String)((String)this.config.get((Object)"domain.password")));
            }
            if (this.adminPwdAlias == null) {
                this.mgr.validateAdminUserAndPassword(this.config);
            }
        }
    }

    private void validateMasterPassword() throws Exception {
        String masterPassword = this.getMasterPassword(new RepositoryManager(), (RepositoryConfig)this.config);
        this.config.put((Object)"domain.masterPassword", (Object)masterPassword);
        this.mgr.validateMasterPassword(this.config);
        if (this.adminPwdAlias != null) {
            String domainsRoot = (String)this.config.get((Object)"domains.root");
            String keyStoreFile = domainsRoot + File.separator + this.domainName + File.separator + "config" + File.separator + "domain-passwords";
            PasswordAdapter p = new PasswordAdapter(keyStoreFile, masterPassword.toCharArray());
            String clearPwd = p.getPasswordForAlias(this.adminPwdAlias);
            this.config.put((Object)"domain.password", (Object)clearPwd);
            this.mgr.validateAdminUserAndPassword(this.config);
        }
    }

    private void saveExtraPasswordOptions() throws CommandValidationException, CommandException, DomainException {
        String[] extraPasswordOptions = this.mgr.getExtraPasswordOptions(this.config);
        if (extraPasswordOptions != null) {
            this.config.put((Object)"domain.extraPasswords", (Object)this.getExtraPasswords(extraPasswordOptions));
        }
    }

    private void saveCopyOfConfig(DomainConfig config) {
        File domainsRoot = new File(config.getRepositoryRoot());
        File domainRoot = new File(domainsRoot, config.getDomainName());
        File configDir = new File(domainRoot, "config");
        File domainxml = new File(configDir, "domain.xml");
        File backup = new File(configDir, "domain_bu.xml");
        try {
            FileUtils.copy((String)domainxml.getAbsolutePath(), (String)backup.getAbsolutePath());
            this.pr("ConfigBackedupOK", backup.getAbsolutePath());
        }
        catch (Exception e) {
            this.pr("ConfigBackedupNot", domainxml.getAbsolutePath(), backup.getAbsolutePath());
        }
    }

    private void pr(String id, Object o) {
        String s = this.getLocalizedString(id, new Object[]{o});
        CLILogger.getInstance().printDetailMessage(s);
    }

    private void pr(String id, Object o1, Object o2) {
        String s = this.getLocalizedString(id, new Object[]{o1, o2});
        CLILogger.getInstance().printDetailMessage(s);
    }
}

