/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.servicecontext;

import com.sun.corba.ee.impl.encoding.CDRInputStream;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.servicecontext.ServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContextFactoryRegistry;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ServiceContextsImpl
implements ServiceContexts {
    private com.sun.corba.ee.spi.orb.ORB orb;
    private Map<Integer, Object> scMap;
    private CodeBase codeBase;
    private GIOPVersion giopVersion;
    private ORBUtilSystemException wrapper;

    private static boolean isDebugging(OutputStream os) {
        com.sun.corba.ee.spi.orb.ORB orb = (com.sun.corba.ee.spi.orb.ORB)((Object)os.orb());
        if (orb == null) {
            return false;
        }
        return orb.serviceContextDebugFlag;
    }

    private static boolean isDebugging(InputStream is) {
        com.sun.corba.ee.spi.orb.ORB orb = (com.sun.corba.ee.spi.orb.ORB)((Object)is.orb());
        if (orb == null) {
            return false;
        }
        return orb.serviceContextDebugFlag;
    }

    private void dprint(String msg) {
        ORBUtility.dprint(this, msg);
    }

    private void createMapFromInputStream(InputStream is) {
        this.orb = (com.sun.corba.ee.spi.orb.ORB)((Object)is.orb());
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Constructing ServiceContexts from input stream");
        }
        int numValid = is.read_long();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Number of service contexts = " + numValid);
        }
        for (int ctr = 0; ctr < numValid; ++ctr) {
            int scId = is.read_long();
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Reading service context id " + scId);
            }
            byte[] data = OctetSeqHelper.read((org.omg.CORBA.portable.InputStream)is);
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Service context" + scId + " length: " + data.length);
            }
            this.scMap.put(scId, data);
        }
    }

    public ServiceContextsImpl(com.sun.corba.ee.spi.orb.ORB orb) {
        this.orb = orb;
        this.wrapper = ORBUtilSystemException.get(orb, "rpc.protocol");
        this.scMap = new HashMap<Integer, Object>();
        this.giopVersion = orb.getORBData().getGIOPVersion();
        this.codeBase = null;
    }

    public ServiceContextsImpl(InputStream s) {
        this((com.sun.corba.ee.spi.orb.ORB)((Object)s.orb()));
        this.codeBase = ((CDRInputStream)s).getCodeBase();
        this.createMapFromInputStream(s);
        this.giopVersion = ((CDRInputStream)s).getGIOPVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceContext unmarshal(int scId, byte[] data) {
        ServiceContextFactoryRegistry scr = this.orb.getServiceContextFactoryRegistry();
        ServiceContext.Factory factory = scr.find(scId);
        ServiceContext sc = null;
        if (factory == null) {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Could not find ServiceContext.Factory for " + scId + " using UnknownServiceContext");
            }
            sc = ServiceContextDefaults.makeUnknownServiceContext(scId, data);
        } else {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Found " + factory);
            }
            EncapsInputStream eis = new EncapsInputStream((ORB)((Object)this.orb), data, data.length, this.giopVersion, this.codeBase);
            try {
                eis.consumeEndian();
                sc = factory.create(eis, this.giopVersion);
            }
            finally {
                try {
                    eis.close();
                }
                catch (IOException e) {
                    this.wrapper.ioexceptionDuringStreamClose(e);
                }
            }
            if (sc == null) {
                throw this.wrapper.svcctxUnmarshalError(CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return sc;
    }

    public void write(OutputStream os, GIOPVersion gv) {
        if (ServiceContextsImpl.isDebugging(os)) {
            this.dprint("Writing service contexts to output stream");
            Utility.printStackTrace();
        }
        int numsc = this.scMap.size();
        if (ServiceContextsImpl.isDebugging(os)) {
            this.dprint("Service context has " + numsc + " components");
        }
        os.write_long(numsc);
        this.writeServiceContextsInOrder(os, gv);
        if (ServiceContextsImpl.isDebugging(os)) {
            this.dprint("Service context writing complete");
        }
    }

    private void writeServiceContextsInOrder(OutputStream os, GIOPVersion gv) {
        int ueid = 9;
        for (int i : this.scMap.keySet()) {
            if (i == ueid) continue;
            this.writeMapEntry(os, i, this.scMap.get(i), gv);
        }
        Object uesc = this.scMap.get(ueid);
        if (uesc != null) {
            this.writeMapEntry(os, ueid, uesc, gv);
        }
    }

    private void writeMapEntry(OutputStream os, int id, Object scObj, GIOPVersion gv) {
        if (scObj instanceof byte[]) {
            byte[] sc = (byte[])scObj;
            if (ServiceContextsImpl.isDebugging(os)) {
                this.dprint("Writing service context bytes for id " + id);
            }
            OctetSeqHelper.write((org.omg.CORBA.portable.OutputStream)os, (byte[])sc);
        } else if (scObj instanceof ServiceContext) {
            ServiceContext sc = (ServiceContext)scObj;
            if (ServiceContextsImpl.isDebugging(os)) {
                this.dprint("Writing service context " + sc);
            }
            sc.write(os, gv);
        } else {
            this.wrapper.errorInServiceContextMap();
        }
    }

    public void put(ServiceContext sc) {
        this.scMap.put(sc.getId(), sc);
    }

    public void delete(int scId) {
        this.scMap.remove(new Integer(scId));
    }

    public ServiceContext get(int id) {
        Object result = this.scMap.get(id);
        if (result == null) {
            return null;
        }
        if (result instanceof byte[]) {
            ServiceContext sc = this.unmarshal(id, (byte[])result);
            this.scMap.put(id, sc);
            return sc;
        }
        return (ServiceContext)result;
    }
}

