/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.org.apache.bcel.util;

import com.sun.corba.ee.org.apache.bcel.Constants;
import com.sun.corba.ee.org.apache.bcel.classfile.Utility;
import com.sun.corba.ee.org.apache.bcel.generic.AllocationInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.ArrayInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.BranchHandle;
import com.sun.corba.ee.org.apache.bcel.generic.BranchInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.CHECKCAST;
import com.sun.corba.ee.org.apache.bcel.generic.CPInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.CodeExceptionGen;
import com.sun.corba.ee.org.apache.bcel.generic.ConstantPoolGen;
import com.sun.corba.ee.org.apache.bcel.generic.ConstantPushInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.EmptyVisitor;
import com.sun.corba.ee.org.apache.bcel.generic.FieldInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.IINC;
import com.sun.corba.ee.org.apache.bcel.generic.INSTANCEOF;
import com.sun.corba.ee.org.apache.bcel.generic.Instruction;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionConstants;
import com.sun.corba.ee.org.apache.bcel.generic.InstructionHandle;
import com.sun.corba.ee.org.apache.bcel.generic.InvokeInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.LDC;
import com.sun.corba.ee.org.apache.bcel.generic.LDC2_W;
import com.sun.corba.ee.org.apache.bcel.generic.LocalVariableInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.MULTIANEWARRAY;
import com.sun.corba.ee.org.apache.bcel.generic.MethodGen;
import com.sun.corba.ee.org.apache.bcel.generic.NEWARRAY;
import com.sun.corba.ee.org.apache.bcel.generic.ObjectType;
import com.sun.corba.ee.org.apache.bcel.generic.RET;
import com.sun.corba.ee.org.apache.bcel.generic.ReturnInstruction;
import com.sun.corba.ee.org.apache.bcel.generic.Select;
import com.sun.corba.ee.org.apache.bcel.generic.Type;
import com.sun.corba.ee.org.apache.bcel.util.BCELifier;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;

class BCELFactory
extends EmptyVisitor {
    private MethodGen _mg;
    private PrintWriter _out;
    private ConstantPoolGen _cp;
    private HashMap branch_map = new HashMap();
    private ArrayList branches = new ArrayList();

    BCELFactory(MethodGen mg, PrintWriter out) {
        this._mg = mg;
        this._cp = mg.getConstantPool();
        this._out = out;
    }

    public void start() {
        if (!this._mg.isAbstract() && !this._mg.isNative()) {
            for (InstructionHandle ih = this._mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
                Instruction i = ih.getInstruction();
                if (i instanceof BranchInstruction) {
                    this.branch_map.put(i, ih);
                }
                if (ih.hasTargeters()) {
                    if (i instanceof BranchInstruction) {
                        this._out.println("    InstructionHandle ih_" + ih.getPosition() + ";");
                    } else {
                        this._out.print("    InstructionHandle ih_" + ih.getPosition() + " = ");
                    }
                } else {
                    this._out.print("    ");
                }
                if (this.visitInstruction(i)) continue;
                i.accept(this);
            }
            this.updateBranchTargets();
            this.updateExceptionHandlers();
        }
    }

    private boolean visitInstruction(Instruction i) {
        short opcode = i.getOpcode();
        if (InstructionConstants.INSTRUCTIONS[opcode] != null && !(i instanceof ConstantPushInstruction) && !(i instanceof ReturnInstruction)) {
            this._out.println("il.append(InstructionConstants." + i.getName().toUpperCase() + ");");
            return true;
        }
        return false;
    }

    public void visitLocalVariableInstruction(LocalVariableInstruction i) {
        short opcode = i.getOpcode();
        Type type = i.getType(this._cp);
        if (opcode == 132) {
            this._out.println("il.append(new IINC(" + i.getIndex() + ", " + ((IINC)i).getIncrement() + "));");
        } else {
            String kind = opcode < 54 ? "Load" : "Store";
            this._out.println("il.append(_factory.create" + kind + "(" + BCELifier.printType(type) + ", " + i.getIndex() + "));");
        }
    }

    public void visitArrayInstruction(ArrayInstruction i) {
        short opcode = i.getOpcode();
        Type type = i.getType(this._cp);
        String kind = opcode < 79 ? "Load" : "Store";
        this._out.println("il.append(_factory.createArray" + kind + "(" + BCELifier.printType(type) + "));");
    }

    public void visitFieldInstruction(FieldInstruction i) {
        short opcode = i.getOpcode();
        String class_name = i.getClassName(this._cp);
        String field_name = i.getFieldName(this._cp);
        Type type = i.getFieldType(this._cp);
        this._out.println("il.append(_factory.createFieldAccess(\"" + class_name + "\", \"" + field_name + "\", " + BCELifier.printType(type) + ", " + "Constants." + Constants.OPCODE_NAMES[opcode].toUpperCase() + "));");
    }

    public void visitInvokeInstruction(InvokeInstruction i) {
        short opcode = i.getOpcode();
        String class_name = i.getClassName(this._cp);
        String method_name = i.getMethodName(this._cp);
        Type type = i.getReturnType(this._cp);
        Type[] arg_types = i.getArgumentTypes(this._cp);
        this._out.println("il.append(_factory.createInvoke(\"" + class_name + "\", \"" + method_name + "\", " + BCELifier.printType(type) + ", " + BCELifier.printArgumentTypes(arg_types) + ", " + "Constants." + Constants.OPCODE_NAMES[opcode].toUpperCase() + "));");
    }

    public void visitAllocationInstruction(AllocationInstruction i) {
        Type type = i instanceof CPInstruction ? ((CPInstruction)((Object)i)).getType(this._cp) : ((NEWARRAY)i).getType();
        short opcode = ((Instruction)((Object)i)).getOpcode();
        short dim = 1;
        switch (opcode) {
            case 187: {
                this._out.println("il.append(_factory.createNew(\"" + ((ObjectType)type).getClassName() + "\"));");
                break;
            }
            case 197: {
                dim = ((MULTIANEWARRAY)i).getDimensions();
            }
            case 188: 
            case 189: {
                this._out.println("il.append(_factory.createNewArray(" + BCELifier.printType(type) + ", (short) " + dim + "));");
                break;
            }
            default: {
                throw new RuntimeException("Oops: " + opcode);
            }
        }
    }

    private void createConstant(Object value) {
        String embed = value.toString();
        if (value instanceof String) {
            embed = '\"' + Utility.convertString(value.toString()) + '\"';
        } else if (value instanceof Character) {
            embed = "(char)0x" + Integer.toHexString(((Character)value).charValue());
        }
        this._out.println("il.append(new PUSH(_cp, " + embed + "));");
    }

    public void visitLDC(LDC i) {
        this.createConstant(i.getValue(this._cp));
    }

    public void visitLDC2_W(LDC2_W i) {
        this.createConstant(i.getValue(this._cp));
    }

    public void visitConstantPushInstruction(ConstantPushInstruction i) {
        this.createConstant(i.getValue());
    }

    public void visitINSTANCEOF(INSTANCEOF i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(new INSTANCEOF(_cp.addClass(" + BCELifier.printType(type) + ")));");
    }

    public void visitCHECKCAST(CHECKCAST i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(_factory.createCheckCast(" + BCELifier.printType(type) + "));");
    }

    public void visitReturnInstruction(ReturnInstruction i) {
        Type type = i.getType(this._cp);
        this._out.println("il.append(_factory.createReturn(" + BCELifier.printType(type) + "));");
    }

    public void visitBranchInstruction(BranchInstruction bi) {
        BranchHandle bh = (BranchHandle)this.branch_map.get(bi);
        int pos = bh.getPosition();
        String name = bi.getName() + "_" + pos;
        if (bi instanceof Select) {
            int i;
            Select s = (Select)bi;
            this.branches.add(bi);
            StringBuffer args = new StringBuffer("new int[] { ");
            int[] matchs = s.getMatchs();
            for (i = 0; i < matchs.length; ++i) {
                args.append(matchs[i]);
                if (i >= matchs.length - 1) continue;
                args.append(", ");
            }
            args.append(" }");
            this._out.print("    Select " + name + " = new " + bi.getName().toUpperCase() + "(" + args + ", new InstructionHandle[] { ");
            for (i = 0; i < matchs.length; ++i) {
                this._out.print("null");
                if (i >= matchs.length - 1) continue;
                this._out.print(", ");
            }
            this._out.println(");");
        } else {
            String target;
            int t_pos = bh.getTarget().getPosition();
            if (pos > t_pos) {
                target = "ih_" + t_pos;
            } else {
                this.branches.add(bi);
                target = "null";
            }
            this._out.println("    BranchInstruction " + name + " = _factory.createBranchInstruction(" + "Constants." + bi.getName().toUpperCase() + ", " + target + ");");
        }
        if (bh.hasTargeters()) {
            this._out.println("    ih_" + pos + " = il.append(" + name + ");");
        } else {
            this._out.println("    il.append(" + name + ");");
        }
    }

    public void visitRET(RET i) {
        this._out.println("il.append(new RET(" + i.getIndex() + ")));");
    }

    private void updateBranchTargets() {
        for (BranchInstruction bi : this.branches) {
            BranchHandle bh = (BranchHandle)this.branch_map.get(bi);
            int pos = bh.getPosition();
            String name = bi.getName() + "_" + pos;
            int t_pos = bh.getTarget().getPosition();
            this._out.println("    " + name + ".setTarget(ih_" + t_pos + ");");
            if (!(bi instanceof Select)) continue;
            InstructionHandle[] ihs = ((Select)bi).getTargets();
            for (int j = 0; j < ihs.length; ++j) {
                t_pos = ihs[j].getPosition();
                this._out.println("    " + name + ".setTarget(" + j + ", ih_" + t_pos + ");");
            }
        }
    }

    private void updateExceptionHandlers() {
        CodeExceptionGen[] handlers = this._mg.getExceptionHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            CodeExceptionGen h = handlers[i];
            String type = h.getCatchType() == null ? "null" : BCELifier.printType(h.getCatchType());
            this._out.println("    method.addExceptionHandler(ih_" + h.getStartPC().getPosition() + ", " + "ih_" + h.getEndPC().getPosition() + ", " + "ih_" + h.getHandlerPC().getPosition() + ", " + type + ");");
        }
    }
}

