/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.ejb.spi.io.SerializableObjectFactory;
import com.sun.enterprise.Switch;
import com.sun.enterprise.util.ObjectInputStreamWithLoader;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.util.logging.Level;
import java.util.logging.Logger;

class EJBObjectInputStream
extends ObjectInputStreamWithLoader {
    private static Logger _ejbLogger = LogDomains.getLogger("javax.enterprise.system.container.ejb");

    EJBObjectInputStream(InputStream in, ClassLoader cl, boolean resolve) throws IOException, StreamCorruptedException {
        super(in, cl);
        if (resolve) {
            this.enableResolveObject(resolve);
        }
    }

    protected Object resolveObject(Object obj) throws IOException {
        try {
            if (StubAdapter.isStub(obj)) {
                Switch.getSwitch().getProtocolManager().connectObject((Remote)obj);
                return obj;
            }
            if (obj instanceof SerializableObjectFactory) {
                return ((SerializableObjectFactory)obj).createObject();
            }
            return obj;
        }
        catch (IOException ioEx) {
            _ejbLogger.log(Level.SEVERE, "ejb.resolve_object_exception", ioEx);
            throw ioEx;
        }
        catch (Exception ex) {
            _ejbLogger.log(Level.SEVERE, "ejb.resolve_object_exception", ex);
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> cl = Class.forName(interfaces[i], false, this.loader);
            if ((cl.getModifiers() & 1) == 0) {
                return super.resolveProxyClass(interfaces);
            }
            classObjs[i] = cl;
        }
        try {
            return Proxy.getProxyClass(this.loader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

