/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.InvalidBean;
import com.sun.ejb.codegen.InvalidHome;
import com.sun.ejb.codegen.MethodNotFound;
import com.sun.enterprise.deployment.DeploymentContext;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EntityBean;
import javax.ejb.SessionBean;
import sun.rmi.rmic.IndentingWriter;

public class HomeGenerator
extends Generator {
    private static Logger _logger = null;
    private static LocalStringManagerImpl localStrings;
    public static String LOCAL_SUFFIX;
    public static String REMOTE_SUFFIX;
    private Method[] factoryMethods;
    private Method[] allbeanMethods;
    private Class homeInterface;
    private Class bean;
    private String homeImpl;
    private EjbDescriptor dd;
    private boolean isLocal = false;
    private static int CREATE;
    private static int FINDER;
    private static int OTHER;
    private boolean isReadOnlyBean = false;
    private static final String READ_ONLY_EJB_HOME_IMPL = "com.sun.ejb.containers.ReadOnlyEJBHomeImpl";
    private static final String READ_ONLY_EJB_LOCAL_HOME_IMPL = "com.sun.ejb.containers.ReadOnlyEJBLocalHomeImpl";
    private static final String READ_ONLY_EJB_HOME_INTERFACE = "com.sun.ejb.containers.ReadOnlyEJBHome";
    private static final String READ_ONLY_EJB_LOCAL_HOME_INTERFACE = "com.sun.ejb.containers.ReadOnlyEJBLocalHome";

    public String getGeneratedClass() {
        String pname = this.getPackageName(this.bean.getName());
        if (pname != null) {
            return pname + "." + this.homeImpl;
        }
        return this.homeImpl;
    }

    public static String getDefaultRemoteHomeImplClassName(EjbDescriptor desc) {
        return desc.getEjbImplClassName() + REMOTE_SUFFIX;
    }

    public HomeGenerator(DeploymentContext context, EjbDescriptor dd, boolean isLocal, Vector existingClassNames) throws GeneratorException {
        String homeName;
        this.dd = dd;
        this.isLocal = isLocal;
        ClassLoader cl = context.getClassLoader();
        if (isLocal) {
            homeName = dd.getLocalHomeClassName();
            this.ejbClassSymbol = MethodDescriptor.EJB_LOCALHOME;
        } else {
            homeName = dd.getHomeClassName();
            this.ejbClassSymbol = MethodDescriptor.EJB_HOME;
        }
        try {
            this.homeInterface = cl.loadClass(homeName);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidHome(localStrings.getLocalString("generator.invalid_home", "Could not find home class {0}", new Object[]{homeName}));
        }
        try {
            this.bean = cl.loadClass(dd.getEjbImplClassName());
        }
        catch (ClassNotFoundException ex) {
            _logger.log(Level.FINE, "ejb.classnotfound_exception", ex);
            InvalidBean ibe = new InvalidBean(localStrings.getLocalString("generator.bean_class_not_found", "Bean class {0} not found ", new Object[]{dd.getEjbImplClassName()}));
            ibe.initCause(ex);
            throw ibe;
        }
        if (!SessionBean.class.isAssignableFrom(this.bean) && !EntityBean.class.isAssignableFrom(this.bean)) {
            throw new InvalidBean(localStrings.getLocalString("generator.invalid_bean", "Bean {0} is neither {1} nor {2}.", new Object[]{dd.getName(), "an EntityBean", "a SessionBean"}));
        }
        this.factoryMethods = this.removeDups(this.homeInterface.getMethods());
        this.factoryMethods = this.removeEJBHomeMethods(this.factoryMethods);
        this.allbeanMethods = this.removeDups(this.bean.getMethods());
        String suffix = isLocal ? LOCAL_SUFFIX : REMOTE_SUFFIX;
        String homeClassName = this.getUniqueClassName(context, this.bean.getName(), suffix, existingClassNames);
        this.homeImpl = this.getBaseName(homeClassName);
        if (dd instanceof EjbEntityDescriptor && ((EjbEntityDescriptor)dd).getIASEjbExtraDescriptors().isIsReadOnlyBean()) {
            this.isReadOnlyBean = true;
        }
    }

    private Method[] removeEJBHomeMethods(Method[] methods) {
        ArrayList<Method> newArray = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (this.isEJBHomeMethod(methods[i])) continue;
            newArray.add(methods[i]);
        }
        Method[] newMethods = new Method[newArray.size()];
        return newArray.toArray(newMethods);
    }

    private boolean compare(Method factoryMethod, Method beanMethod) {
        Class<?>[] beanParamTypes;
        if (factoryMethod.getName().startsWith("create") && !beanMethod.getName().startsWith("ejbCreate")) {
            return false;
        }
        if (factoryMethod.getName().startsWith("find") && !beanMethod.getName().startsWith("ejbFind")) {
            return false;
        }
        Class<?>[] factoryParamTypes = factoryMethod.getParameterTypes();
        if (factoryParamTypes.length != (beanParamTypes = beanMethod.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < factoryParamTypes.length; ++i) {
            if (factoryParamTypes[i] == beanParamTypes[i]) continue;
            return false;
        }
        return true;
    }

    private Method getBeanMethod(Method factoryMethod) {
        for (int i = 0; i < this.allbeanMethods.length; ++i) {
            if (!this.isInitializeMethod(this.allbeanMethods[i]) || !this.compare(factoryMethod, this.allbeanMethods[i])) continue;
            return this.allbeanMethods[i];
        }
        return null;
    }

    private void printFactoryMethodImpl(IndentingWriter p, Method factoryMethod, int type, String methodVar) throws IOException {
        boolean isStatelessSession = false;
        boolean isEntity = false;
        boolean isReadOnlyBean = false;
        if (this.dd instanceof EjbSessionDescriptor) {
            if (((EjbSessionDescriptor)this.dd).isStateless()) {
                isStatelessSession = true;
            }
        } else if (this.dd instanceof EjbEntityDescriptor) {
            isEntity = true;
            if (((EjbEntityDescriptor)this.dd).getIASEjbExtraDescriptors().isIsReadOnlyBean()) {
                isReadOnlyBean = true;
            }
        }
        p.pln("");
        p.p("public ");
        p.p(this.printType(factoryMethod.getReturnType()) + " ");
        p.p(factoryMethod.getName() + "(");
        Class<?>[] params = factoryMethod.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                p.p(", ");
            }
            p.p(this.printType(params[i]) + " param" + i);
        }
        p.p(")");
        Class<?>[] exceptions = factoryMethod.getExceptionTypes();
        if (exceptions.length != 0) {
            p.p(" throws ");
        }
        for (int i = 0; i < exceptions.length; ++i) {
            if (i != 0) {
                p.p(", ");
            }
            p.p(exceptions[i].getName());
        }
        p.plnI(" {");
        String ejbObjectName = this.isLocal ? "com.sun.ejb.containers.EJBLocalObjectImpl" : "com.sun.ejb.containers.EJBObjectImpl";
        if (type == CREATE) {
            if (!isEntity) {
                p.pln(ejbObjectName + " ejbObject = (" + ejbObjectName + ") this.createEJB" + (this.isLocal ? "LocalObjectImpl();" : "ObjectImpl();"));
            }
        } else if (!this.isReturnTypeVoid(factoryMethod)) {
            String retType = this.printType(factoryMethod.getReturnType());
            p.p(retType + " ejbObject = ");
            if (this.isReturnTypePrimitive(factoryMethod)) {
                if (this.isReturnTypeBoolean(factoryMethod)) {
                    p.p("false");
                } else {
                    p.p("0");
                }
            } else {
                p.p("null");
            }
            p.pln(";");
        }
        if (!isStatelessSession) {
            String name;
            if (isReadOnlyBean && this.isCreateMethod(factoryMethod)) {
                p.pln("throw new javax.ejb.CreateException (\"Create method is not allowed for a Read-Only Bean\");");
                p.pOln("}");
                return;
            }
            if (isReadOnlyBean && this.isCreateMethod(factoryMethod)) {
                p.pln("throw new javax.ejb.CreateException (\"Remove method is not allowed for a Read-Only Bean\");");
                p.pOln("}");
                return;
            }
            p.pln("com.sun.ejb.Invocation i = new com.sun.ejb.Invocation();");
            p.pln("i.isHome = true;");
            if (this.isLocal) {
                p.pln("i.isLocal = true;");
                p.pln("i.transactionAttribute = com.sun.ejb.Container." + this.getTxAttribute(this.dd, factoryMethod) + ";");
                p.pln("i.securityPermissions = com.sun.ejb.Container." + this.getSecurityAttribute(this.dd, factoryMethod) + ";");
            }
            if (type == CREATE && !isEntity) {
                p.pln("i.ejbObject = ejbObject;");
            }
            p.pln("i.method = " + methodVar + ";");
            p.pln("try {");
            p.pln("\tObject[] objarr = new Object[" + params.length + "];");
            p.p("\n");
            for (int i = 0; i < params.length; ++i) {
                p.p("\t\tobjarr[" + i + "] = ");
                Class<?> clazz = params[i];
                p.p(this.marshallPrimitiveToObject(clazz, i));
            }
            p.pln("\t\ti.methodParams = objarr;");
            p.pln("\tthis.getContainer().preInvoke(i);");
            p.pln("\t" + this.bean.getName() + " ejb = (" + this.bean.getName() + ") i.ejb;");
            if (type == CREATE) {
                name = factoryMethod.getName().substring("create".length());
                p.pln("\t\tjava.lang.reflect.Method method = i.ejb.getClass().getMethod(\"ejbCreate" + name + "\", i.method.getParameterTypes());");
                if (isEntity) {
                    p.p("\tjava.lang.Object primaryKey = ");
                    p.p("\tcom.sun.enterprise.security.SecurityUtil.runMethod(method, i, ejb, objarr, this.getContainer());\n");
                } else {
                    p.p("\tcom.sun.enterprise.security.SecurityUtil.runMethod(method, i, ejb, objarr, this.getContainer());\n");
                }
                if (isEntity) {
                    p.pln("\t\tjava.lang.reflect.Method __method__postCreate = i.ejb.getClass().getMethod(\"ejbPostCreate" + name + "\", i.method.getParameterTypes());");
                    p.pln("\tthis.getContainer().postCreate(i, primaryKey);");
                    p.p("\tcom.sun.enterprise.security.SecurityUtil.runMethod(__method__postCreate, i, ejb, objarr, this.getContainer());\n");
                }
            } else if (type == FINDER) {
                name = factoryMethod.getName().substring("find".length());
                p.pln("\t\tjava.lang.reflect.Method __method__finder = i.ejb.getClass().getMethod(\"ejbFind" + name + "\", i.method.getParameterTypes());\n");
                p.pln("\tjava.lang.Object primaryKeys = null;");
                p.p("\tprimaryKeys = com.sun.enterprise.security.SecurityUtil.runMethod(__method__finder, i, ejb, objarr, this.getContainer());\n");
                p.pln("\tejbObject = (" + factoryMethod.getReturnType().getName() + ")this.getContainer().postFind(i, primaryKeys, null);");
            } else {
                name = factoryMethod.getName();
                p.p("\t");
                String upperCasedName = name.substring(0, 1).toUpperCase() + name.substring(1);
                p.p("\tjava.lang.reflect.Method __method__home = ");
                p.p("i.ejb.getClass().getMethod(\"ejbHome" + upperCasedName + "\", i.method.getParameterTypes());\n");
                if (!this.isReturnTypeVoid(factoryMethod)) {
                    p.p("java.lang.Object obj = ");
                    p.pln("com.sun.enterprise.security.SecurityUtil.runMethod(__method__home, i, ejb, objarr, this.getContainer());\n");
                    Class<?> clazz = factoryMethod.getReturnType();
                    p.p(this.marshallObjectToPrimitive(clazz, "obj", "ejbObject"));
                } else {
                    p.pln("com.sun.enterprise.security.SecurityUtil.runMethod(__method__home, i, ejb, objarr, this.getContainer());\n");
                }
            }
            p.pln("} catch(Throwable c) {");
            p.pln("\ti.exception = c;");
            p.pln("} finally {");
            p.pln("\tthis.getContainer().postInvoke(i);");
            p.pln("}");
            p.plnI("if (i.exception != null) {");
            p.pln("if(i.exception instanceof java.lang.RuntimeException) {");
            p.pln("\tthrow (java.lang.RuntimeException)i.exception; ");
            p.p("} ");
            if (!this.isLocal) {
                p.pln("else if (i.exception instanceof java.rmi.RemoteException) {");
                p.pln("\tthrow (java.rmi.RemoteException)i.exception; ");
                p.p("} ");
            }
            for (int i = 0; i < exceptions.length; ++i) {
                if (exceptions[i].getName().equals("java.rmi.RemoteException")) continue;
                p.pln("else if (i.exception instanceof " + exceptions[i].getName() + ") {");
                p.pln("\tthrow (" + exceptions[i].getName() + ")i.exception;");
                p.p("} ");
            }
            if (this.isLocal) {
                p.pln("else if (i.exception instanceof Exception) {");
                p.pln("\tthrow new javax.ejb.EJBException(\"Unknown exception\", (Exception)i.exception);");
                p.pln("}");
                p.pln("else {");
                p.pln("\tthrow new javax.ejb.EJBException(i.exception.getMessage());");
                p.pln("}");
            } else {
                p.pln("else {");
                p.pln("\tthrow new java.rmi.RemoteException(\"Unknown exception\", i.exception);");
                p.pln("}");
            }
            p.pOln("}");
        }
        if (type == CREATE) {
            if (isEntity) {
                p.pln("return (" + factoryMethod.getReturnType().getName() + ")" + "((" + ejbObjectName + ")i.ejbObject)" + (this.isLocal ? ";" : ".getStub();"));
            } else {
                p.pln("return (" + factoryMethod.getReturnType().getName() + ")ejbObject" + (this.isLocal ? ";" : ".getStub();"));
            }
        } else if (!this.isReturnTypeVoid(factoryMethod)) {
            p.pln("return ejbObject;");
        }
        p.pOln("}");
    }

    public void generate(OutputStream out) throws GeneratorException, IOException {
        IndentingWriter p = new IndentingWriter(new OutputStreamWriter(out));
        String packageName = this.getPackageName(this.bean.getName());
        if (packageName != null) {
            p.pln("package " + packageName + ";");
        }
        if (this.isReadOnlyBean) {
            p.plnI("public final class " + this.homeImpl + " extends " + (this.isLocal ? READ_ONLY_EJB_LOCAL_HOME_IMPL : READ_ONLY_EJB_HOME_IMPL) + " implements " + this.homeInterface.getName() + ", " + (this.isLocal ? READ_ONLY_EJB_LOCAL_HOME_INTERFACE : READ_ONLY_EJB_HOME_INTERFACE) + " {");
        } else {
            p.plnI("public final class " + this.homeImpl + " extends com.sun.ejb.containers." + (this.isLocal ? "EJBLocalHomeImpl" : "EJBHomeImpl") + " implements " + this.homeInterface.getName() + " {");
        }
        String[] methodVariables = this.printStaticMethodInit(p, this.homeInterface, this.factoryMethods);
        p.plnI("public " + this.homeImpl + "() " + (this.isLocal ? "" : "throws java.rmi.RemoteException ") + "{");
        p.pln("super();");
        p.pOln("}");
        for (int i = 0; i < this.factoryMethods.length; ++i) {
            if (this.isCreateMethod(this.factoryMethods[i])) {
                Method m = this.getBeanMethod(this.factoryMethods[i]);
                if (m == null) {
                    throw new MethodNotFound("Could not find bean method for factory method: " + this.factoryMethods[i]);
                }
                this.printFactoryMethodImpl(p, this.factoryMethods[i], CREATE, methodVariables[i]);
                continue;
            }
            if (this.isFinderMethod(this.factoryMethods[i])) {
                this.printFactoryMethodImpl(p, this.factoryMethods[i], FINDER, methodVariables[i]);
                continue;
            }
            this.printFactoryMethodImpl(p, this.factoryMethods[i], OTHER, methodVariables[i]);
        }
        p.pOln("}");
        p.close();
    }

    private boolean isCreateMethod(Method m) {
        return Modifier.isPublic(m.getModifiers()) && m.getName().startsWith("create");
    }

    private boolean isRemoveMethod(Method m) {
        return Modifier.isPublic(m.getModifiers()) && m.getName().startsWith("remove");
    }

    private boolean isFinderMethod(Method m) {
        return Modifier.isPublic(m.getModifiers()) && m.getName().startsWith("find");
    }

    private boolean isInitializeMethod(Method m) {
        return Modifier.isPublic(m.getModifiers()) && (m.getName().startsWith("ejbCreate") || m.getName().startsWith("ejbFind"));
    }

    private String getPrimitiveWrapper(Class pclass) {
        if (pclass == Boolean.TYPE) {
            return "Boolean";
        }
        if (pclass == Byte.TYPE) {
            return "Byte";
        }
        if (pclass == Character.TYPE) {
            return "Character";
        }
        if (pclass == Short.TYPE) {
            return "Short";
        }
        if (pclass == Integer.TYPE) {
            return "Integer";
        }
        if (pclass == Long.TYPE) {
            return "Long";
        }
        if (pclass == Float.TYPE) {
            return "Float";
        }
        if (pclass == Double.TYPE) {
            return "Double";
        }
        throw new RuntimeException("Bad primitive class");
    }

    private boolean isEJBHomeMethod(Method methodToCheck) {
        Class ejbHomeClz = this.isLocal ? EJBLocalHome.class : EJBHome.class;
        return this.isEJBIntfMethod(ejbHomeClz, methodToCheck);
    }

    private boolean isReturnTypeVoid(Method m) {
        String name = m.getReturnType().getName();
        return name.equals("void");
    }

    private boolean isReturnTypeBoolean(Method m) {
        String name = m.getReturnType().getName();
        return name.equals("boolean");
    }

    private boolean isReturnTypePrimitive(Method m) {
        return m.getReturnType().isPrimitive();
    }

    private String marshallPrimitiveToObject(Class clazz, int i) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return " new java.lang.Integer(param" + i + ");\n";
            }
            if (clazz == Boolean.TYPE) {
                return " java.lang.Boolean.valueOf(param" + i + ");\n";
            }
            if (clazz == Byte.TYPE) {
                return " new java.lang.Byte(param" + i + ");\n";
            }
            if (clazz == Short.TYPE) {
                return " new java.lang.Short(param" + i + ");\n";
            }
            if (clazz == Long.TYPE) {
                return " new java.lang.Long(param" + i + ");\n";
            }
            if (clazz == Float.TYPE) {
                return " new java.lang.Float(param" + i + ");\n";
            }
            if (clazz == Double.TYPE) {
                return " new java.lang.Double(param" + i + ");\n";
            }
            if (clazz == Character.TYPE) {
                return " new java.lang.Character(param" + i + ");\n";
            }
        }
        return "(java.lang.Object)param" + i + ";\n";
    }

    private String marshallObjectToPrimitive(Class clazz, String obj, String retVal) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return retVal + "= ((java.lang.Integer)" + obj + ").intValue();\n";
            }
            if (clazz == Boolean.TYPE) {
                return retVal + " = ((java.lang.Boolean)" + obj + ").booleanValue();\n";
            }
            if (clazz == Byte.TYPE) {
                return retVal + " = ((java.lang.Byte)" + obj + ").byteValue();\n";
            }
            if (clazz == Short.TYPE) {
                return retVal + " = ((java.lang.Short)" + obj + ").shortValue();\n";
            }
            if (clazz == Long.TYPE) {
                return retVal + " = ((java.lang.Long)" + obj + ").longValue();\n";
            }
            if (clazz == Float.TYPE) {
                return retVal + " = ((java.lang.Float)" + obj + ").floatValue();\n";
            }
            if (clazz == Double.TYPE) {
                return retVal + " = ((java.lang.Double)" + obj + ").doubleValue();\n";
            }
            if (clazz == Character.TYPE) {
                return retVal + " = ((java.lang.Character)" + obj + ").charValue();\n";
            }
        }
        return retVal + "= (" + this.printType(clazz) + ") " + obj + ";\n";
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
        localStrings = new LocalStringManagerImpl(HomeGenerator.class);
        LOCAL_SUFFIX = "_LocalHomeImpl";
        REMOTE_SUFFIX = "_RemoteHomeImpl";
        CREATE = 0;
        FINDER = 1;
        OTHER = 2;
    }
}

