/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.sun.ejb.containers.util.cache.BaseCache;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LruCache
extends BaseCache {
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    protected String cacheName;
    public static final long NO_TIMEOUT = -1L;
    protected LruCacheItem head;
    protected LruCacheItem tail;
    protected int trimCount;
    protected int listSize;
    protected long timeout = -1L;

    public LruCache() {
    }

    public LruCache(long timeout) {
        this.timeout = timeout;
    }

    protected BaseCache.CacheItem createItem(int hashCode, Object key, Object value, int size) {
        return new LruCacheItem(hashCode, key, value, size);
    }

    protected BaseCache.CacheItem trimLru(long currentTime) {
        LruCacheItem trimItem = this.tail;
        if (this.tail != this.head) {
            this.tail = trimItem.lPrev;
            if (this.tail == null) {
                _logger.log(Level.WARNING, "[" + this.cacheName + "]: trimLru(), resetting head and tail");
                this.head = null;
                this.tail = null;
            } else {
                this.tail.lNext = null;
            }
        } else {
            this.head = null;
            this.tail = null;
        }
        if (trimItem != null) {
            trimItem.isTrimmed = true;
            trimItem.lPrev = null;
            ++this.trimCount;
            --this.listSize;
        }
        return trimItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem item) {
        BaseCache.CacheItem overflow = null;
        LruCacheItem lc = (LruCacheItem)item;
        lc.lastAccessed = System.currentTimeMillis();
        LruCache lruCache = this;
        synchronized (lruCache) {
            if (this.head != null) {
                this.head.lPrev = lc;
                lc.lNext = this.head;
                lc.lPrev = null;
                this.head = lc;
            } else {
                this.head = this.tail = lc;
                lc.lNext = null;
                lc.lPrev = null;
            }
            ++this.listSize;
            if (this.isThresholdReached()) {
                overflow = this.trimLru(lc.lastAccessed);
            }
        }
        return overflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemAccessed(BaseCache.CacheItem item) {
        LruCacheItem lc = (LruCacheItem)item;
        LruCache lruCache = this;
        synchronized (lruCache) {
            if (lc.isTrimmed) {
                return;
            }
            lc.lastAccessed = System.currentTimeMillis();
            LruCacheItem prev = lc.lPrev;
            LruCacheItem next = lc.lNext;
            if (prev != null) {
                lc.lPrev = null;
                lc.lNext = this.head;
                this.head.lPrev = lc;
                this.head = lc;
                prev.lNext = next;
                if (next != null) {
                    next.lPrev = prev;
                } else {
                    this.tail = prev;
                }
            }
        }
    }

    protected void itemRefreshed(BaseCache.CacheItem item, int oldSize) {
        this.itemAccessed(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemRemoved(BaseCache.CacheItem item) {
        LruCacheItem l = (LruCacheItem)item;
        LruCache lruCache = this;
        synchronized (lruCache) {
            LruCacheItem prev = l.lPrev;
            LruCacheItem next = l.lNext;
            if (l.isTrimmed) {
                return;
            }
            if (prev != null) {
                prev.lNext = next;
            } else {
                this.head = next;
            }
            if (next != null) {
                next.lPrev = prev;
            } else {
                this.tail = prev;
            }
            l.lNext = null;
            l.lPrev = null;
            --this.listSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimExpiredEntries(int maxCount) {
        long currentTime = System.currentTimeMillis();
        ArrayList<LruCacheItem> list = new ArrayList<LruCacheItem>();
        LruCache lruCache = this;
        synchronized (lruCache) {
            int count;
            LruCacheItem item = this.tail;
            for (count = 0; item != null && count < maxCount && this.timeout != -1L && item.lastAccessed + this.timeout <= currentTime; ++count) {
                item.isTrimmed = true;
                list.add(item);
                item = item.lPrev;
            }
            if (item != this.tail) {
                if (item != null) {
                    item.lNext = null;
                } else {
                    this.head = null;
                }
                this.tail = item;
            }
            this.listSize -= count;
            this.trimCount += count;
        }
        for (int index = list.size() - 1; index >= 0; --index) {
            this.trimItem((LruCacheItem)list.get(index));
        }
    }

    public Object getStatByName(String key) {
        Object stat = super.getStatByName(key);
        if (stat == null && key != null) {
            if (key.equals("cache.LruCache.stat_lruListLength")) {
                stat = new Integer(this.listSize);
            } else if (key.equals("cache.LruCache.stat_trimCount")) {
                stat = new Integer(this.trimCount);
            }
        }
        return stat;
    }

    public Map getStats() {
        Map stats = super.getStats();
        stats.put("cache.LruCache.stat_lruListLength", new Integer(this.listSize));
        stats.put("cache.LruCache.stat_trimCount", new Integer(this.trimCount));
        return stats;
    }

    public void setCacheName(String name) {
        this.cacheName = name;
    }

    protected static class LruCacheItem
    extends BaseCache.CacheItem {
        protected LruCacheItem lNext;
        protected LruCacheItem lPrev;
        protected boolean isTrimmed;
        protected long lastAccessed;

        protected LruCacheItem(int hashCode, Object key, Object value, int size) {
            super(hashCode, key, value, size);
        }
    }
}

