/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common.domains.registry;

import com.sun.enterprise.admin.common.domains.registry.DomainEntry;
import com.sun.enterprise.admin.common.domains.registry.DomainRegistryException;
import com.sun.enterprise.admin.common.domains.registry.DomainRegistryI;
import com.sun.enterprise.admin.common.domains.registry.LockingStore;
import com.sun.enterprise.admin.common.domains.registry.LockingStoreFactory;
import com.sun.enterprise.admin.common.domains.registry.Registry;
import com.sun.enterprise.admin.common.domains.registry.TimeoutException;
import java.io.IOException;
import java.util.Iterator;

public class DomainRegistry
implements DomainRegistryI {
    private Registry registry;
    private LockingStore store;
    private static DomainRegistry instance = null;
    private long lastModified = 0L;

    public static synchronized DomainRegistry newInstance() throws DomainRegistryException {
        if (instance == null) {
            instance = new DomainRegistry();
            instance.init();
        }
        return instance;
    }

    public synchronized void registerDomain(DomainEntry de) throws DomainRegistryException {
        this.prepareForUpdate();
        try {
            this.registry.registerDomain(de);
        }
        catch (DomainRegistryException e) {
            this.store.unlock();
            throw e;
        }
        this.saveRegistry();
    }

    public void unregisterDomain(String domain_name) throws DomainRegistryException {
        this.prepareForUpdate();
        try {
            this.registry.unregisterDomain(domain_name);
        }
        catch (DomainRegistryException e) {
            this.store.unlock();
            throw e;
        }
        this.saveRegistry();
    }

    public void unregisterDomain(DomainEntry de) throws DomainRegistryException {
        this.unregisterDomain(de.getName());
    }

    public void reregisterDomain(DomainEntry de) throws DomainRegistryException {
        this.prepareForUpdate();
        try {
            this.registry.reregisterDomain(de);
        }
        catch (DomainRegistryException e) {
            this.store.unlock();
            throw e;
        }
        this.saveRegistry();
    }

    public boolean containsDomain(DomainEntry de) throws DomainRegistryException {
        this.refreshRegistry();
        return this.registry.containsDomain(de);
    }

    public DomainEntry getDomain(String name) throws DomainRegistryException {
        this.refreshRegistry();
        return this.registry.getDomain(name);
    }

    public Iterator iterator() throws DomainRegistryException {
        this.refreshRegistry();
        return this.registry.iterator();
    }

    public int size() throws DomainRegistryException {
        this.refreshRegistry();
        return this.registry.size();
    }

    void reset() throws IOException {
        this.store.unlock();
        this.registry = null;
        this.store = null;
        instance = null;
    }

    private void refreshRegistry() throws DomainRegistryException {
        if (this.lastModified < this.store.lastModified()) {
            try {
                this.registry = this.getRegistryFromStore();
            }
            catch (Exception te) {
                throw new DomainRegistryException("problem reading from store", te);
            }
        }
    }

    private Registry getRegistryFromStore() throws IOException, TimeoutException, ClassNotFoundException {
        Registry br = (Registry)this.store.readObject();
        return br != null ? br : new Registry();
    }

    private void prepareForUpdate() throws DomainRegistryException {
        try {
            this.store.lock();
        }
        catch (Exception e) {
            throw new DomainRegistryException("problem locking store ", e);
        }
        this.refreshRegistry();
    }

    private void saveRegistry() throws DomainRegistryException {
        try {
            this.store.writeObject(this.registry);
            this.store.unlock();
            this.lastModified = this.store.lastModified();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DomainRegistryException("couldn't save registry", e);
        }
    }

    private void init() throws DomainRegistryException {
        try {
            this.store = LockingStoreFactory.getInstance();
            this.registry = this.getRegistryFromStore();
        }
        catch (Exception e) {
            throw new DomainRegistryException("couldn't initialize registry. Error message: " + e.getMessage());
        }
    }

    private DomainRegistry() {
    }
}

