/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.JMSDestinationInfo;
import com.sun.enterprise.admin.common.exception.JMSAdminException;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.system.MQJMXConnectorInfo;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.messaging.jms.management.server.DestinationType;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class JMSDestination {
    private static final boolean USE_JMX = !Boolean.getBoolean("DONT_USE_MQ_JMX");
    private static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager localStrings = StringManager.getManager(JMSDestination.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createJMSDestination(String destName, String destType, Properties destProps, String tgtName) throws JMSAdminException {
        sLogger.log(Level.FINE, "createJMSDestination ...");
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(tgtName);
        try {
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Config");
            String[] signature = null;
            AttributeList destAttrs = null;
            Object[] params = null;
            if (destProps != null) {
                destAttrs = this.convertProp2Attrs(destProps);
            }
            this.setAppserverDefaults(destAttrs, mqInfo);
            if (destType.equalsIgnoreCase("topic")) {
                destType = "t";
            } else if (destType.equalsIgnoreCase("queue")) {
                destType = "q";
            }
            signature = new String[]{"java.lang.String", "java.lang.String", "javax.management.AttributeList"};
            params = new Object[]{destType, destName, destAttrs};
            mbsc.invoke(on, "create", params, signature);
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_creating_jms_dest");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteJMSDestination(String destName, String destType, String tgtName) throws JMSAdminException {
        sLogger.log(Level.FINE, "deleteJMSDestination ...");
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(tgtName);
        try {
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Config");
            String[] signature = null;
            Object[] params = null;
            signature = new String[]{"java.lang.String", "java.lang.String"};
            if (destType.equalsIgnoreCase("topic")) {
                destType = "t";
            } else if (destType.equalsIgnoreCase("queue")) {
                destType = "q";
            }
            params = new Object[]{destType, destName};
            mbsc.invoke(on, "destroy", params, signature);
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_deleting_jms_dest");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSDestinationInfo[] listJMSDestinations(String tgtName, String destType) throws JMSAdminException {
        sLogger.log(Level.FINE, "listJMSDestination ...");
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(tgtName);
        try {
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            ObjectName on = new ObjectName("com.sun.messaging.jms.server:type=DestinationManager,subtype=Config");
            String[] signature = null;
            Object[] params = null;
            ObjectName[] dests = (ObjectName[])mbsc.invoke(on, "getDestinations", params, signature);
            if (dests != null && dests.length > 0) {
                ArrayList<JMSDestinationInfo> jmsdi = new ArrayList<JMSDestinationInfo>();
                for (int i = 0; i < dests.length; ++i) {
                    on = dests[i];
                    String jdiType = DestinationType.toStringLabel((String)on.getKeyProperty("desttype"));
                    String jdiName = on.getKeyProperty("name");
                    if (jdiName != null && jdiName.length() > 1) {
                        if (jdiName.indexOf(34) == 0) {
                            jdiName = jdiName.substring(1);
                        }
                        if (jdiName.lastIndexOf(34) == jdiName.length() - 1) {
                            jdiName = jdiName.substring(0, jdiName.lastIndexOf(34));
                        }
                    }
                    JMSDestinationInfo jdi = new JMSDestinationInfo(jdiName, jdiType);
                    if (destType == null) {
                        jmsdi.add(jdi);
                        continue;
                    }
                    if (!destType.equals("topic") && !destType.equals("queue") || !jdiType.equalsIgnoreCase(destType)) continue;
                    jmsdi.add(jdi);
                }
                JMSDestinationInfo[] jMSDestinationInfoArray = jmsdi.toArray(new JMSDestinationInfo[0]);
                return jMSDestinationInfoArray;
            }
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_listing_jms_dest");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String JMSPing(String tgtName) throws JMSAdminException {
        sLogger.log(Level.FINE, "JMSPing ...");
        MQJMXConnectorInfo mqInfo = null;
        try {
            MQJMXConnectorInfo[] cInfo = ConnectorRuntime.getRuntime().getMQJMXConnectorInfo(tgtName);
            if (cInfo == null || cInfo.length < 1) {
                throw new JMSAdminException(localStrings.getString("admin.mbeans.rmb.error_obtaining_jms"));
            }
            int k = -1;
            for (int i = 0; i < cInfo.length; ++i) {
                if (!tgtName.equals(cInfo[i].getASInstanceName())) continue;
                k = i;
                break;
            }
            if (k == -1) {
                throw new JMSAdminException(localStrings.getString("admin.mbeans.rmb.invalid_server_instance", tgtName));
            }
            mqInfo = cInfo[k];
            MBeanServerConnection mbsc = cInfo[k].getMQMBeanServerConnection();
            mbsc.getMBeanCount();
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_pinging_jms");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        return "RUNNING";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeJMSDestination(String destName, String destType, String tgtName) throws JMSAdminException {
        sLogger.log(Level.FINE, "purgeJMSDestination ...");
        MQJMXConnectorInfo mqInfo = this.getMQJMXConnectorInfo(tgtName);
        try {
            MBeanServerConnection mbsc = mqInfo.getMQMBeanServerConnection();
            if (destType.equalsIgnoreCase("topic")) {
                destType = "t";
            } else if (destType.equalsIgnoreCase("queue")) {
                destType = "q";
            }
            ObjectName on = MQObjectName.createDestinationConfig((String)destType, (String)destName);
            String[] signature = null;
            Object[] params = null;
            mbsc.invoke(on, "purge", params, signature);
        }
        catch (Exception e) {
            this.logAndHandleException(e, "admin.mbeans.rmb.error_purging_jms_dest");
        }
        finally {
            try {
                if (mqInfo != null) {
                    mqInfo.closeMQMBeanServerConnection();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private MQJMXConnectorInfo getMQJMXConnectorInfo(String tgtName) throws JMSAdminException {
        sLogger.log(Level.FINE, "getMQJMXConnectorInfo for " + tgtName);
        MQJMXConnectorInfo mcInfo = null;
        try {
            MQJMXConnectorInfo[] cInfo = ConnectorRuntime.getRuntime().getMQJMXConnectorInfo(tgtName);
            if (cInfo == null || cInfo.length < 1) {
                throw new JMSAdminException(localStrings.getString("admin.mbeans.rmb.error_obtaining_jms"));
            }
            mcInfo = cInfo[0];
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return mcInfo;
    }

    private void setAppserverDefaults(AttributeList destAttrs, MQJMXConnectorInfo info) {
        if (destAttrs == null) {
            destAttrs = new AttributeList();
        }
        if (info.getBrokerType().equalsIgnoreCase("LOCAL")) {
            String localDelivery = "LocalDeliveryPreferred";
            boolean notPresent = true;
            for (Object obj : destAttrs) {
                Attribute attrib = (Attribute)obj;
                if (!attrib.getName().equals(localDelivery)) continue;
                notPresent = false;
            }
            if (notPresent) {
                Attribute attrib = new Attribute(localDelivery, new Boolean("true"));
                destAttrs.add(attrib);
            }
        }
    }

    private AttributeList convertProp2Attrs(Properties destProps) {
        AttributeList destAttrs = new AttributeList();
        String propName = null;
        String propValue = null;
        Enumeration<?> e = destProps.propertyNames();
        while (e.hasMoreElements()) {
            boolean b;
            propName = (String)e.nextElement();
            if (propName.equals("AutoCreateQueueMaxNumActiveConsumers")) {
                destAttrs.add(new Attribute("AutoCreateQueueMaxNumActiveConsumers", new Integer(destProps.getProperty("AutoCreateQueueMaxNumActiveConsumers"))));
                continue;
            }
            if (propName.equals("maxNumActiveConsumers")) {
                destAttrs.add(new Attribute("MaxNumActiveConsumers", new Integer(destProps.getProperty("maxNumActiveConsumers"))));
                continue;
            }
            if (propName.equals("MaxNumActiveConsumers")) {
                destAttrs.add(new Attribute("MaxNumActiveConsumers", new Integer(destProps.getProperty("MaxNumActiveConsumers"))));
                continue;
            }
            if (propName.equals("AutoCreateQueueMaxNumBackupConsumers")) {
                destAttrs.add(new Attribute("AutoCreateQueueMaxNumBackupConsumers", new Integer(destProps.getProperty("AutoCreateQueueMaxNumBackupConsumers"))));
                continue;
            }
            if (propName.equals("AutoCreateQueues")) {
                b = false;
                propValue = destProps.getProperty("AutoCreateQueues");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("AutoCreateQueues", new Boolean(b)));
                continue;
            }
            if (propName.equals("AutoCreateTopics")) {
                b = false;
                propValue = destProps.getProperty("AutoCreateTopics");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("AutoCreateTopics", new Boolean(b)));
                continue;
            }
            if (propName.equals("DMQTruncateBody")) {
                b = false;
                propValue = destProps.getProperty("DMQTruncateBody");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("DMQTruncateBody", new Boolean(b)));
                continue;
            }
            if (propName.equals("LogDeadMsgs")) {
                b = false;
                propValue = destProps.getProperty("LogDeadMsgs");
                if (propValue.equalsIgnoreCase("true")) {
                    b = true;
                }
                destAttrs.add(new Attribute("LogDeadMsgs", new Boolean(b)));
                continue;
            }
            if (propName.equals("MaxBytesPerMsg")) {
                destAttrs.add(new Attribute("MaxBytesPerMsg", new Long(destProps.getProperty("MaxBytesPerMsg"))));
                continue;
            }
            if (propName.equals("MaxNumMsgs")) {
                destAttrs.add(new Attribute("MaxNumMsgs", new Long(destProps.getProperty("MaxNumMsgs"))));
                continue;
            }
            if (propName.equals("MaxTotalMsgBytes")) {
                destAttrs.add(new Attribute("MaxTotalMsgBytes", new Long(destProps.getProperty("MaxTotalMsgBytes"))));
                continue;
            }
            if (!propName.equals("NumDestinations")) continue;
            destAttrs.add(new Attribute("NumDestinations", new Integer(destProps.getProperty("NumDestinations"))));
        }
        return destAttrs;
    }

    private void logAndHandleException(Exception e, String errorMsg) throws JMSAdminException {
        StringWriter s = new StringWriter();
        e.getCause().printStackTrace(new PrintWriter(s));
        sLogger.log(Level.WARNING, s.toString());
        JMSAdminException je = new JMSAdminException(localStrings.getString(errorMsg));
        this.handleException(je);
    }

    private void handleException(Exception e) throws JMSAdminException {
        if (e instanceof JMSAdminException) {
            throw (JMSAdminException)e;
        }
        String msg = e.getMessage();
        JMSAdminException jae = msg == null ? new JMSAdminException() : new JMSAdminException(msg);
        throw jae;
    }

    public static boolean useJMX(Target target) {
        return USE_JMX;
    }
}

