/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.common.exception.AFRuntimeException;
import com.sun.enterprise.admin.config.BaseConfigMBean;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;

public class ModuleMonitoringLevelsMBean
extends BaseConfigMBean {
    public static final String CONNECTOR_SERVICE_ATTR_NAME = "connector-service";
    public static final String JMS_SERVICE_ATTR_NAME = "jms-service";
    public static final String CONNECTOR_CONNPOOL_ATTR_NAME = "connector-connection-pool";
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public void setAttribute(Attribute attr) {
        try {
            super.setAttribute(attr);
            String attrName = attr.getName();
            AttributeList otherAttrs = new AttributeList();
            sLogger.log(Level.FINE, "modulemonitoringlevelsmbean.attribute_name", attrName);
            if (attrName.equals(CONNECTOR_SERVICE_ATTR_NAME)) {
                otherAttrs.add(new Attribute(JMS_SERVICE_ATTR_NAME, attr.getValue()));
                otherAttrs.add(new Attribute(CONNECTOR_CONNPOOL_ATTR_NAME, attr.getValue()));
            } else if (attrName.equals(JMS_SERVICE_ATTR_NAME)) {
                otherAttrs.add(new Attribute(CONNECTOR_CONNPOOL_ATTR_NAME, attr.getValue()));
                otherAttrs.add(new Attribute(CONNECTOR_SERVICE_ATTR_NAME, attr.getValue()));
            } else if (attrName.equals(CONNECTOR_CONNPOOL_ATTR_NAME)) {
                otherAttrs.add(new Attribute(CONNECTOR_SERVICE_ATTR_NAME, attr.getValue()));
                otherAttrs.add(new Attribute(JMS_SERVICE_ATTR_NAME, attr.getValue()));
            }
            super.setAttributes(otherAttrs);
        }
        catch (AFRuntimeException afe) {
            throw afe;
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "modulemonitoringlevelsmbean.set_failed");
            sLogger.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    public AttributeList setAttributes(AttributeList attrs) {
        AttributeList attrList = new AttributeList();
        Iterator it = attrs.iterator();
        Attribute attr = null;
        while (it.hasNext()) {
            try {
                attr = (Attribute)it.next();
                this.setAttribute(attr);
            }
            catch (AFRuntimeException afe) {
                throw afe;
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "modulemonitoringlevelsmbean.set_failed");
                sLogger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            attrList.add(attr);
        }
        return attrList;
    }
}

