/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.custom;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.mbeans.custom.CMBStrings;
import com.sun.enterprise.admin.mbeans.custom.CustomMBeanConstants;
import com.sun.enterprise.admin.mbeans.custom.CustomMBeanException;
import com.sun.enterprise.admin.mbeans.custom.CustomMBeanOperationsMBean;
import com.sun.enterprise.admin.mbeans.custom.MBeanValidator;
import com.sun.enterprise.admin.mbeans.custom.ObjectNameSelectionAlgorithm;
import com.sun.enterprise.admin.mbeans.custom.loading.CustomMBeanRegistrationImpl;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicCustomMBeanOperations
implements CustomMBeanOperationsMBean {
    protected final ConfigContext acc = MBeanRegistryFactory.getAdminContext().getAdminConfigContext();

    @Override
    public String createMBean(String target, String className) throws CustomMBeanException {
        Map<String, String> params = CustomMBeanConstants.unmodifiableMap("impl-class-name", className);
        Map<String, String> attributes = Collections.emptyMap();
        return this.createMBean(target, params, attributes);
    }

    @Override
    public String createMBean(String target, Map<String, String> params) throws CustomMBeanException {
        Map<String, String> attributes = Collections.emptyMap();
        return this.createMBean(target, params, attributes);
    }

    @Override
    public String createMBean(String target, Map<String, String> params, Map<String, String> attributes) throws CustomMBeanException {
        if (params == null || attributes == null) {
            throw new IllegalArgumentException(CMBStrings.get("InternalError", "null argument"));
        }
        Target t = null;
        try {
            t = TargetBuilder.INSTANCE.createTarget(target, this.acc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.createMBeanDefinitionAddingReferenceToServer(t.getName(), params, attributes);
    }

    @Override
    public void createMBeanRef(String target, String ref) throws CustomMBeanException {
        throw new UnsupportedOperationException(CMBStrings.get("InternalError", "Not to be called on PE"));
    }

    @Override
    public String deleteMBean(String target, String name) throws CustomMBeanException {
        if (name == null) {
            throw new IllegalArgumentException(CMBStrings.get("InternalError", "null argument"));
        }
        Target t = null;
        try {
            t = TargetBuilder.INSTANCE.createTarget(target, this.acc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.deleteMBeanDefinitionRemovingReferenceFromDomain(t.getName(), name);
    }

    @Override
    public void deleteMBeanRef(String target, String ref) throws CustomMBeanException {
        throw new UnsupportedOperationException(CMBStrings.get("InternalError", "Not to be called on PE"));
    }

    @Override
    public MBeanInfo getMBeanInfo(String classname) throws CustomMBeanException {
        try {
            String oname = "user:getMBeanInfo=" + System.nanoTime();
            String name = "getMBeanInfo" + System.nanoTime();
            Mbean mbean = new Mbean();
            mbean.setImplClassName(classname);
            mbean.setName(name);
            mbean.setObjectName(oname);
            mbean.setEnabled(true);
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            CustomMBeanRegistrationImpl cmr = new CustomMBeanRegistrationImpl(mbs);
            cmr.registerMBean(mbean);
            ObjectName ron = CustomMBeanRegistrationImpl.getCascadingAwareObjectName(mbean);
            MBeanInfo info = mbs.getMBeanInfo(ron);
            mbs.unregisterMBean(ron);
            return info;
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
    }

    protected String createMBeanDefinitionAddingReferenceToServer(String s, Map<String, String> params, Map<String, String> attributes) throws CustomMBeanException {
        try {
            Mbean mbean = this.createMBeanDefinitionInDomain(params, attributes);
            ObjectName onPostReg = new ObjectName(mbean.getObjectName());
            if (this.onExists(s, onPostReg)) {
                ServerBeansFactory.removeMbeanDefinition(this.acc, mbean.getName());
                throw new CustomMBeanException(CMBStrings.get("AlreadyExists", onPostReg.toString()));
            }
            ServerBeansFactory.addMbeanReference(this.acc, mbean.getName(), s);
            return mbean.getName();
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
    }

    protected Mbean createMBeanDefinitionInDomain(Map<String, String> params, Map<String, String> attributes) {
        Map<String, String> mm = this.checkAndModifyParamsForName(params);
        String name = mm.get("name");
        if (this.definitionExists(name)) {
            throw new CustomMBeanException(CMBStrings.get("AlreadyExists", name));
        }
        ObjectName onPostReg = this.selectObjectName(mm, attributes);
        if (!"user".equals(onPostReg.getDomain())) {
            throw new IllegalArgumentException(CMBStrings.get("BadDomainName", onPostReg.getDomain(), "user"));
        }
        mm.put("object-name", onPostReg.toString());
        Mbean mbean = MBeanValidator.toMbean(mm, attributes, true);
        try {
            ServerBeansFactory.addMbeanDefinition(this.acc, mbean);
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
        return mbean;
    }

    protected Map<String, String> checkAndModifyParamsForName(Map<String, String> params) throws CustomMBeanException {
        this.checkParams(params);
        Map<String, String> paramsWithNameKey = this.putNameIfAbsent(params);
        String name = paramsWithNameKey.get("name");
        return paramsWithNameKey;
    }

    protected ObjectName selectObjectName(Map<String, String> mm, Map<String, String> attributes) throws CustomMBeanException {
        ObjectName cascadedON;
        ObjectName onPreReg = ObjectNameSelectionAlgorithm.select(mm);
        MBeanValidator mv = new MBeanValidator();
        ObjectName onPostReg = mv.registerTestMBean(this.createTestMap(Collections.unmodifiableMap(mm), onPreReg), attributes);
        String className = mm.get("impl-class-name");
        boolean selfReg = ObjectNameSelectionAlgorithm.implementsMBeanRegistrationInterface(className);
        if (onPostReg != null && !onPostReg.equals(cascadedON = CustomMBeanRegistrationImpl.getCascadingAwareObjectName(onPreReg)) && !selfReg) {
            throw new CustomMBeanException(CMBStrings.get("ObjectNameMismatch", onPreReg, CustomMBeanRegistrationImpl.getCascadingUnawareObjectName(onPostReg)));
        }
        try {
            mv.unregisterTestMBean(onPostReg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ObjectName onInConfig = CustomMBeanRegistrationImpl.getCascadingUnawareObjectName(onPostReg);
        return onInConfig;
    }

    protected String deleteMBeanDefinitionRemovingReferenceFromDomain(String s, String name) throws RuntimeException {
        boolean refd;
        try {
            refd = ServerBeansFactory.isReferencedMBean(this.acc, s, name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!refd) {
            throw new RuntimeException(CMBStrings.get("RefsNotFound", s, name));
        }
        this.removeMBeanDefinitionAndReferenceFromConfigTree(s, name);
        return name;
    }

    protected Map<String, String> putNameIfAbsent(Map<String, String> m) {
        HashMap<String, String> nm = new HashMap<String, String>(m);
        String c = (String)nm.get("impl-class-name");
        assert (c != null);
        if (!nm.containsKey("name")) {
            nm.put("name", c);
        }
        return nm;
    }

    protected void checkParams(Map<String, String> params) throws IllegalArgumentException {
        if (!params.containsKey("impl-class-name")) {
            throw new IllegalArgumentException(CMBStrings.get("NoImplClass"));
        }
        this.checkValidIfPresent(params);
        this.checkValidObjectNameIfPresent(params);
    }

    protected boolean definitionExists(String name) throws CustomMBeanException {
        boolean exists = false;
        try {
            List<Mbean> mbeans = ServerBeansFactory.getAllMBeanDefinitions(this.acc);
            for (Mbean m : mbeans) {
                if (!m.getName().equals(name)) continue;
                exists = true;
                break;
            }
            return exists;
        }
        catch (Exception e) {
            throw new CustomMBeanException(e);
        }
    }

    protected boolean onExists(String server, ObjectName on) throws RuntimeException {
        try {
            boolean exists = false;
            List<Mbean> mbeans = ServerBeansFactory.getReferencedMBeans(this.acc, server);
            for (Mbean m : mbeans) {
                String onsFromConfig = m.getObjectName();
                ObjectName onFromConfig = new ObjectName(onsFromConfig);
                if (!onFromConfig.equals(on)) continue;
                exists = true;
                break;
            }
            return exists;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkValidIfPresent(Map<String, String> params) throws IllegalArgumentException {
        String nameKey = "name";
        String name = params.get("name");
        String cKey = "impl-class-name";
        String cVal = params.get("impl-class-name");
        String onKey = "object-name";
        String onVal = params.get("object-name");
        if (params.containsKey("name") && name == null) {
            throw new IllegalArgumentException(CMBStrings.get("MapHasNullParam", "Name"));
        }
        if (params.containsKey("impl-class-name") && cVal == null) {
            throw new IllegalArgumentException(CMBStrings.get("MapHasNullParam", "ClassName"));
        }
        if (params.containsKey("object-name") && onVal == null) {
            throw new IllegalArgumentException(CMBStrings.get("MapHasNullParam", "ObjectName"));
        }
    }

    private void checkValidObjectNameIfPresent(Map<String, String> params) throws IllegalArgumentException {
        String onKey = "object-name";
        String onVal = params.get("object-name");
        boolean onSpecified = params.containsKey("object-name") && onVal != null;
        ObjectName on = null;
        if (onSpecified) {
            try {
                on = new ObjectName(onVal);
            }
            catch (MalformedObjectNameException me) {
                throw new IllegalArgumentException(me);
            }
            if (on.isPattern()) {
                throw new IllegalArgumentException(CMBStrings.get("ObjectNamePattern"));
            }
            String d = on.getDomain();
            if (!"user".equals(d)) {
                throw new IllegalArgumentException(CMBStrings.get("BadDomainName", d, "user"));
            }
            if (on.getKeyProperty("server") != null) {
                throw new IllegalArgumentException(CMBStrings.get("ObjectNameReserved", on.toString(), "server"));
            }
        }
    }

    private void removeMBeanDefinitionAndReferenceFromConfigTree(String server, String ref) throws RuntimeException {
        try {
            ServerBeansFactory.removeMbeanReference(this.acc, ref, server);
            ServerBeansFactory.removeMbeanDefinition(this.acc, ref);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> createTestMap(Map<String, String> params, ObjectName on) {
        HashMap<String, String> nm = new HashMap<String, String>(params);
        nm.put("object-name", on.toString());
        return nm;
    }
}

