/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.jvm;

import com.sun.enterprise.admin.mbeans.jvm.JVMInformationCollector;
import com.sun.enterprise.admin.mbeans.jvm.StringBuilderNewLineAppender;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServerConnection;

class ClassReporter {
    private final MBeanServerConnection mbsc;
    private final StringManager sm = StringManager.getManager(ClassReporter.class);

    public ClassReporter(MBeanServerConnection mbsc) {
        this.mbsc = mbsc;
    }

    public String getClassReport() throws RuntimeException {
        try {
            StringBuilderNewLineAppender sb = new StringBuilderNewLineAppender(new StringBuilder());
            ClassLoadingMXBean clmb = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=ClassLoading", ClassLoadingMXBean.class);
            sb.append(this.sm.getString("classloading.info"));
            sb.append(this.sm.getString("classes.loaded", clmb.getLoadedClassCount()));
            sb.append(this.sm.getString("classes.total", clmb.getTotalLoadedClassCount()));
            sb.append(this.sm.getString("classes.unloaded", clmb.getUnloadedClassCount()));
            CompilationMXBean cmb = ManagementFactory.newPlatformMXBeanProxy(this.mbsc, "java.lang:type=Compilation", CompilationMXBean.class);
            sb.append(this.sm.getString("complilation.info"));
            sb.append(this.sm.getString("compilation.monitor.status", cmb.isCompilationTimeMonitoringSupported()));
            sb.append(this.sm.getString("jit.compilar.name", cmb.getName()));
            sb.append(this.sm.getString("compilation.time", JVMInformationCollector.millis2HoursMinutesSeconds(cmb.getTotalCompilationTime())));
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

