/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.event.EventContext;
import com.sun.enterprise.admin.event.EventStack;
import com.sun.enterprise.admin.server.core.AdminNotificationHelper;
import com.sun.enterprise.admin.util.proxy.Call;
import com.sun.enterprise.admin.util.proxy.CallStack;
import com.sun.enterprise.admin.util.proxy.InterceptorImpl;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.audit.AuditManagerFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.ObjectName;

public class ConfigInterceptor
extends InterceptorImpl {
    private AdminContext adminContext;
    private Logger _logger;
    private static AuditManager auditManager = AuditManagerFactory.getAuditManagerInstance();

    public ConfigInterceptor() {
    }

    public ConfigInterceptor(AdminContext ctx) {
        this.adminContext = ctx;
        this._logger = this.adminContext != null ? this.adminContext.getAdminLogger() : Logger.getLogger("global");
    }

    public void postInvoke(CallStack callStack) {
        if (callStack.getStackSize() == 1) {
            Call call = callStack.getActiveCall();
            if (call.getState().isSuccess() && this.isFlushNeeded(call)) {
                try {
                    ConfigContext ctx = this.adminContext.getAdminConfigContext();
                    if (ctx.isChanged()) {
                        ctx.flush();
                    }
                }
                catch (ConfigException ce) {
                    this._logger.log(Level.WARNING, "core.config_exception_occurred", ce);
                }
            }
            if (this.isFlushNeeded(call)) {
                new AdminNotificationHelper(this.adminContext).sendNotification();
            }
        }
        this.auditInvocation(callStack.getActiveCall());
    }

    private boolean isFlushNeeded(Call call) {
        String methodName = call.getMethod().getName();
        return methodName.equals("setAttribute") || methodName.equals("setAttributes") || methodName.equals("invoke") && !this.isReadonlyInvokeOperation(call);
    }

    private boolean isReadonlyInvokeOperation(Call call) {
        try {
            String operationName;
            Object[] args = call.getArguments();
            if (args != null && args.length > 1 && "takeNotifications".equals(operationName = (String)args[1])) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public void preInvoke(CallStack callstack) {
        if (callstack.getStackSize() == 1) {
            EventStack stack = new EventStack();
            stack.setConfigContext(this.adminContext.getAdminConfigContext());
            EventContext.setEventStackToThreadLocal(stack);
        }
    }

    private void auditInvocation(Call call) {
        if (auditManager.isAuditOn() && this.isAuditable(call)) {
            SecurityContext securityContext = SecurityContext.getCurrent();
        }
    }

    private boolean isAuditable(Call call) {
        String opName;
        if (call == null) {
            return false;
        }
        String methodName = call.getMethod().getName();
        if (!(methodName.equals("setAttribute") || methodName.equals("setAttributes") || methodName.equals("invoke"))) {
            return false;
        }
        if (methodName.equals("invoke") && ((opName = this.getOperationName(call)) == null || opName.startsWith("get") || opName.startsWith("list") || opName.startsWith("is"))) {
            return false;
        }
        String objectName = this.getObjectNameForCall(call);
        return objectName != null && objectName.indexOf("category=config") >= 0;
    }

    private String getOperationName(Call call) {
        Object[] params;
        if (call == null) {
            return null;
        }
        String methodName = call.getMethod().getName();
        if (methodName.equals("invoke") && (params = call.getArguments()) != null && params.length > 1 && params[1] instanceof String) {
            methodName = (String)params[1];
        }
        return methodName;
    }

    private String getAuditedParamsString(Call call) {
        if (call == null) {
            return null;
        }
        Object[] params = call.getArguments();
        if (params == null) {
            return null;
        }
        boolean i = false;
        String methodName = call.getMethod().getName();
        if (methodName.equals("invoke")) {
            if (params.length > 2) {
                return this.paramToString(params[2]);
            }
        } else if ((methodName.equals("setAttribute") || methodName.equals("setAttributes")) && params.length > 1) {
            return this.paramToString(params[1]);
        }
        return null;
    }

    private String paramToString(Object obj) {
        if (obj == null) {
            return null;
        }
        String res = null;
        if (obj instanceof Object[]) {
            res = "{";
            for (int i = 0; i < ((Object[])obj).length; ++i) {
                res = res + this.paramToString(((Object[])obj)[i]) + ";";
            }
            res = res + "}";
        } else if (obj instanceof ArrayList) {
            res = "{";
            for (int i = 0; i < ((ArrayList)obj).size(); ++i) {
                res = res + this.paramToString(((ArrayList)obj).get(i)) + ";";
            }
            res = res + "}";
        } else if (obj instanceof Properties) {
            res = "{";
            Enumeration<Object> keys = ((Properties)obj).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                res = res + key + "=" + ((Properties)obj).get(key) + ";";
            }
            res = res + "}";
        } else {
            res = obj instanceof Attribute ? "" + ((Attribute)obj).getName() + "=" + ((Attribute)obj).getValue() : (obj instanceof String || obj instanceof Number || obj instanceof ObjectName ? obj.toString() : "<?>");
        }
        return res;
    }

    private String getObjectNameForCall(Call call) {
        if (call == null) {
            return null;
        }
        Object[] params = call.getArguments();
        if (params == null || params.length < 1 || !(params[0] instanceof ObjectName)) {
            return null;
        }
        return params[0].toString();
    }
}

