/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.target;

import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.util.i18n.StringManager;

public class ConfigTarget
extends Target {
    private static final StringManager strMgr = StringManager.getManager(ConfigTarget.class);

    protected ConfigTarget(String name, ConfigContext cc) {
        super(name, cc);
    }

    public TargetType getType() {
        return TargetType.CONFIG;
    }

    public String getTargetObjectName(String[] tokens) {
        this.checkTokens(tokens, 1);
        return tokens[0] + ":type=config,category=config,name=" + this.getName();
    }

    public ConfigTarget getConfigTarget() throws Exception {
        return this;
    }

    public String getConfigRef() throws ConfigException {
        return this.getName();
    }

    public Server[] getServers() throws ConfigException {
        return ServerHelper.getServersReferencingConfig(this.getConfigContext(), this.getName());
    }

    public Cluster[] getClusters() throws ConfigException {
        return ClusterHelper.getClustersReferencingConfig(this.getConfigContext(), this.getName());
    }

    public Config[] getConfigs() throws ConfigException {
        Config[] configs = new Config[]{ConfigAPIHelper.getConfigByName(this.getConfigContext(), this.getName())};
        return configs;
    }

    public NodeAgent[] getNodeAgents() throws ConfigException {
        throw new ConfigException(strMgr.getString("target.not_supported", "getNodeAgents", this.getType().getName()));
    }

    public ApplicationRef[] getApplicationRefs() throws ConfigException {
        throw new ConfigException(strMgr.getString("target.not_supported", "getApplicationRefs", this.getType().getName()));
    }

    public ResourceRef[] getResourceRefs() throws ConfigException {
        throw new ConfigException(strMgr.getString("target.not_supported", "getResourceRefs", this.getType().getName()));
    }
}

