/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient;

import com.sun.enterprise.appclient.AppClientInfo;
import com.sun.enterprise.appclient.ClassFileAppClientInfo;
import com.sun.enterprise.appclient.NestedAppClientInfo;
import com.sun.enterprise.appclient.StandAloneAppClientInfo;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXParseException;

public class AppClientInfoFactory {
    protected static StringManager localStrings = StringManager.getManager(AppClientInfoFactory.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppClientInfo buildAppClientInfo(boolean isJWS, Logger logger, File locationFile, String mainClassFromCommandLine, String displayNameFromCommandLine, String classFileFromCommandLine) throws IOException, SAXParseException, ClassNotFoundException, URISyntaxException, AnnotationProcessorException, Exception {
        AppClientInfo result = null;
        if (classFileFromCommandLine != null) {
            AppClientArchivist archivist = new AppClientArchivist();
            result = new ClassFileAppClientInfo(isJWS, logger, locationFile, archivist, mainClassFromCommandLine, classFileFromCommandLine);
        } else {
            Archivist archivist = AppClientInfoFactory.prepareArchivist(locationFile);
            if (archivist == null) throw new IllegalArgumentException(localStrings.getString("appclient.invalidArchive", locationFile.getAbsolutePath()));
            if (archivist instanceof AppClientArchivist) {
                result = new StandAloneAppClientInfo(isJWS, logger, locationFile, archivist, mainClassFromCommandLine);
            } else {
                if (!(archivist instanceof ApplicationArchivist)) throw new IllegalArgumentException(localStrings.getString("appclient.unexpectedArchive", locationFile.getAbsolutePath()));
                result = new NestedAppClientInfo(isJWS, logger, locationFile, archivist, mainClassFromCommandLine, displayNameFromCommandLine);
            }
        }
        result.completeInit();
        if (!logger.isLoggable(Level.FINE)) return result;
        logger.fine(result.toString());
        return result;
    }

    private static Archivist prepareArchivist(File file) throws IOException {
        Archivist result = null;
        result = ArchivistFactory.getArchivistForArchive(file);
        return result;
    }
}

