/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.ContentOrigin;
import com.sun.enterprise.appclient.jws.StaticContent;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.net.URI;
import java.security.AccessControlException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.logging.Logger;
import sun.security.tools.JarSigner;

public class SignedStaticContent
extends StaticContent {
    private static final String SIGNEDJAR_OPTION = "-signedjar";
    private static final String KEYSTORE_OPTION = "-keystore";
    private static final String STOREPASS_OPTION = "-storepass";
    private File unsignedJar;
    private File signedJar;
    private URI installRootURI;
    private String keystoreAbsolutePath = null;
    private String KEYSTORE_PATH_PROPERTYNAME = "javax.net.ssl.keyStore";
    private String USER_SPECIFIED_ALIAS_PROPERTYNAME = "com.sun.aas.jws.signing.alias";
    private String DEFAULT_ALIAS_VALUE = "s1as";
    private Logger logger = DeploymentLogger.get();
    private StringManager localStrings;

    public SignedStaticContent(ContentOrigin origin, String contentKey, String path, File signedJar, File unsignedJar, URI installRootURI, StringManager localStrings, boolean isMain) throws Exception {
        super(origin, contentKey, path, signedJar, installRootURI, isMain);
        this.installRootURI = installRootURI;
        this.unsignedJar = unsignedJar;
        this.signedJar = signedJar;
        this.localStrings = localStrings;
    }

    public URI getRelativeURI() {
        try {
            this.ensureSignedFileUpToDate();
            return this.installRootURI.relativize(this.signedJar.toURI());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void ensureSignedFileUpToDate() throws KeyStoreException, IllegalArgumentException, Exception {
        if (!this.unsignedJar.exists()) {
            throw new IllegalArgumentException(this.localStrings.getString("jws.sign.noUnsignedJar", this.unsignedJar.getAbsolutePath()));
        }
        if (!this.signedJar.exists() || this.signedJar.lastModified() < this.unsignedJar.lastModified()) {
            this.signJar();
        }
    }

    private void signJar() throws KeyStoreException, Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add(SIGNEDJAR_OPTION);
        args.add(this.signedJar.getAbsolutePath());
        args.add(KEYSTORE_OPTION);
        args.add(this.getKeystoreAbsolutePath());
        args.add(STOREPASS_OPTION);
        int passwordSlot = args.size();
        args.add(this.getKeystorePassword());
        args.add(this.unsignedJar.getAbsolutePath());
        args.add(this.getAlias());
        long startTime = System.currentTimeMillis();
        SecurityManager mgr = System.getSecurityManager();
        try {
            NoExitSecurityManager noExitMgr = new NoExitSecurityManager(mgr);
            System.setSecurityManager(noExitMgr);
            JarSigner.main((String[])args.toArray(new String[args.size()]));
        }
        catch (Throwable t) {
            this.signedJar.delete();
            throw new Exception(this.localStrings.getString("jws.sign.errorSigning", this.signedJar.getAbsolutePath()), t);
        }
        finally {
            System.setSecurityManager(mgr);
            args.set(passwordSlot, null);
            long duration = System.currentTimeMillis() - startTime;
            this.logger.fine("Signing " + this.unsignedJar.getAbsolutePath() + " took " + duration + " ms");
        }
    }

    private String getKeystoreAbsolutePath() {
        if (this.keystoreAbsolutePath == null) {
            this.keystoreAbsolutePath = System.getProperty(this.KEYSTORE_PATH_PROPERTYNAME);
        }
        return this.keystoreAbsolutePath;
    }

    private String getKeystorePassword() {
        return SSLUtils.getKeyStorePass();
    }

    private String getAlias() throws KeyStoreException, Exception {
        KeyStore keystore = SSLUtils.getKeyStore();
        String alias = System.getProperty(this.USER_SPECIFIED_ALIAS_PROPERTYNAME);
        if (alias == null || !this.checkUserAlias(keystore, alias)) {
            this.checkDefaultAlias(keystore);
            alias = this.DEFAULT_ALIAS_VALUE;
        }
        return alias;
    }

    private void checkDefaultAlias(KeyStore keystore) throws KeyStoreException {
        if (!keystore.containsAlias(this.DEFAULT_ALIAS_VALUE)) {
            throw new IllegalStateException(this.localStrings.getString("jws.sign.defaultAliasAbsent", this.DEFAULT_ALIAS_VALUE));
        }
    }

    private boolean checkUserAlias(KeyStore keystore, String candidateAlias) throws KeyStoreException {
        boolean result = keystore.containsAlias(candidateAlias);
        if (!result) {
            this.logger.warning(this.localStrings.getString("jws.sign.userAliasAbsent", candidateAlias));
        }
        return result;
    }

    private class NoExitSecurityManager
    extends SecurityManager {
        private SecurityManager originalManager;

        public NoExitSecurityManager(SecurityManager originalManager) {
            this.originalManager = originalManager;
        }

        public void checkExit(int status) {
            throw new AccessControlException("System.exit");
        }

        public void checkPermission(Permission p) {
            if (this.originalManager != null) {
                this.originalManager.checkPermission(p);
            }
        }
    }
}

