/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;

public class Profiler
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    private static final Version runtimeVersion = new Version(4, 2, 0);
    public static final String JVM_OPTIONS = "JvmOptions";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public Profiler() {
        this(1);
    }

    public Profiler(int options) {
        super(comparators, runtimeVersion);
        this.initPropertyTables(2);
        this.createProperty("jvm-options", JVM_OPTIONS, 65842, String.class);
        this.createProperty("property", ELEMENT_PROPERTY, 66098, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setJvmOptions(String[] value) {
        this.setValue(JVM_OPTIONS, value);
    }

    public String[] getJvmOptions() {
        return (String[])this.getValues(JVM_OPTIONS);
    }

    public int sizeJvmOptions() {
        return this.size(JVM_OPTIONS);
    }

    public int addJvmOptions(String value) throws ConfigException {
        return this.addJvmOptions(value, true);
    }

    public int addJvmOptions(String value, boolean overwrite) throws ConfigException {
        return this.addValue(JVM_OPTIONS, value, overwrite);
    }

    public int removeJvmOptions(String value) {
        return this.removeValue(JVM_OPTIONS, value);
    }

    public int removeJvmOptions(String value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(JVM_OPTIONS, value, overwrite);
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(Profiler.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getName() {
        return this.getAttributeValue("name");
    }

    public void setName(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("name", v, overwrite);
    }

    public void setName(String v) {
        this.setAttributeValue("name", v);
    }

    public String getClasspath() {
        return this.getAttributeValue("classpath");
    }

    public void setClasspath(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("classpath", v, overwrite);
    }

    public void setClasspath(String v) {
        this.setAttributeValue("classpath", v);
    }

    public String getNativeLibraryPath() {
        return this.getAttributeValue("native-library-path");
    }

    public void setNativeLibraryPath(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("native-library-path", v, overwrite);
    }

    public void setNativeLibraryPath(String v) {
        this.setAttributeValue("native-library-path", v);
    }

    public boolean isEnabled() {
        return Profiler.toBoolean(this.getAttributeValue("enabled"));
    }

    public void setEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("enabled", "" + v, overwrite);
    }

    public void setEnabled(boolean v) {
        this.setAttributeValue("enabled", "" + v);
    }

    public static String getDefaultEnabled() {
        return "true".trim();
    }

    public ElementProperty newElementProperty() {
        return new ElementProperty();
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "profiler" + (this.canHaveSiblings() ? "[@name='" + this.getAttributeValue("name") + "']" : "");
        return null != ret ? ret.trim() : null;
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals("enabled")) {
            return "true".trim();
        }
        return null;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void validate() throws ValidateException {
    }

    public void dump(StringBuffer str, String indent) {
        int i;
        str.append(indent);
        str.append("JvmOptions[" + this.sizeJvmOptions() + "]");
        for (i = 0; i < this.sizeJvmOptions(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            str.append(indent + "\t");
            str.append("<");
            Object o = this.getValue(JVM_OPTIONS, i);
            str.append(o == null ? "null" : o.toString().trim());
            str.append(">\n");
            this.dumpAttributes(JVM_OPTIONS, i, str, indent);
        }
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            ElementProperty n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("Profiler\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

