/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.ConnectorService;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.ExternalJndiResource;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.JmsHost;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.LbConfigs;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.MdbContainer;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.PersistenceManagerFactoryResource;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.serverbeans.WebContainer;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerBeansFactory {
    private static Config configModel;
    private static StringManager localStrings;

    public static Config getConfigModel(ConfigContext configContext) throws ConfigException {
        if (configContext == null) {
            String msg = localStrings.getString("serverContext.config_context_is_null");
            throw new ConfigException(msg);
        }
        Server server = ServerBeansFactory.getServerBean(configContext);
        String configRef = server.getConfigRef();
        String configXpath = ServerXPathHelper.getConfigIdXpath(configRef);
        configModel = (Config)ConfigBeansFactory.getConfigBeanByXPath(configContext, configXpath);
        return configModel;
    }

    public static Domain getDomainBean(ConfigContext ctx) throws ConfigException {
        return (Domain)ctx.getRootConfigBean();
    }

    public static Server getServerBean(ConfigContext ctx) throws ConfigException {
        String serverName = System.getProperty("com.sun.aas.instanceName");
        String xpath = ServerXPathHelper.getServerIdXpath(serverName);
        Server server = (Server)ConfigBeansFactory.getConfigBeanByXPath(ctx, xpath);
        return server;
    }

    public static Config getConfigBean(ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getConfigModel(ctx);
    }

    public static ConfigBean[] getResources(ConfigContext ctx, String type) throws ConfigException {
        Resources r = ServerBeansFactory.getDomainBean(ctx).getResources();
        return r.getChildBeansByName(type);
    }

    public static ConnectorService getConnectorServiceBean(ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getConfigBean(ctx).getConnectorService();
    }

    public static SecurityService getSecurityServiceBean(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        return cfg.getSecurityService();
    }

    public static TransactionService getTransactionServiceBean(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        return cfg.getTransactionService();
    }

    public static HttpService getHttpServiceBean(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        HttpService httpService = cfg.getHttpService();
        return httpService;
    }

    public static JmsService getJmsServiceBean(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        JmsService jmsService = cfg.getJmsService();
        return jmsService;
    }

    public static JmsHost getJmsHostBean(ConfigContext ctx) throws ConfigException {
        JmsService jmsService = ServerBeansFactory.getJmsServiceBean(ctx);
        JmsHost[] hosts = jmsService.getJmsHost();
        return hosts[0];
    }

    public static IiopService getIiopServiceBean(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        IiopService iiopService = cfg.getIiopService();
        return iiopService;
    }

    public static JavaConfig getJavaConfigBean(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        JavaConfig javaConfig = cfg.getJavaConfig();
        return javaConfig;
    }

    public static String getAdminServiceLogLevel(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        LogService logService = cfg.getLogService();
        return logService.getModuleLogLevels().getAdmin();
    }

    public static String getEjbContainerLogLevel(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        LogService logService = cfg.getLogService();
        return logService.getModuleLogLevels().getEjbContainer();
    }

    public static String getWebContainerLogLevel(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        LogService logService = cfg.getLogService();
        return logService.getModuleLogLevels().getWebContainer();
    }

    public static String getMdbContainerLogLevel(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        LogService logService = cfg.getLogService();
        return logService.getModuleLogLevels().getMdbContainer();
    }

    public static String getSecurityServiceLogLevel(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        LogService logService = cfg.getLogService();
        return logService.getModuleLogLevels().getSecurity();
    }

    public static String getTransactionServiceLogLevel(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        LogService logService = cfg.getLogService();
        return logService.getModuleLogLevels().getJts();
    }

    public static String getCorbaLogLevel(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        LogService logService = cfg.getLogService();
        return logService.getModuleLogLevels().getCorba();
    }

    public static String getRootLogLevel(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        LogService logService = cfg.getLogService();
        return logService.getModuleLogLevels().getRoot();
    }

    public static MdbContainer getMdbContainerBean(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        MdbContainer container = cfg.getMdbContainer();
        return container;
    }

    public static DasConfig getDasConfigBean(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        AdminService as = cfg.getAdminService();
        DasConfig ds = null;
        if (as != null) {
            ds = as.getDasConfig();
        }
        return ds;
    }

    public static Applications getApplicationsBean(ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getDomainBean(ctx).getApplications();
    }

    public static WebContainer getWebContainerBean(ConfigContext ctx) throws ConfigException {
        Config cfg = ServerBeansFactory.getConfigBean(ctx);
        WebContainer webContainer = cfg.getWebContainer();
        return webContainer;
    }

    public static Server getServerBeanFromArray(Server[] serverArray, String serverName) {
        for (int i = 0; i < serverArray.length; ++i) {
            if (!serverArray[i].getName().equals(serverName)) continue;
            return serverArray[i];
        }
        return serverArray[0];
    }

    public static boolean isReferenced(AdminObjectResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByResourceRef(res.getJndiName(), ctx);
    }

    public static Set getReferers(AdminObjectResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getResourceRefsReferencing(res.getJndiName(), ctx);
    }

    public static boolean isReferenced(AppclientModule cm, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByApplicationRef(cm.getName(), ctx);
    }

    public static Set getReferers(AppclientModule cm, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getApplicationRefsReferencing(cm.getName(), ctx);
    }

    public static boolean isReferenced(Config res, ConfigContext ctx) throws ConfigException {
        if (null == res || null == ctx) {
            return false;
        }
        Iterator it = ServerBeansFactory.getServers(ctx).iterator();
        while (it.hasNext()) {
            if (!res.getName().equals(((Server)it.next()).getConfigRef())) continue;
            return true;
        }
        it = ServerBeansFactory.getClusters(ctx).iterator();
        while (it.hasNext()) {
            if (!res.getName().equals(((Cluster)it.next()).getConfigRef())) continue;
            return true;
        }
        return false;
    }

    public static Set getReferers(Config res, ConfigContext ctx) throws ConfigException {
        if (null == res || null == ctx) {
            return Collections.EMPTY_SET;
        }
        HashSet<ConfigBean> result = new HashSet<ConfigBean>();
        for (ConfigBean el : ServerBeansFactory.getServers(ctx)) {
            if (!res.getName().equals(((Server)el).getConfigRef())) continue;
            result.add(el);
        }
        for (ConfigBean el : ServerBeansFactory.getClusters(ctx)) {
            if (!res.getName().equals(((Cluster)el).getConfigRef())) continue;
            result.add(el);
        }
        return result;
    }

    public static boolean isReferenced(NodeAgent res, ConfigContext ctx) throws ConfigException {
        if (null == res || null == ctx) {
            return false;
        }
        Iterator it = ServerBeansFactory.getServers(ctx).iterator();
        while (it.hasNext()) {
            if (!res.getName().equals(((Server)it.next()).getNodeAgentRef())) continue;
            return true;
        }
        return false;
    }

    public static Set getReferers(NodeAgent res, ConfigContext ctx) throws ConfigException {
        if (null == res || null == ctx) {
            return Collections.EMPTY_SET;
        }
        HashSet<Server> result = new HashSet<Server>();
        for (Server el : ServerBeansFactory.getServers(ctx)) {
            if (!res.getName().equals(el.getNodeAgentRef())) continue;
            result.add(el);
        }
        return result;
    }

    public static boolean isReferenced(ConnectorResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByResourceRef(res.getJndiName(), ctx);
    }

    public static Set getReferers(ConnectorResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getResourceRefsReferencing(res.getJndiName(), ctx);
    }

    public static boolean isReferenced(Cluster cm, ConfigContext ctx) throws ConfigException {
        if (null == cm || null == ctx) {
            return false;
        }
        Set refs = ServerBeansFactory.getClusterRefs(ctx);
        if (refs.isEmpty()) {
            return false;
        }
        Iterator it = refs.iterator();
        while (it.hasNext()) {
            if (!cm.getName().equals(((ClusterRef)it.next()).getRef())) continue;
            return true;
        }
        return false;
    }

    public static Set getReferers(Cluster cm, ConfigContext ctx) throws ConfigException {
        if (null == cm || null == ctx) {
            return Collections.EMPTY_SET;
        }
        Set refs = ServerBeansFactory.getClusterRefs(ctx);
        if (refs.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<ClusterRef> result = new HashSet<ClusterRef>();
        for (ClusterRef ref : refs) {
            if (!cm.getName().equals(ref.getRef())) continue;
            result.add(ref);
        }
        return result;
    }

    public static boolean isReferenced(ConnectorConnectionPool cm, ConfigContext ctx) throws ConfigException {
        if (null == cm || null == ctx) {
            return false;
        }
        Set crs = ServerBeansFactory.getConnectorResources(ctx);
        if (crs.isEmpty()) {
            return false;
        }
        Iterator it = crs.iterator();
        while (it.hasNext()) {
            if (!cm.getName().equals(((ConnectorResource)it.next()).getPoolName())) continue;
            return true;
        }
        return false;
    }

    public static Set getReferers(ConnectorConnectionPool cm, ConfigContext ctx) throws ConfigException {
        if (null == cm || null == ctx) {
            return Collections.EMPTY_SET;
        }
        Set crs = ServerBeansFactory.getConnectorResources(ctx);
        if (crs.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<ConnectorResource> result = new HashSet<ConnectorResource>();
        for (ConnectorResource cr : crs) {
            if (!cm.getName().equals(cr.getPoolName())) continue;
            result.add(cr);
        }
        return result;
    }

    public static boolean isReferenced(ConnectorModule cm, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByApplicationRef(cm.getName(), ctx);
    }

    public static Set getReferers(ConnectorModule cm, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getApplicationRefsReferencing(cm.getName(), ctx);
    }

    public static boolean isReferenced(CustomResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByResourceRef(res.getJndiName(), ctx);
    }

    public static Set getReferers(CustomResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getResourceRefsReferencing(res.getJndiName(), ctx);
    }

    public static boolean isReferenced(EjbModule cm, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByApplicationRef(cm.getName(), ctx);
    }

    public static Set getReferers(EjbModule cm, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getApplicationRefsReferencing(cm.getName(), ctx);
    }

    public static boolean isReferenced(ExternalJndiResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByResourceRef(res.getJndiName(), ctx);
    }

    public static Set getReferers(ExternalJndiResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getResourceRefsReferencing(res.getJndiName(), ctx);
    }

    public static boolean isReferenced(J2eeApplication cm, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByApplicationRef(cm.getName(), ctx);
    }

    public static Set getReferers(J2eeApplication cm, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getApplicationRefsReferencing(cm.getName(), ctx);
    }

    public static boolean isReferenced(JdbcResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByResourceRef(res.getJndiName(), ctx);
    }

    public static Set getReferers(JdbcResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getResourceRefsReferencing(res.getJndiName(), ctx);
    }

    public static boolean isReferenced(LifecycleModule cm, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByApplicationRef(cm.getName(), ctx);
    }

    public static Set getReferers(LifecycleModule cm, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getApplicationRefsReferencing(cm.getName(), ctx);
    }

    public static boolean isReferenced(MailResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByResourceRef(res.getJndiName(), ctx);
    }

    public static Set getReferers(MailResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getResourceRefsReferencing(res.getJndiName(), ctx);
    }

    public static boolean isReferenced(PersistenceManagerFactoryResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByResourceRef(res.getJndiName(), ctx);
    }

    public static Set getReferers(PersistenceManagerFactoryResource res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getResourceRefsReferencing(res.getJndiName(), ctx);
    }

    public static boolean isReferenced(ResourceAdapterConfig res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByResourceRef(res.getResourceAdapterName(), ctx);
    }

    public static Set getReferers(ResourceAdapterConfig res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getResourceRefsReferencing(res.getResourceAdapterName(), ctx);
    }

    public static boolean isReferenced(Server res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.isReferencedByServerRef(res.getName(), ctx);
    }

    public static Set getReferers(Server res, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getServerRefsReferencing(res.getName(), ctx);
    }

    public static boolean isReferenced(WebModule cm, ConfigContext ctx) throws ConfigException {
        Iterator it = ServerBeansFactory.getVirtualServers(ctx).iterator();
        while (it.hasNext()) {
            if (!cm.getName().equals(((VirtualServer)it.next()).getDefaultWebModule())) continue;
            return true;
        }
        return ServerBeansFactory.isReferencedByApplicationRef(cm.getName(), ctx);
    }

    public static Set getReferers(WebModule cm, ConfigContext ctx) throws ConfigException {
        return ServerBeansFactory.getApplicationRefsReferencing(cm.getName(), ctx);
    }

    private static boolean isReferencedByApplicationRef(String name, ConfigContext ctx) throws ConfigException {
        Iterator it = ServerBeansFactory.getApplicationRefs(ctx).iterator();
        while (it.hasNext()) {
            if (!name.equals(((ApplicationRef)it.next()).getRef())) continue;
            return true;
        }
        return false;
    }

    private static Set getApplicationRefsReferencing(String name, ConfigContext ctx) throws ConfigException {
        HashSet<ApplicationRef> refers = new HashSet<ApplicationRef>();
        for (ApplicationRef ar : ServerBeansFactory.getApplicationRefs(ctx)) {
            if (!name.equals(ar.getRef())) continue;
            refers.add(ar);
        }
        return refers;
    }

    public static Set getApplicationRefs(ConfigContext ctx) throws ConfigException {
        HashSet<ApplicationRef> refs = new HashSet<ApplicationRef>();
        Iterator it = ServerBeansFactory.getServers(ctx).iterator();
        while (it.hasNext()) {
            refs.addAll(Arrays.asList(((Server)it.next()).getApplicationRef()));
        }
        it = ServerBeansFactory.getClusters(ctx).iterator();
        while (it.hasNext()) {
            refs.addAll(Arrays.asList(((Cluster)it.next()).getApplicationRef()));
        }
        return refs;
    }

    private static boolean isReferencedByResourceRef(String name, ConfigContext ctx) throws ConfigException {
        Iterator it = ServerBeansFactory.getResourceRefs(ctx).iterator();
        while (it.hasNext()) {
            if (!name.equals(((ResourceRef)it.next()).getRef())) continue;
            return true;
        }
        return false;
    }

    private static Set getResourceRefsReferencing(String name, ConfigContext ctx) throws ConfigException {
        HashSet<ResourceRef> refers = new HashSet<ResourceRef>();
        for (ResourceRef ar : ServerBeansFactory.getResourceRefs(ctx)) {
            if (!name.equals(ar.getRef())) continue;
            refers.add(ar);
        }
        return refers;
    }

    private static boolean isReferencedByServerRef(String name, ConfigContext ctx) throws ConfigException {
        Iterator it = ServerBeansFactory.getServerRefs(ctx).iterator();
        while (it.hasNext()) {
            if (!name.equals(((ServerRef)it.next()).getRef())) continue;
            return true;
        }
        return false;
    }

    private static Set getServerRefsReferencing(String name, ConfigContext ctx) throws ConfigException {
        HashSet<ServerRef> refers = new HashSet<ServerRef>();
        for (ServerRef ar : ServerBeansFactory.getServerRefs(ctx)) {
            if (!name.equals(ar.getRef())) continue;
            refers.add(ar);
        }
        return refers;
    }

    public static Set getResourceRefs(ConfigContext ctx) throws ConfigException {
        HashSet<ResourceRef> refs = new HashSet<ResourceRef>();
        Iterator it = ServerBeansFactory.getServers(ctx).iterator();
        while (it.hasNext()) {
            refs.addAll(Arrays.asList(((Server)it.next()).getResourceRef()));
        }
        it = ServerBeansFactory.getClusters(ctx).iterator();
        while (it.hasNext()) {
            refs.addAll(Arrays.asList(((Cluster)it.next()).getResourceRef()));
        }
        return refs;
    }

    public static Set getServerRefs(ConfigContext ctx) throws ConfigException {
        HashSet<ServerRef> refs = new HashSet<ServerRef>();
        Iterator it = ServerBeansFactory.getLbConfigs(ctx).iterator();
        while (it.hasNext()) {
            refs.addAll(Arrays.asList(((LbConfig)it.next()).getServerRef()));
        }
        it = ServerBeansFactory.getClusters(ctx).iterator();
        while (it.hasNext()) {
            refs.addAll(Arrays.asList(((Cluster)it.next()).getServerRef()));
        }
        return refs;
    }

    public static Set getConfigs(ConfigContext ctx) throws ConfigException {
        if (null == ctx) {
            return Collections.EMPTY_SET;
        }
        Domain dom = (Domain)ctx.getRootConfigBean();
        if (null == dom) {
            return Collections.EMPTY_SET;
        }
        Configs configs = dom.getConfigs();
        if (null == configs || null == configs.getConfig()) {
            return Collections.EMPTY_SET;
        }
        HashSet<Config> result = new HashSet<Config>();
        result.addAll(Arrays.asList(configs.getConfig()));
        return result;
    }

    public static Set getClusters(ConfigContext ctx) throws ConfigException {
        if (null == ctx) {
            return Collections.EMPTY_SET;
        }
        Domain dom = (Domain)ctx.getRootConfigBean();
        if (null == dom) {
            return Collections.EMPTY_SET;
        }
        Clusters clusters = dom.getClusters();
        if (null == clusters || null == clusters.getCluster()) {
            return Collections.EMPTY_SET;
        }
        HashSet<Cluster> result = new HashSet<Cluster>();
        result.addAll(Arrays.asList(clusters.getCluster()));
        return result;
    }

    public static Set getServers(ConfigContext ctx) throws ConfigException {
        if (null == ctx) {
            return Collections.EMPTY_SET;
        }
        Domain dom = (Domain)ctx.getRootConfigBean();
        if (null == dom) {
            return Collections.EMPTY_SET;
        }
        Servers servers = dom.getServers();
        if (null == servers || null == servers.getServer()) {
            return Collections.EMPTY_SET;
        }
        HashSet<Server> result = new HashSet<Server>();
        result.addAll(Arrays.asList(servers.getServer()));
        return result;
    }

    public static Set getVirtualServers(ConfigContext ctx) throws ConfigException {
        HashSet<VirtualServer> result = new HashSet<VirtualServer>();
        Iterator it = ServerBeansFactory.getHttpServices(ctx).iterator();
        while (it.hasNext()) {
            VirtualServer[] vs = ((HttpService)it.next()).getVirtualServer();
            if (null == vs) continue;
            result.addAll(Arrays.asList(vs));
        }
        return result;
    }

    public static Set getHttpServices(ConfigContext ctx) throws ConfigException {
        HashSet<HttpService> result = new HashSet<HttpService>();
        Iterator it = ServerBeansFactory.getConfigs(ctx).iterator();
        while (it.hasNext()) {
            result.add(((Config)it.next()).getHttpService());
        }
        return result;
    }

    public static Set getClusterRefs(ConfigContext ctx) throws ConfigException {
        Set lbconfigs = ServerBeansFactory.getLbConfigs(ctx);
        if (lbconfigs.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<ClusterRef> result = new HashSet<ClusterRef>();
        Iterator it = lbconfigs.iterator();
        while (it.hasNext()) {
            ClusterRef[] cr = ((LbConfig)it.next()).getClusterRef();
            if (null == cr) continue;
            result.addAll(Arrays.asList(cr));
        }
        return result;
    }

    public static Set getConnectorResources(ConfigContext ctx) throws ConfigException {
        HashSet<ConfigBean> result = new HashSet<ConfigBean>();
        ConfigBean[] cr = ServerBeansFactory.getResources(ctx, "connector-resource");
        if (null != cr) {
            result.addAll(Arrays.asList(cr));
        }
        return result;
    }

    public static Set getLbConfigs(ConfigContext ctx) throws ConfigException {
        if (null == ctx) {
            return Collections.EMPTY_SET;
        }
        Domain dom = (Domain)ctx.getRootConfigBean();
        if (null == dom) {
            return Collections.EMPTY_SET;
        }
        LbConfigs lbconfigs = dom.getLbConfigs();
        if (null == lbconfigs || null == lbconfigs.getLbConfig()) {
            return Collections.EMPTY_SET;
        }
        HashSet<LbConfig> result = new HashSet<LbConfig>();
        result.addAll(Arrays.asList(lbconfigs.getLbConfig()));
        return result;
    }

    public static String getVirtualServersByAppName(ConfigContext ctx, String appName) throws ConfigException {
        ApplicationRef ar = ServerBeansFactory.getServerBean(ctx).getApplicationRefByRef(appName);
        if (ar == null) {
            return null;
        }
        return ar.getVirtualServers();
    }

    public static List<Mbean> getAllMBeanDefinitions(ConfigContext cc) throws ConfigException {
        Domain d = ServerBeansFactory.getDomainBean(cc);
        Applications as = d.getApplications();
        Mbean[] ma = as.getMbean();
        List<Mbean> ml = Arrays.asList(ma);
        return Collections.unmodifiableList(ml);
    }

    public static List<Mbean> getReferencedMBeans(ConfigContext cc, String sn) throws ConfigException {
        Server[] ss;
        ArrayList<Mbean> em = new ArrayList<Mbean>();
        Domain d = ServerBeansFactory.getDomainBean(cc);
        for (Server a : ss = d.getServers().getServer()) {
            ApplicationRef[] ars;
            if (!sn.equals(a.getName())) continue;
            for (ApplicationRef ar : ars = a.getApplicationRef()) {
                Mbean tmp = ServerBeansFactory.getMBeanDefinition(cc, ar.getRef());
                if (tmp == null) continue;
                em.add(tmp);
            }
        }
        return Collections.unmodifiableList(em);
    }

    public static boolean isReferencedMBean(ConfigContext cc, String sn, String mn) throws ConfigException {
        List<Mbean> rm = ServerBeansFactory.getReferencedMBeans(cc, sn);
        boolean refd = false;
        for (Mbean m : rm) {
            if (!m.getName().equals(mn)) continue;
            refd = true;
            break;
        }
        return refd;
    }

    public static boolean isReferencedMBeanInCluster(ConfigContext cc, String cn, String mn) throws ConfigException {
        int i;
        assert (cc != null && cn != null && mn != null);
        if (cc == null || cn == null || mn == null) {
            return false;
        }
        Server[] ss = ServerHelper.getServersInCluster(cc, cn);
        if (ss == null || ss.length < 1) {
            return false;
        }
        boolean[] isrefs = new boolean[ss.length];
        for (i = 0; i < ss.length; ++i) {
            isrefs[i] = ServerBeansFactory.isReferencedMBean(cc, ss[i].getName(), mn);
        }
        for (i = 1; i < ss.length; ++i) {
            if (isrefs[i] == isrefs[0]) continue;
            String messy = ServerBeansFactory.prepareMessyStringMessage(ss, isrefs);
            String msg = StringManager.getManager(ServerBeansFactory.class).getString("CorruptClusterConfig", new Object[]{cn, mn, messy});
            throw new ConfigException(msg);
        }
        return isrefs[0];
    }

    public static List<Mbean> getFullyEnabledMBeans(ConfigContext cc, String sn) throws ConfigException {
        Server[] ss;
        ArrayList<Mbean> em = new ArrayList<Mbean>();
        Domain d = ServerBeansFactory.getDomainBean(cc);
        for (Server a : ss = d.getServers().getServer()) {
            ApplicationRef[] ars;
            if (!sn.equals(a.getName())) continue;
            for (ApplicationRef ar : ars = a.getApplicationRef()) {
                Mbean tmp;
                if (!ar.isEnabled() || (tmp = ServerBeansFactory.getMBeanDefinition(cc, ar.getRef())) == null || !tmp.isEnabled()) continue;
                em.add(tmp);
            }
        }
        return Collections.unmodifiableList(em);
    }

    public static Mbean getMBeanDefinition(ConfigContext cc, String n) throws ConfigException {
        Mbean[] ms;
        Domain d = ServerBeansFactory.getDomainBean(cc);
        Applications a = d.getApplications();
        for (Mbean m : ms = a.getMbean()) {
            if (!n.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public static List<Mbean> getFullyEnabledUserDefinedMBeans(ConfigContext cc, String sn) throws ConfigException {
        List<Mbean> em = ServerBeansFactory.getFullyEnabledMBeans(cc, sn);
        ArrayList<Mbean> uem = new ArrayList<Mbean>();
        for (Mbean m : em) {
            assert (m.isEnabled());
            if (!"user".equals(m.getObjectType())) continue;
            uem.add(m);
        }
        return Collections.unmodifiableList(uem);
    }

    public static void addMbeanDefinition(ConfigContext cc, Mbean m) throws ConfigException {
        Domain d = ServerBeansFactory.getDomainBean(cc);
        Applications as = d.getApplications();
        as.addMbean(m);
    }

    public static void addMbeanReference(ConfigContext cc, String toThisMbean, String server) throws ConfigException {
        Domain d = ServerBeansFactory.getDomainBean(cc);
        Servers ss = d.getServers();
        Server s = ss.getServerByName(server);
        ApplicationRef ar = new ApplicationRef();
        ar.setRef(toThisMbean);
        ar.setEnabled(true);
        s.addApplicationRef(ar);
    }

    public static void addClusterMbeanReference(ConfigContext cc, String toThisMbean, String clusterName) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterByName(cc, clusterName);
        ApplicationRef ar = new ApplicationRef();
        ar.setRef(toThisMbean);
        ar.setEnabled(true);
        cluster.addApplicationRef(ar);
    }

    public static void removeMbeanDefinition(ConfigContext cc, String n) throws ConfigException {
        Domain d = ServerBeansFactory.getDomainBean(cc);
        Applications as = d.getApplications();
        as.removeMbean(as.getMbeanByName(n));
    }

    public static void removeMbeanReference(ConfigContext cc, String ref, String server) throws ConfigException {
        Domain d = ServerBeansFactory.getDomainBean(cc);
        Servers ss = d.getServers();
        Server s = ss.getServerByName(server);
        ApplicationRef ar = s.getApplicationRefByRef(ref);
        s.removeApplicationRef(ar);
    }

    public static void removeClusterMbeanReference(ConfigContext cc, String ref, String clusterName) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterByName(cc, clusterName);
        ApplicationRef ar = cluster.getApplicationRefByRef(ref);
        cluster.removeApplicationRef(ar);
    }

    public static Server[] getServersReferencingMBeanDefinition(ConfigContext cc, String name) throws ConfigException {
        Server[] ss = null;
        ArrayList<Server> list = new ArrayList<Server>();
        ss = ServerBeansFactory.getDomainBean(cc).getServers().getServer();
        boolean numberOfReferencingServers = false;
        for (Server s : ss) {
            boolean referenced = false;
            String sName = s.getName();
            referenced = ServerBeansFactory.isReferencedMBean(cc, sName, name);
            if (!referenced) continue;
            list.add(s);
        }
        Server[] rss = new Server[list.size()];
        return list.toArray(rss);
    }

    private static String prepareMessyStringMessage(Server[] ss, boolean[] isrefs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ss.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            String s = isrefs[i] ? "referenced" : "not-referenced";
            sb.append(ss[i].getName()).append(":").append(s);
        }
        return sb.toString();
    }

    static {
        localStrings = StringManager.getManager("com.sun.enterprise.server");
    }
}

