/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.instance.ApplicationEnvironment;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.application.EJBSecurityManager;
import com.sun.enterprise.security.factory.EJBSecurityManagerFactory;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.web.security.WebSecurityManager;
import com.sun.web.security.WebSecurityManagerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

abstract class AppDeployerBase
extends Deployer {
    private ApplicationEnvironment appEnv;
    private AppsManager appMgr;
    private String appName;
    private boolean isReg;
    private boolean isSystem = false;
    private File stubsDir;
    private File jspDir;
    private File xmlDir;
    private File jwsDir;
    private File appDir;
    private static StringManager localStrings = StringManager.getManager(AppDeployerBase.class);

    AppDeployerBase(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    protected abstract File setAppDir() throws IASDeploymentException;

    protected void begin() throws IASDeploymentException {
        super.begin();
        try {
            this.appEnv = this.request.getAppEnv();
            if (this.appEnv == null) {
                String msg = localStrings.getString("enterprise.deployment.backend.null_applicationenvironment_object");
                throw new IASDeploymentException(msg);
            }
            this.appMgr = new AppsManager(this.getInstanceEnv());
            this.appName = this.request.getName();
            if (!StringUtils.ok(this.appName)) {
                String msg = localStrings.getString("enterprise.deployment.backend.null_appname");
                throw new IASDeploymentException(msg);
            }
            this.isReg = DeploymentServiceUtils.isRegistered(this.getAppName(), this.request.getType());
            if (this.isReg) {
                this.isSystem = this.isSystem();
            }
            this.verify();
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected void predeploy() throws IASDeploymentException {
        try {
            this.appDir = this.setAppDir();
            this.request.setDeployedDirectory(this.appDir);
            this.setGeneratedDirs();
        }
        catch (IASDeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected final void verify() throws IASDeploymentException {
        if (!this.request.isApplication()) {
            String msg = localStrings.getString("enterprise.deployment.backend.attempt_to_deploy_non_application");
            throw new IASDeploymentException(msg);
        }
        if (this.request.isUnDeploy()) {
            if (!this.isReg) {
                String msg = localStrings.getString("enterprise.deployment.backend.undeploy_error_application_not_registered");
                throw new IASDeploymentException(msg);
            }
            if (this.isSystem) {
                String msg = localStrings.getString("enterprise.deployment.backend.undeploy_error_application_is_a_system_resource");
                throw new IASDeploymentException(msg);
            }
        } else if (this.request.isDeploy()) {
            if (this.isReg) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_application_exists");
                throw new IASDeploymentException(msg);
            }
            this.checkRegisteredAnywhereElse(this.appName);
        } else if (this.request.isReDeploy()) {
            if (!this.isReg) {
                String msg = localStrings.getString("enterprise.deployment.backend.redeploy_error_application_does_not_exist");
                throw new IASDeploymentException(msg);
            }
            if (this.isSystem) {
                String msg = localStrings.getString("enterprise.deployment.backend.redeploy_error_application_is_a_system_resource");
                throw new IASDeploymentException(msg);
            }
        }
    }

    private final void setGeneratedDirs() throws IASDeploymentException {
        try {
            this.stubsDir = new File(this.getAppEnv().getAppStubPath());
            this.jspDir = new File(this.getAppEnv().getAppJSPPath());
            this.xmlDir = new File(this.getAppEnv().getAppGeneratedXMLPath());
            this.jwsDir = new File(this.getAppEnv().getJavaWebStartPath());
            this.request.setJSPDirectory(this.jspDir);
            this.request.setStubsDirectory(this.stubsDir);
            this.request.setGeneratedXMLDirectory(this.xmlDir);
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_getting_generated_dirs", e);
            throw new IASDeploymentException(msg);
        }
    }

    protected final ApplicationEnvironment getAppEnv() {
        return this.appEnv;
    }

    protected BaseManager getManager() {
        return this.appMgr;
    }

    protected final String getAppName() {
        return this.appName;
    }

    protected final File getStubsDir() {
        return this.stubsDir;
    }

    protected final File getJSPDir() {
        return this.jspDir;
    }

    protected final File getXMLDir() {
        return this.xmlDir;
    }

    protected final File getJWSDir() {
        return this.jwsDir;
    }

    protected final File getAppDir() {
        return this.appDir;
    }

    protected final File getModuleDir() {
        return this.appDir;
    }

    protected List getModuleClasspath(Archivist archivist, AbstractArchive archive) throws IASDeploymentException {
        try {
            Application application = this.request.getDescriptor();
            if (application == null) {
                application = (Application)archivist.readStandardDeploymentDescriptor(archive);
                application.setRegistrationName(this.request.getName());
            }
            return EJBClassPathUtils.getAppClassPath(application, this.request.getDeployedDirectory().getAbsolutePath(), this.getManager());
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected Application loadDescriptors() throws IASDeploymentException {
        Application app = super.loadDescriptors();
        new WsUtil().genWSInfo(app, this.request);
        return app;
    }

    protected final boolean isSystem() throws IASDeploymentException {
        try {
            boolean guardSystemApp;
            boolean isSystem = DeploymentServiceUtils.isSystem(this.getAppName(), this.request.getType());
            boolean bl = guardSystemApp = Boolean.valueOf(System.getProperty("com.sun.aas.deployment.AllowSysAppDeployment", "false")) == false;
            return isSystem && guardSystemApp;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected void generatePolicy() throws IASDeploymentException {
        try {
            String name;
            Application applicationDD = this.request.getDescriptor();
            String linkName = null;
            boolean lastInService = false;
            Iterator iter = applicationDD.getWebBundleDescriptors().iterator();
            while (iter.hasNext()) {
                name = WebSecurityManager.getContextID((WebBundleDescriptor)iter.next());
                lastInService = SecurityUtil.linkPolicyFile(name, linkName, lastInService);
                linkName = name;
            }
            iter = applicationDD.getEjbBundleDescriptors().iterator();
            while (iter.hasNext()) {
                name = EJBSecurityManager.getContextID((EjbBundleDescriptor)iter.next());
                lastInService = SecurityUtil.linkPolicyFile(name, linkName, lastInService);
                linkName = name;
            }
            iter = applicationDD.getWebBundleDescriptors().iterator();
            while (iter.hasNext()) {
                name = WebSecurityManager.getContextID((WebBundleDescriptor)iter.next());
                SecurityUtil.generatePolicyFile(name);
            }
            iter = applicationDD.getEjbBundleDescriptors().iterator();
            while (iter.hasNext()) {
                name = EJBSecurityManager.getContextID((EjbBundleDescriptor)iter.next());
                SecurityUtil.generatePolicyFile(name);
            }
        }
        catch (IASSecurityException se) {
            String msg = localStrings.getString("enterprise.deployment.backend.generate_policy_error", this.request.getName());
            throw new IASDeploymentException(msg, se);
        }
    }

    public void removePolicy() throws IASDeploymentException {
        String name = this.request.getName();
        try {
            String policyRootDir;
            String[] ejbContextIds;
            String[] webcontexts = WebSecurityManagerFactory.getInstance().getAndRemoveContextIdForWebAppName(name);
            if (webcontexts != null) {
                for (int i = 0; i < webcontexts.length; ++i) {
                    if (webcontexts[i] == null) continue;
                    SecurityUtil.removePolicy(webcontexts[i]);
                }
            }
            if ((ejbContextIds = ((EJBSecurityManagerFactory)EJBSecurityManagerFactory.getInstance()).getAndRemoveContextIdForEjbAppName(name)) != null) {
                for (String ejbContextId : ejbContextIds) {
                    if (ejbContextId == null) continue;
                    SecurityUtil.removePolicy(ejbContextId);
                }
            }
            if ((policyRootDir = System.getProperty("com.sun.enterprise.jaccprovider.property.repository")) != null) {
                ArrayList<String> contextIds = new ArrayList<String>();
                File policyDir = new File(policyRootDir + File.separator + name);
                if (policyDir.exists()) {
                    File[] policies = policyDir.listFiles();
                    for (int i = 0; i < policies.length; ++i) {
                        if (!policies[i].isDirectory()) continue;
                        contextIds.add(name + '/' + policies[i].getName());
                    }
                }
                if (contextIds.size() > 0) {
                    for (String cId : contextIds) {
                        SecurityUtil.removePolicy(cId);
                    }
                }
            }
        }
        catch (IASSecurityException ex) {
            String msg = localStrings.getString("enterprise.deployment.backend.remove_policy_error", name);
            this.logger.log(Level.WARNING, msg, ex);
            throw new IASDeploymentException(msg, ex);
        }
    }
}

