/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.exception.DeploymentException;
import com.sun.enterprise.admin.common.exception.ServerInstanceException;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.DeploymentNotificationHelper;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.HostAndPort;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.backend.AppDD;
import com.sun.enterprise.deployment.backend.ClientJarMakerRegistry;
import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentRequestRegistry;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetFactory;
import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.ConnectorModulesManager;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.resource.Resource;
import com.sun.enterprise.resource.ResourcesXMLParser;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentServiceUtils {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(DeploymentServiceUtils.class);
    private static final Object[] emptyParams = new Object[0];
    private static final String[] emptySignature = new String[0];
    private static final String CREATE_J2EE_APPLICATION = "createJ2eeApplication";
    private static final String CREATE_EJB_MODULE = "createEjbModule";
    private static final String CREATE_WEB_MODULE = "createWebModule";
    private static final String CREATE_CONNECTOR_MODULE = "createConnectorModule";
    private static final String CREATE_APPCLIENT_MODULE = "createAppclientModule";
    private static final String GET_J2EE_APPLICATION = "getJ2eeApplicationByName";
    private static final String GET_EJB_MODULE = "getEjbModuleByName";
    private static final String GET_WEB_MODULE = "getWebModuleByName";
    private static final String GET_CONNECTOR_MODULE = "getConnectorModuleByName";
    private static final String GET_APPCLIENT_MODULE = "getAppclientModuleByName";
    private static final String REMOVE_J2EE_APPLICATION = "removeJ2eeApplicationByName";
    private static final String REMOVE_EJB_MODULE = "removeEjbModuleByName";
    private static final String REMOVE_WEB_MODULE = "removeWebModuleByName";
    private static final String REMOVE_CONNECTOR_MODULE = "removeConnectorModuleByName";
    private static final String REMOVE_APPCLIENT_MODULE = "removeAppclientModuleByName";
    private static final String appsConfigMBeanName = "com.sun.appserv:type=applications,category=config";
    private static final String SYSTEM_PREFIX = "system-";
    private static final String ADMIN_VS = "__asadmin";
    private static final String PORT = "port";
    private static final String DEF_VS = "default-virtual-server";
    private static final String SERVER_NAME = "server-name";
    private static final String REDIRECT_PORT = "redirect-port";
    private static final String SEC_ENABLED = "security-enabled";
    private static final String LISTENER_ENABLED = "enabled";
    private static final String OBJECT_TYPE = "object-type";
    private static final String HOSTS = "hosts";
    private static final String HTTP_LISTENERS = "http_listeners";
    private static final String DEFAULT_WEB_MODULE = "default_web_module";
    private static final String STATE = "state";
    private static final String ID = "id";
    private static final String SUN_RESOURCE_XML = "sun-resources.xml";
    private static final String SUN_RESOURCE_XML_PATH = "META-INF" + File.separator + "sun-resources.xml";
    private static final DeployableObjectType[] deployableObjectTypes = new DeployableObjectType[]{DeployableObjectType.APP, DeployableObjectType.EJB, DeployableObjectType.WEB, DeployableObjectType.CONN, DeployableObjectType.CAR};
    private static String[] httpListenerAttrNames = new String[]{"enabled", "default-virtual-server", "server-name", "redirect-port", "port", "security-enabled", "id"};
    private static String[] vsAttrNames = new String[]{"hosts", "http_listeners", "default_web_module", "state", "id"};

    public static String getClientJarPath(String moduleID) {
        ClientJarMakerRegistry registry = ClientJarMakerRegistry.getInstance();
        if (registry.isRegistered(moduleID)) {
            registry.waitForCompletion(moduleID);
        }
        return moduleID + "Client.jar";
    }

    static boolean multicastEvent(int eventType, String entityName, String targetName) throws IASDeploymentException {
        return DeploymentServiceUtils.multicastEvent(eventType, entityName, null, targetName);
    }

    static boolean multicastEvent(int eventType, String entityName, String moduleType, String targetName) throws IASDeploymentException {
        return DeploymentServiceUtils.multicastEvent(eventType, entityName, moduleType, false, targetName);
    }

    static boolean multicastEvent(int eventType, String entityName, String moduleType, boolean cascade, String targetName) throws IASDeploymentException {
        return DeploymentServiceUtils.multicastEvent(eventType, entityName, moduleType, cascade, false, targetName);
    }

    static boolean multicastEvent(int eventType, String entityName, String moduleType, boolean cascade, boolean forceDeploy, String targetName) throws IASDeploymentException {
        return DeploymentServiceUtils.multicastEvent(eventType, entityName, moduleType, cascade, forceDeploy, 0, targetName);
    }

    public static boolean multicastEvent(int eventType, String entityName, String moduleType, boolean cascade, boolean forceDeploy, int loadUnloadAction, String targetName) throws IASDeploymentException {
        try {
            ConfigContext config = DeploymentServiceUtils.getConfigContext();
            if (config != null && config.isChanged()) {
                config.flush();
            }
        }
        catch (ConfigException ce) {
            throw new IASDeploymentException(ce);
        }
        try {
            return DeploymentNotificationHelper.multicastEvent(eventType, entityName, moduleType, cascade, forceDeploy, loadUnloadAction, targetName);
        }
        catch (Throwable t) {
            IASDeploymentException iasEx = new IASDeploymentException(t.getMessage());
            iasEx.initCause(t);
            throw iasEx;
        }
    }

    public static String getModuleTypeString(DeployableObjectType moduleType) {
        String moduleTypeString = null;
        if (moduleType.equals(DeployableObjectType.EJB)) {
            moduleTypeString = "ejb";
        } else if (moduleType.equals(DeployableObjectType.WEB)) {
            moduleTypeString = "web";
        } else if (moduleType.equals(DeployableObjectType.CONN)) {
            moduleTypeString = "connector";
        } else if (moduleType.equals(DeployableObjectType.CAR)) {
            moduleTypeString = "appclient";
        }
        return moduleTypeString;
    }

    public static BaseManager getInstanceManager(DeployableObjectType moduleType) {
        try {
            InstanceEnvironment insEnv = new InstanceEnvironment(DeploymentServiceUtils.getInstanceName());
            if (moduleType.equals(DeployableObjectType.APP)) {
                return new AppsManager(insEnv);
            }
            if (moduleType.equals(DeployableObjectType.EJB)) {
                return new EjbModulesManager(insEnv);
            }
            if (moduleType.equals(DeployableObjectType.WEB)) {
                return new WebModulesManager(insEnv);
            }
            if (moduleType.equals(DeployableObjectType.CONN)) {
                return new ConnectorModulesManager(insEnv);
            }
            if (moduleType.equals(DeployableObjectType.CAR)) {
                return new AppclientModulesManager(insEnv);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] getContextRootsForEmbeddedWebApp(String appName) throws IASDeploymentException {
        try {
            AppsManager appsManager = new AppsManager(new InstanceEnvironment(DeploymentServiceUtils.getInstanceName()));
            Application application = appsManager.getRegisteredDescriptor(appName);
            if (application != null) {
                ArrayList<String> contextRoots = new ArrayList<String>();
                for (WebBundleDescriptor wbd : application.getWebBundleDescriptors()) {
                    contextRoots.add(wbd.getContextRoot());
                }
                return contextRoots.toArray(new String[contextRoots.size()]);
            }
            String xmlDir = appsManager.getGeneratedXMLLocation(appName);
            if (!FileUtils.safeIsDirectory(xmlDir)) {
                String appDir = appsManager.getLocation(appName);
                sLogger.log(Level.WARNING, "core.no_xmldir", new Object[]{xmlDir, appDir});
                xmlDir = appDir;
            }
            AppDD appDD = new AppDD(new File(xmlDir));
            return appDD.getContextRoots();
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public static List<String> getTargetNamesFromTargetString(String targetString) {
        if (targetString == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(targetString);
        ArrayList<String> targetNames = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            targetNames.add(st.nextToken());
        }
        return targetNames;
    }

    public static void setResourceOptionsInRequest(DeploymentRequest req, DeploymentProperties props) {
        req.setResourceAction(props.getResourceAction());
        req.setResourceTargetList(props.getResourceTargetList());
    }

    public static FilenameFilter getFilenameFilter(final String fileName) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (new File(dir, name).isDirectory()) {
                    return true;
                }
                return name != null && name.equals(fileName);
            }
        };
        return filter;
    }

    public static List<Resource> getResources(String appId, DeployableObjectType moduleType) {
        try {
            String directoryToLook = DeploymentServiceUtils.getInstanceManager(moduleType).getGeneratedXMLLocation(appId);
            Set listOfFiles = FileUtil.getAllFilesUnder(new File(directoryToLook), DeploymentServiceUtils.getFilenameFilter(SUN_RESOURCE_XML), true);
            ArrayList<String> expectedXMLPaths = new ArrayList<String>();
            Application app = DeploymentServiceUtils.getInstanceManager(moduleType).getRegisteredDescriptor(appId);
            if (app != null) {
                if (app.isVirtual()) {
                    expectedXMLPaths.add(SUN_RESOURCE_XML_PATH);
                } else {
                    expectedXMLPaths.add(SUN_RESOURCE_XML_PATH);
                    Iterator itr = app.getModules();
                    while (itr.hasNext()) {
                        ModuleDescriptor aModule = (ModuleDescriptor)itr.next();
                        String moduleUri = FileUtils.makeFriendlyFileName(aModule.getArchiveUri());
                        String subModulePath = moduleUri + File.separator + SUN_RESOURCE_XML_PATH;
                        expectedXMLPaths.add(subModulePath);
                    }
                }
            } else {
                expectedXMLPaths.add(SUN_RESOURCE_XML_PATH);
            }
            HashMap<String, List<Resource>> resourcesListMap = new HashMap<String, List<Resource>>();
            for (File file : listOfFiles) {
                String filePath = file.getPath();
                String xmlFilePath = new File(directoryToLook, filePath).getAbsolutePath();
                if (expectedXMLPaths.contains(filePath)) {
                    ResourcesXMLParser allResources = new ResourcesXMLParser(xmlFilePath);
                    resourcesListMap.put(filePath, allResources.getResourcesList());
                    continue;
                }
                sLogger.log(Level.WARNING, "enterprise.deployment.ignore.sun.resources.xml", xmlFilePath);
            }
            return DeploymentServiceUtils.simpleProcessResourcesListMap(resourcesListMap);
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "enterprise.deployment.error.get.resources", e.getMessage());
            return new ArrayList<Resource>();
        }
    }

    private static List<Resource> simpleProcessResourcesListMap(HashMap<String, List<Resource>> resourcesListMap) {
        ArrayList<Resource> globalList = new ArrayList<Resource>();
        Iterator<List<Resource>> mapIter = resourcesListMap.values().iterator();
        while (mapIter.hasNext()) {
            globalList.addAll((Collection<Resource>)mapIter.next());
        }
        return globalList;
    }

    private static List<Resource> processResourcesListMap(HashMap<String, List<Resource>> resourcesListMap) {
        boolean hasTopLevel = false;
        ArrayList<Resource> globalResourcesList = new ArrayList<Resource>();
        for (String path : resourcesListMap.keySet()) {
            if (path.equals(SUN_RESOURCE_XML_PATH)) {
                hasTopLevel = true;
                continue;
            }
            DeploymentServiceUtils.processResourceListForXMLPath(globalResourcesList, resourcesListMap, path);
        }
        if (hasTopLevel) {
            DeploymentServiceUtils.processResourceListForXMLPath(globalResourcesList, resourcesListMap, SUN_RESOURCE_XML_PATH);
        }
        return globalResourcesList;
    }

    private static void processResourceListForXMLPath(List<Resource> globalResourcesList, HashMap<String, List<Resource>> resourcesListMap, String xmlPath) {
        List<Resource> resourcesList = resourcesListMap.get(xmlPath);
        for (Resource newResource : resourcesList) {
            for (Resource resourceInList : globalResourcesList) {
                if (!newResource.equals(resourceInList) && !newResource.isAConflict(resourceInList)) continue;
                globalResourcesList.remove(resourceInList);
                break;
            }
            globalResourcesList.add(newResource);
        }
    }

    public static String getLocation(File appDir) {
        if (appDir != null) {
            return RelativePathResolver.unresolvePath(appDir.getAbsolutePath(), new String[]{"com.sun.aas.instanceRoot", "com.sun.aas.installRoot"});
        }
        return null;
    }

    public static String getLocation(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appId}, new String[]{"java.lang.String"});
            String location = (String)mbs.getAttribute(componentON, "location");
            return new RelativePathResolver().resolve(location);
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isEnabled(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appId}, new String[]{"java.lang.String"});
            String enabled = (String)mbs.getAttribute(componentON, LISTENER_ENABLED);
            return Boolean.valueOf(enabled);
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isDirectoryDeployed(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appId}, new String[]{"java.lang.String"});
            String directoryDeployed = (String)mbs.getAttribute(componentON, "directory-deployed");
            return Boolean.valueOf(directoryDeployed);
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static String getObjectType(String appId, DeployableObjectType type) throws IASDeploymentException {
        try {
            if (type.isCAR()) {
                return null;
            }
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appId}, new String[]{"java.lang.String"});
            String objectType = (String)mbs.getAttribute(componentON, OBJECT_TYPE);
            return objectType;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static void setContextRoot(String appId, DeployableObjectType type, String contextRoot) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appId}, new String[]{"java.lang.String"});
            if (contextRoot != null && contextRoot.length() > 0) {
                Attribute contextRootAttr = new Attribute("context-root", contextRoot);
                mbs.setAttribute(componentON, contextRootAttr);
            }
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isSystem(String appId, DeployableObjectType type) throws IASDeploymentException {
        String objectType = DeploymentServiceUtils.getObjectType(appId, type);
        if (objectType != null) {
            return objectType.startsWith(SYSTEM_PREFIX);
        }
        return false;
    }

    private static AttributeList populateAttributeList(DeploymentRequest request) throws IASDeploymentException {
        Properties optionalAttributes;
        String dirDeployed;
        String availEnabled;
        String contextRoot;
        String libraries;
        String jwsEnabled;
        String enabled;
        String description;
        String location;
        AttributeList attrList = new AttributeList();
        String name = request.getName();
        if (name != null && name.length() > 0) {
            Attribute nameAttr = new Attribute("name", name);
            attrList.add(nameAttr);
        }
        if ((location = DeploymentServiceUtils.getLocation(request.getDeployedDirectory())) != null && location.length() > 0) {
            Attribute locationAttr = new Attribute("location", location);
            attrList.add(locationAttr);
        }
        if ((description = request.getDescription()) != null && description.length() > 0) {
            Attribute descriptionAttr = new Attribute("description", description);
            attrList.add(descriptionAttr);
        }
        if (!request.getType().isCAR() && (enabled = String.valueOf(request.isStartOnDeploy())) != null && enabled.length() > 0) {
            Attribute enableAttr = new Attribute(LISTENER_ENABLED, enabled);
            attrList.add(enableAttr);
        }
        if ((request.getType().isAPP() || request.getType().isCAR()) && (jwsEnabled = String.valueOf(request.isJavaWebStartEnabled())) != null && jwsEnabled.length() > 0) {
            Attribute jwsEnableAttr = new Attribute("java-web-start-enabled", jwsEnabled);
            attrList.add(jwsEnableAttr);
        }
        if ((request.getType().isAPP() || request.getType().isEJB() || request.getType().isWEB()) && (libraries = request.getLibraries()) != null && libraries.length() > 0) {
            Attribute librariesAttr = new Attribute("libraries", libraries);
            attrList.add(librariesAttr);
        }
        if (request.getType().isWEB() && (contextRoot = request.getContextRoot()) != null && contextRoot.length() > 0) {
            Attribute contextRootAttr = new Attribute("context-root", contextRoot);
            attrList.add(contextRootAttr);
        }
        if (!request.getType().isCAR() && !request.getType().isCONN() && (availEnabled = String.valueOf(request.isAvailabilityEnabled())) != null && availEnabled.length() > 0) {
            Attribute availEnabledAttr = new Attribute("availability-enabled", availEnabled);
            attrList.add(availEnabledAttr);
        }
        if ((dirDeployed = String.valueOf(request.isDirectory())) != null && dirDeployed.length() > 0) {
            Attribute dirDeployedAttr = new Attribute("directory-deployed", dirDeployed);
            attrList.add(dirDeployedAttr);
        }
        if ((optionalAttributes = request.getOptionalAttributes()) != null) {
            Properties mProps = (Properties)optionalAttributes.clone();
            try {
                mProps.remove("virtual-servers");
            }
            catch (Exception re) {
                // empty catch block
            }
            Enumeration<Object> tags = mProps.keys();
            while (tags.hasMoreElements()) {
                String tag = (String)tags.nextElement();
                String value = mProps.getProperty(tag);
                if (!(tag != null & tag.length() > 0) || value == null || value.length() <= 0) continue;
                Attribute optionalAttr = new Attribute(tag, value);
                attrList.add(optionalAttr);
            }
        }
        return attrList;
    }

    public static void addToConfig(DeploymentRequest request) throws IASDeploymentException {
        try {
            DeployableObjectType type = request.getType();
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            String createOperationName = DeploymentServiceUtils.getCreateOperationName(type);
            AttributeList attrList = DeploymentServiceUtils.populateAttributeList(request);
            String[] signature = new String[]{AttributeList.class.getName()};
            Object[] params = new Object[]{attrList};
            mbs.invoke(appsConfigMBean, createOperationName, params, signature);
            DeploymentServiceUtils.getConfigContext().flush();
            DeploymentServiceUtils.getConfigContext().resetConfigChangeList();
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public static void updateConfig(DeploymentRequest request) throws IASDeploymentException {
        try {
            String name = request.getName();
            ConfigBean appBean = ApplicationHelper.findApplication(DeploymentServiceUtils.getConfigContext(), name);
            if (appBean != null) {
                for (Attribute attr : DeploymentServiceUtils.populateAttributeList(request)) {
                    appBean.setAttributeValue(attr.getName(), (String)attr.getValue());
                }
                DeploymentServiceUtils.getConfigContext().flush();
                DeploymentServiceUtils.getConfigContext().resetConfigChangeList();
            }
        }
        catch (Exception e) {
            if (e instanceof IASDeploymentException) {
                throw (IASDeploymentException)e;
            }
            throw new IASDeploymentException(e);
        }
    }

    public static void removeFromConfig(String name, DeployableObjectType type) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{name}, new String[]{"java.lang.String"});
            if (componentON != null) {
                String removeOperationName = DeploymentServiceUtils.getRemoveOperationName(type);
                mbs.invoke(appsConfigMBean, removeOperationName, new Object[]{name}, new String[]{"java.lang.String"});
                DeploymentServiceUtils.getConfigContext().flush();
                DeploymentServiceUtils.getConfigContext().resetConfigChangeList();
            }
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static boolean isRegistered(String appName, DeployableObjectType type) throws IASDeploymentException {
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            String getOperationName = DeploymentServiceUtils.getGetOperationName(type);
            ObjectName appsConfigMBean = new ObjectName(appsConfigMBeanName);
            ObjectName componentON = null;
            try {
                componentON = (ObjectName)mbs.invoke(appsConfigMBean, getOperationName, new Object[]{appName}, new String[]{"java.lang.String"});
            }
            catch (Exception cn) {
                // empty catch block
            }
            return componentON != null;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static ConfigContext getConfigContext() {
        try {
            AdminService adminService = AdminService.getAdminService();
            if (adminService != null) {
                ConfigContext config = adminService.getAdminContext().getAdminConfigContext();
                return config;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getInstanceName() {
        return ApplicationServer.getServerContext().getInstanceName();
    }

    public static String getDomainName() throws IASDeploymentException {
        try {
            AdminService adminService = AdminService.getAdminService();
            if (adminService != null) {
                String domainName = adminService.getAdminContext().getDomainName();
                return domainName;
            }
            return null;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    public static void validate(String appID, DeployableObjectType type, String action) throws IASDeploymentException {
        boolean allowSystemAppModification = Boolean.valueOf(System.getProperty("com.sun.aas.deployment.AllowSysAppDeployment", "false"));
        if (allowSystemAppModification) {
            return;
        }
        if (DeploymentServiceUtils.isSystem(appID, type)) {
            String msg = localStrings.getString("enterprise.deployment.phasing.component_is_system", new Object[]{action, appID});
            throw new IASDeploymentException(msg);
        }
    }

    public static void checkWebModuleReferences(String webModuleName) throws IASDeploymentException {
        ArrayList<String> virtualServerIds = new ArrayList<String>();
        try {
            Config config = (Config)ConfigBeansFactory.getConfigBeanByXPath(DeploymentServiceUtils.getConfigContext(), "/domain/configs/config[@name='server-config']");
            HttpService httpService = config.getHttpService();
            VirtualServer[] virtualServers = httpService.getVirtualServer();
            for (int j = 0; j < virtualServers.length; ++j) {
                VirtualServer aServer = virtualServers[j];
                String defWebModule = aServer.getDefaultWebModule();
                if (defWebModule == null || !defWebModule.equals(webModuleName)) continue;
                virtualServerIds.add(aServer.getId());
            }
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
        if (!virtualServerIds.isEmpty()) {
            throw new IASDeploymentException(localStrings.getString("enterprise.deployment.phasing.def_web_module_refs_exist", virtualServerIds.toString(), webModuleName));
        }
    }

    public static void checkAbort(String moduleID) throws IASDeploymentException {
        DeploymentRequest request = DeploymentRequestRegistry.getRegistry().getDeploymentRequest(moduleID);
        if (request != null && request.isAborted()) {
            DeploymentRequestRegistry.getRegistry().removeDeploymentRequest(moduleID);
            String msg = localStrings.getString("enterprise.deployment.phasing.operation.abort", new Object[]{moduleID});
            throw new IASDeploymentException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DeployableObjectType getTypeFromFile(String name, String filePath) throws DeploymentException {
        if (filePath == null) {
            throw new DeploymentException("deploy file not specified");
        }
        try {
            if (!filePath.endsWith(".class")) {
                Archivist archivist = ArchivistFactory.getArchivistForArchive(filePath);
                ModuleType moduleType = archivist.getModuleType();
                return DeploymentServiceUtils.getDeployableObjectType(moduleType);
            }
            StringTokenizer tk = new StringTokenizer(name, "_");
            File f = new File(filePath);
            for (int i = 0; i < tk.countTokens(); f = f.getParentFile(), ++i) {
            }
            try {
                URL[] urls = new URL[]{f.toURL()};
                URLClassLoader cLoader = new URLClassLoader(urls, DeploymentServiceUtils.class.getClassLoader());
                String className = name.replaceAll("_", ".");
                Class<?> clazz = cLoader.loadClass(className);
                if (clazz != null && clazz.getAnnotation(Stateless.class) != null) {
                    return DeployableObjectType.EJB;
                }
                return DeployableObjectType.WEB;
            }
            catch (Exception e) {
                return DeployableObjectType.WEB;
            }
        }
        catch (Exception ex) {
            DeploymentException de = new DeploymentException(localStrings.getString("enterprise.deployment.unknown.application.type", filePath));
            de.initCause(ex);
            throw de;
        }
    }

    public static DeploymentTarget getAndValidateDeploymentTarget(String targetName, String appName, boolean isDeleting) throws IASDeploymentException {
        try {
            DeploymentTarget target = DeploymentTargetFactory.getDeploymentTargetFactory().getTarget(DeploymentServiceUtils.getConfigContext(), DeploymentServiceUtils.getDomainName(), targetName);
            if (targetName == null) {
                targetName = target.getTarget().getName();
            }
            if (target.getTarget().getType() == TargetType.SERVER || target.getTarget().getType() == TargetType.DAS) {
                if (isDeleting) {
                    if (!ServerHelper.serverReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                        throw new IASDeploymentException(localStrings.getString("serverApplicationRefDoesNotExist", targetName, appName));
                    }
                } else if (ServerHelper.serverReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                    throw new IASDeploymentException(localStrings.getString("serverApplicationRefAlreadyExists", appName, targetName));
                }
            } else if (target.getTarget().getType() == TargetType.CLUSTER) {
                if (isDeleting) {
                    if (!ClusterHelper.clusterReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                        throw new IASDeploymentException(localStrings.getString("clusterApplicationRefDoesNotExist", targetName, appName));
                    }
                } else if (ClusterHelper.clusterReferencesApplication(DeploymentServiceUtils.getConfigContext(), targetName, appName)) {
                    throw new IASDeploymentException(localStrings.getString("clusterApplicationRefAlreadyExists", appName, targetName));
                }
            }
            return target;
        }
        catch (IASDeploymentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IASDeploymentException(ex);
        }
    }

    public static void setHostAndPort(DeploymentRequest req) throws ServerInstanceException {
        String virtualServers = (String)req.getOptionalAttributes().get("virtual-servers");
        if (virtualServers == null) {
            HostAndPort hap = DeploymentServiceUtils.getHostAndPort(false);
            if (hap != null) {
                req.setHttpHostName(DeploymentServiceUtils.getHostName(hap));
                req.setHttpPort(DeploymentServiceUtils.getPort(hap, false));
            }
            if ((hap = DeploymentServiceUtils.getHostAndPort(true)) != null) {
                req.setHttpsHostName(DeploymentServiceUtils.getHostName(hap));
                req.setHttpsPort(DeploymentServiceUtils.getPort(hap, true));
            }
        } else {
            StringTokenizer st = new StringTokenizer(virtualServers, ",");
            if (st.hasMoreTokens()) {
                String aVirtualServer = st.nextToken();
                HostAndPort hap = DeploymentServiceUtils.getVirtualServerHostAndPort(aVirtualServer, false);
                if (hap != null) {
                    req.setHttpHostName(DeploymentServiceUtils.getHostName(hap));
                    req.setHttpPort(DeploymentServiceUtils.getPort(hap, false));
                }
                if ((hap = DeploymentServiceUtils.getVirtualServerHostAndPort(aVirtualServer, true)) != null) {
                    req.setHttpsHostName(DeploymentServiceUtils.getHostName(hap));
                    req.setHttpsPort(DeploymentServiceUtils.getPort(hap, true));
                }
            }
        }
    }

    private static String getHostName(HostAndPort hap) {
        String hostName = hap.getHost();
        if (hostName == null || hostName.trim().equals("")) {
            hostName = DeploymentServiceUtils.getDefaultHostName();
        }
        return hostName;
    }

    private static String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException uhe) {
            sLogger.log(Level.FINEST, "mbean.get_local_host_error", uhe);
            sLogger.log(Level.INFO, "mbean.use_default_host");
        }
        return defaultHostName;
    }

    private static int getPort(HostAndPort hap, boolean securityEnabled) {
        int port = hap.getPort();
        if (port == 0) {
            port = DeploymentServiceUtils.getDefaultPort(securityEnabled);
        }
        return port;
    }

    private static int getDefaultPort(boolean securityEnabled) {
        int port = 0;
        port = securityEnabled ? 8181 : 8080;
        sLogger.log(Level.INFO, "mbean.use_default_port", String.valueOf(port));
        return port;
    }

    private static Object getNamedAttributeValue(AttributeList attrs, String attrName) {
        if (attrs == null || attrName == null) {
            return null;
        }
        Object value = null;
        for (Attribute attr : attrs) {
            if (!attrName.equals(attr.getName())) continue;
            value = attr.getValue();
            break;
        }
        return value;
    }

    private static HostAndPort getHostAndPort(boolean securityEnabled) throws ServerInstanceException {
        HostAndPort hAndp = null;
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName objectName = new ObjectName(DeploymentServiceUtils.getDomainName() + ":type=configs,category=config");
            String operationName1 = "getConfig";
            ObjectName[] configs = (ObjectName[])mbs.invoke(objectName, operationName1, emptyParams, emptySignature);
            String configName = (String)mbs.getAttribute(configs[0], "name");
            ObjectName httpService = new ObjectName(DeploymentServiceUtils.getDomainName() + ":type=http-service,config=" + configName + ",category=config");
            String operationName2 = "getHttpListener";
            ObjectName[] httpListener = (ObjectName[])mbs.invoke(httpService, operationName2, emptyParams, emptySignature);
            String serverName = null;
            int port = 0;
            for (int i = 0; i < httpListener.length; ++i) {
                boolean sec_on;
                String vs;
                boolean enabled;
                AttributeList attrs = mbs.getAttributes(httpListener[i], httpListenerAttrNames);
                Boolean bb = Boolean.valueOf((String)DeploymentServiceUtils.getNamedAttributeValue(attrs, LISTENER_ENABLED));
                boolean bl = enabled = bb == null ? false : bb;
                if (!enabled || ADMIN_VS.equals(vs = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, DEF_VS))) continue;
                bb = Boolean.valueOf((String)DeploymentServiceUtils.getNamedAttributeValue(attrs, SEC_ENABLED));
                boolean bl2 = sec_on = bb == null ? false : bb;
                if (securityEnabled != sec_on) continue;
                serverName = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, SERVER_NAME);
                if (serverName == null || serverName.trim().equals("")) {
                    serverName = DeploymentServiceUtils.getDefaultHostName();
                }
                String portStr = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, PORT);
                String redirPort = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, REDIRECT_PORT);
                if (redirPort != null && !redirPort.trim().equals("")) {
                    portStr = redirPort;
                }
                String resolvedPort = new PropertyResolver(DeploymentServiceUtils.getConfigContext(), DeploymentServiceUtils.getInstanceName()).resolve(portStr);
                port = Integer.parseInt(resolvedPort);
                break;
            }
            hAndp = new HostAndPort(serverName, port);
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return hAndp;
    }

    private static HostAndPort getVirtualServerHostAndPort(String vs, boolean securityEnabled) throws ServerInstanceException {
        String serverName = null;
        int port = 0;
        try {
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            ObjectName objectName = new ObjectName(DeploymentServiceUtils.getDomainName() + ":type=configs,category=config");
            String operationName1 = "getConfig";
            ObjectName[] configs = (ObjectName[])mbs.invoke(objectName, operationName1, emptyParams, emptySignature);
            String configName = (String)mbs.getAttribute(configs[0], "name");
            ObjectName httpService = new ObjectName(DeploymentServiceUtils.getDomainName() + ":type=http-service,config=" + configName + ",category=config");
            String operationName2 = "getHttpListener";
            ObjectName[] httpListener = (ObjectName[])mbs.invoke(httpService, operationName2, emptyParams, emptySignature);
            operationName2 = "getVirtualServer";
            ObjectName[] virtualServer = (ObjectName[])mbs.invoke(httpService, operationName2, emptyParams, emptySignature);
            for (int i = 0; i < virtualServer.length; ++i) {
                AttributeList vsAttrs = mbs.getAttributes(virtualServer[i], vsAttrNames);
                String id = (String)DeploymentServiceUtils.getNamedAttributeValue(vsAttrs, ID);
                if (!id.equals(vs)) continue;
                String httpListeners = (String)DeploymentServiceUtils.getNamedAttributeValue(vsAttrs, "http-listeners");
                String vsHttpListener = null;
                List httpListenerList = StringUtils.parseStringList(httpListeners, " ,");
                ListIterator hlListIter = httpListenerList.listIterator();
                while (hlListIter.hasNext()) {
                    vsHttpListener = (String)hlListIter.next();
                    for (int j = 0; j < httpListener.length; ++j) {
                        boolean sec_on;
                        boolean enabled;
                        AttributeList attrs = mbs.getAttributes(httpListener[j], httpListenerAttrNames);
                        String listenerId = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, ID);
                        if (!listenerId.equals(vsHttpListener)) continue;
                        Boolean bb = Boolean.valueOf((String)DeploymentServiceUtils.getNamedAttributeValue(attrs, LISTENER_ENABLED));
                        boolean bl = enabled = bb == null ? false : bb;
                        if (!enabled) continue;
                        bb = Boolean.valueOf((String)DeploymentServiceUtils.getNamedAttributeValue(attrs, SEC_ENABLED));
                        boolean bl2 = sec_on = bb == null ? false : bb;
                        if (securityEnabled != sec_on) continue;
                        serverName = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, SERVER_NAME);
                        if (serverName == null || serverName.trim().equals("")) {
                            serverName = DeploymentServiceUtils.getDefaultHostName();
                        }
                        String portStr = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, PORT);
                        String redirPort = (String)DeploymentServiceUtils.getNamedAttributeValue(attrs, REDIRECT_PORT);
                        if (redirPort != null && !redirPort.trim().equals("")) {
                            portStr = redirPort;
                        }
                        String resolvedPort = new PropertyResolver(DeploymentServiceUtils.getConfigContext(), DeploymentServiceUtils.getInstanceName()).resolve(portStr);
                        port = Integer.parseInt(resolvedPort);
                        return new HostAndPort(serverName, port);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ServerInstanceException(e.getLocalizedMessage());
        }
        return null;
    }

    public static DeploymentTarget getDeploymentTarget(String targetName) throws IASDeploymentException {
        try {
            DeploymentTarget target = DeploymentTargetFactory.getDeploymentTargetFactory().getTarget(DeploymentServiceUtils.getConfigContext(), DeploymentServiceUtils.getDomainName(), targetName);
            return target;
        }
        catch (IASDeploymentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IASDeploymentException(ex);
        }
    }

    public static void checkAppReferencesBeforeUndeployFromDomain(String appName) throws IASDeploymentException {
        try {
            if (ApplicationHelper.isApplicationReferenced(DeploymentServiceUtils.getConfigContext(), appName)) {
                throw new IASDeploymentException(localStrings.getString("applicationIsReferenced", appName, ApplicationHelper.getApplicationReferenceesAsString(DeploymentServiceUtils.getConfigContext(), appName)));
            }
        }
        catch (IASDeploymentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IASDeploymentException(ex);
        }
    }

    public static DeployableObjectType getRegisteredType(String name) throws DeploymentException {
        try {
            for (int i = 0; i < deployableObjectTypes.length; ++i) {
                if (!DeploymentServiceUtils.isRegistered(name, deployableObjectTypes[i])) continue;
                return deployableObjectTypes[i];
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage());
        }
        String msg = localStrings.getString("enterprise.deployment.component.not.registered", name);
        throw new DeploymentException(msg);
    }

    static String getCreateOperationName(DeployableObjectType type) throws IASDeploymentException {
        if (type.isAPP()) {
            return CREATE_J2EE_APPLICATION;
        }
        if (type.isEJB()) {
            return CREATE_EJB_MODULE;
        }
        if (type.isWEB()) {
            return CREATE_WEB_MODULE;
        }
        if (type.isCONN()) {
            return CREATE_CONNECTOR_MODULE;
        }
        if (type.isCAR()) {
            return CREATE_APPCLIENT_MODULE;
        }
        return null;
    }

    static String getGetOperationName(DeployableObjectType type) throws IASDeploymentException {
        if (type.isAPP()) {
            return GET_J2EE_APPLICATION;
        }
        if (type.isEJB()) {
            return GET_EJB_MODULE;
        }
        if (type.isWEB()) {
            return GET_WEB_MODULE;
        }
        if (type.isCONN()) {
            return GET_CONNECTOR_MODULE;
        }
        if (type.isCAR()) {
            return GET_APPCLIENT_MODULE;
        }
        return null;
    }

    static String getRemoveOperationName(DeployableObjectType type) throws IASDeploymentException {
        if (type.isAPP()) {
            return REMOVE_J2EE_APPLICATION;
        }
        if (type.isEJB()) {
            return REMOVE_EJB_MODULE;
        }
        if (type.isWEB()) {
            return REMOVE_WEB_MODULE;
        }
        if (type.isCONN()) {
            return REMOVE_CONNECTOR_MODULE;
        }
        if (type.isCAR()) {
            return REMOVE_APPCLIENT_MODULE;
        }
        return null;
    }

    public static DeployableObjectType getDeployableObjectType(ModuleType type) {
        if (ModuleType.EAR.equals(type)) {
            return DeployableObjectType.APP;
        }
        if (ModuleType.EJB.equals(type)) {
            return DeployableObjectType.EJB;
        }
        if (ModuleType.WAR.equals(type)) {
            return DeployableObjectType.WEB;
        }
        if (ModuleType.CAR.equals(type)) {
            return DeployableObjectType.CAR;
        }
        if (ModuleType.RAR.equals(type)) {
            return DeployableObjectType.CONN;
        }
        return null;
    }
}

