/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeployerFactory;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;

public class UndeployFromDomainPhase
extends DeploymentPhase {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(UndeployFromDomainPhase.class);

    public UndeployFromDomainPhase(DeploymentContext deploymentCtx) {
        this.deploymentCtx = deploymentCtx;
        this.name = "Undeploy";
    }

    public void runPhase(DeploymentPhaseContext phaseCtx) {
        DeploymentStatus status = phaseCtx.getDeploymentStatus();
        DeploymentRequest req = phaseCtx.getDeploymentRequest();
        DeploymentTarget target = (DeploymentTarget)req.getTarget();
        String type = null;
        Deployer deployer = null;
        try {
            if (!req.isApplication()) {
                type = DeploymentServiceUtils.getModuleTypeString(req.getType());
            }
            deployer = DeployerFactory.getDeployer(req);
            deployer.doRequest();
            DeploymentStatus cleanupStatus = new DeploymentStatus(status);
            req.setCurrentDeploymentStatus(cleanupStatus);
            deployer.cleanup();
            DeploymentServiceUtils.removeFromConfig(req.getName(), req.getType());
            status.setStageStatus(2);
            this.postPhaseNotify(this.getPostPhaseEvent(req));
        }
        catch (Throwable t) {
            status.setStageStatus(0);
            status.setStageException(t);
            status.setStageStatusMessage(t.getMessage());
            try {
                if (deployer != null) {
                    deployer.removePolicy();
                }
                DeploymentServiceUtils.removeFromConfig(req.getName(), req.getType());
            }
            catch (Exception eee) {
                // empty catch block
            }
        }
    }

    protected DeploymentEvent getPrePhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(3, new DeploymentEventInfo(req));
    }

    protected DeploymentEvent getPostPhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(4, new DeploymentEventInfo(req));
    }
}

