/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.diagnostics.Archiver;
import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ReportConfig;
import com.sun.enterprise.diagnostics.ReportTarget;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.Harvester;
import com.sun.enterprise.diagnostics.report.html.HTMLReportWriter;
import java.util.zip.ZipFile;

public class ReportGenerator {
    protected ReportConfig config;
    protected Collector harvester;
    protected HTMLReportWriter reportWriter;

    public ReportGenerator(ReportConfig config, Collector harvester, HTMLReportWriter reportWriter) {
        this.config = config;
        this.harvester = harvester;
        this.reportWriter = reportWriter;
    }

    public ZipFile generate() throws DiagnosticException {
        Data data = this.collectData();
        this.writeReportSummary(data);
        return this.archive(this.config.getTarget(), this.config.getCLIOptions().getReportFile());
    }

    private Data collectData() throws DiagnosticException {
        if (this.harvester != null) {
            ((Harvester)this.harvester).initialize();
            return this.harvester.capture();
        }
        throw new DiagnosticException("Harvester null");
    }

    protected void writeReportSummary(Data data) throws DiagnosticException {
        if (this.reportWriter == null) {
            throw new DiagnosticException("HTML Report writer == null");
        }
        this.reportWriter.writeReportSummary(data);
    }

    protected ZipFile archive(ReportTarget target, String archiveName) throws DiagnosticException {
        return new Archiver().archive(this.config.getTarget(), archiveName);
    }
}

